/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.bancodobrasil;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.CertificadoBBDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.ConsultaSolicitacaoBBPayResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.ConsultaSolicitacaoUnicaBBPayResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.IntegracaoSolicitacaoBBPayDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.PagamentoBBPayResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.SolicitacaoBBPayRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.bbpay.SolicitacaoResponseBBPayDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.integracaoboleto.bancodobrasil.BbUtilsService;
import br.com.elotech.tributos.service.integracaoboleto.bancodobrasil.ConsultaPagamentoBBPayService;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class IntegracaoBoletoBBPayService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoBBPayService.class);
    private final BoletoRepository bloquetoRepository;
    private final BloquetoService bloquetoService;
    private final ObjectMapper mapper;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final BbUtilsService bbUtilsService;
    private IntegracaoBoletoPixLog integracaoBoletoPixLog;
    private final ConsultaPagamentoBBPayService consultaPagamentoBBPayService;
    private static final String URL_BBPAY_SOLICITACOES = "solicitacoes";
    public static final String PARAM_TOKEN_PAGINACAO = "tokenPaginacao";
    public static final String PARAM_DATA_PAGAMENTO = "dataPagamento";
    public static final String PARAM_NUMERO_CONVENIO = "numeroConvenio";

    public SolicitacaoResponseBBPayDTO criarSolicitacao(IntegracaoSolicitacaoBBPayDTO integracaoSolicitacaoBBPay) {
        this.integracaoBoletoPixLog = this.iniciarLog();
        Bloqueto bloqueto = (Bloqueto)this.bloquetoService.findById((Serializable)integracaoSolicitacaoBBPay.getIdBloqueto()).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, "Bloqueto n\u00e3o encontrado"));
        ParametroCNAB240 parametroCNAB240 = this.bbUtilsService.getParametroCnab240ByBanco();
        CertificadoBBDTO certificadoBBDTO = this.bbUtilsService.buscarCertificadoBB();
        SolicitacaoBBPayRequestDTO solicitacaoPagamentoDTO = SolicitacaoBBPayRequestDTO.from((IntegracaoSolicitacaoBBPayDTO)integracaoSolicitacaoBBPay, (Bloqueto)bloqueto, (ParametroCNAB240)parametroCNAB240);
        try {
            String urlSolicitacoes = this.montarUrlSolicitacao(null, null);
            this.integracaoBoletoPixLog.setBloqueto(integracaoSolicitacaoBBPay.getIdBloqueto());
            this.integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)solicitacaoPagamentoDTO));
            JsonNode responseSolicitacao = this.bbUtilsService.executarRequisicaoBB(HttpMethod.POST, urlSolicitacoes, (Object)solicitacaoPagamentoDTO, certificadoBBDTO, IntegracaoTokenOperation.BOLETO_HIBRIDO);
            SolicitacaoResponseBBPayDTO solicitacaoPagamentoResponse = (SolicitacaoResponseBBPayDTO)this.mapper.treeToValue((TreeNode)responseSolicitacao, SolicitacaoResponseBBPayDTO.class);
            this.integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)responseSolicitacao));
            this.atualizarDadosBloqueto(solicitacaoPagamentoResponse, bloqueto);
            SolicitacaoResponseBBPayDTO solicitacaoResponseBBPayDTO = solicitacaoPagamentoResponse;
            return solicitacaoResponseBBPayDTO;
        }
        catch (RestException e) {
            String descricaoErros = this.bbUtilsService.tratarErrosBBPay(e);
            this.integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            this.integracaoBoletoPixLog.setDescricaoErro(descricaoErros);
            throw new RestException(e.getStatus(), "Erro ao tentar criar uma solicita\u00e7\u00e3o. Erro na cria\u00e7\u00e3o da solicita\u00e7\u00e3o: " + descricaoErros, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Erro ao criar solicita\u00e7\u00e3o na integra\u00e7\u00e3o BBPay, solicitacao Descri\u00e7\u00e3o: {}", (Object)solicitacaoPagamentoDTO.getGeral().getDescricaoSolicitacao(), (Object)e);
            this.integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(this.integracaoBoletoPixLog);
        }
    }

    public ConsultaSolicitacaoBBPayResponseDTO listarSolicitacoes(Map<String, Object> queryMap) {
        this.integracaoBoletoPixLog = this.iniciarLog();
        Long numeroConvenio = this.validarParametroConvenio(queryMap);
        queryMap.put(PARAM_NUMERO_CONVENIO, numeroConvenio);
        CertificadoBBDTO certificadoBBDTO = this.bbUtilsService.buscarCertificadoBB();
        try {
            String urlSolicitacoes = this.montarUrlSolicitacao(queryMap, null);
            JsonNode responseConsulta = this.bbUtilsService.executarRequisicaoBB(HttpMethod.GET, urlSolicitacoes, null, certificadoBBDTO, IntegracaoTokenOperation.BOLETO_HIBRIDO);
            this.integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)responseConsulta));
            ConsultaSolicitacaoBBPayResponseDTO consultaSolicitacaoBBPayResponseDTO = (ConsultaSolicitacaoBBPayResponseDTO)this.mapper.treeToValue((TreeNode)responseConsulta, ConsultaSolicitacaoBBPayResponseDTO.class);
            return consultaSolicitacaoBBPayResponseDTO;
        }
        catch (RestException e) {
            String descricaoErros = this.bbUtilsService.tratarErrosBBPay(e);
            this.integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            this.integracaoBoletoPixLog.setDescricaoErro(descricaoErros);
            throw new RestException(e.getStatus(), "Erro ao tentar  recuperar solicitacao. Erro na busca da solicitacao: " + descricaoErros, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Erro tentar listar as solicita\u00e7\u00f5es. ", (Throwable)e);
            this.integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(this.integracaoBoletoPixLog);
        }
    }

    public ConsultaSolicitacaoUnicaBBPayResponseDTO buscarSolicitacao(Long numeroSolicitacao, Long numeroConvenio) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        this.integracaoBoletoPixLog = this.iniciarLog();
        CertificadoBBDTO certificadoBBDTO = this.bbUtilsService.buscarCertificadoBB();
        try {
            queryMap.put(PARAM_NUMERO_CONVENIO, numeroConvenio);
            String urlSolicitacoes = this.montarUrlSolicitacao(queryMap, numeroSolicitacao);
            JsonNode responseConsulta = this.bbUtilsService.executarRequisicaoBB(HttpMethod.GET, urlSolicitacoes, null, certificadoBBDTO, IntegracaoTokenOperation.BOLETO_HIBRIDO);
            this.integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)responseConsulta));
            ConsultaSolicitacaoUnicaBBPayResponseDTO consultaSolicitacaoUnicaBBPayResponseDTO = (ConsultaSolicitacaoUnicaBBPayResponseDTO)this.mapper.treeToValue((TreeNode)responseConsulta, ConsultaSolicitacaoUnicaBBPayResponseDTO.class);
            return consultaSolicitacaoUnicaBBPayResponseDTO;
        }
        catch (RestException e) {
            String descricaoErros = this.bbUtilsService.tratarErrosBBPay(e);
            this.integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            this.integracaoBoletoPixLog.setDescricaoErro(descricaoErros);
            throw new RestException(e.getStatus(), "Erro ao tentar recuperar uma solicita\u00e7\u00e3o \u00fanica. Erro: " + descricaoErros, (Throwable)e);
        }
        catch (Exception e) {
            log.error("Erro na busca da solicita\u00e7\u00e3o na integra\u00e7\u00e3o BBPay. {}", (Object)numeroSolicitacao, (Object)e);
            this.integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(this.integracaoBoletoPixLog);
        }
    }

    public void atualizarDadosBloqueto(SolicitacaoResponseBBPayDTO response, Bloqueto bloqueto) {
        Optional.ofNullable(response.getInformacoesPix()).ifPresent(infoPix -> {
            bloqueto.setTextoQrCode(infoPix.getTextoQrCode());
            bloqueto.setTxidPix(infoPix.getTxId());
        });
        Optional.ofNullable(response.getInformacoesBoleto()).ifPresent(infoBoleto -> {
            bloqueto.setCodigoBarras(infoBoleto.getTextoCodigoBarras());
            bloqueto.setCampo1(StringUtils.substring((String)infoBoleto.getLinhaDigitavel(), (int)0, (int)10));
            bloqueto.setCampo2(StringUtils.substring((String)infoBoleto.getLinhaDigitavel(), (int)10, (int)21));
            bloqueto.setCampo3(StringUtils.substring((String)infoBoleto.getLinhaDigitavel(), (int)21, (int)32));
            bloqueto.setCampo4(StringUtils.substring((String)infoBoleto.getLinhaDigitavel(), (int)32, (int)33));
            bloqueto.setCampo5(StringUtils.substring((String)infoBoleto.getLinhaDigitavel(), (int)33, (int)47));
        });
        this.bloquetoRepository.save((Object)bloqueto);
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private IntegracaoBoletoPixLog iniciarLog() {
        this.integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.SOLICITACAO_BBPAY);
        this.integracaoBoletoPixLog.setDataIntegracao(LocalDateTime.now());
        return this.integracaoBoletoPixLog;
    }

    public Long validarParametroConvenio(Map<String, Object> queryMap) {
        return Optional.ofNullable(queryMap.get(PARAM_NUMERO_CONVENIO)).filter(value -> !value.toString().isEmpty()).map(value -> Long.valueOf(value.toString())).orElseThrow(() -> new RestException(HttpStatus.BAD_REQUEST, "Parametro n\u00famero do conv\u00eanio n\u00e3o informado"));
    }

    public PagamentoBBPayResponseDTO getPixPagosBBPay(LocalDate data, Long numeroConvenio) {
        return this.getPixPagosBBPay(data, null, numeroConvenio);
    }

    public PagamentoBBPayResponseDTO getPixPagosBBPay(LocalDate data, String tokenPaginacao, Long numeroConvenio) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(PARAM_DATA_PAGAMENTO, data);
        queryMap.put(PARAM_NUMERO_CONVENIO, numeroConvenio);
        if (tokenPaginacao != null) {
            queryMap.put(PARAM_TOKEN_PAGINACAO, tokenPaginacao);
        }
        return this.consultaPagamentoBBPayService.listarPagamentos(queryMap);
    }

    public String montarUrlSolicitacao(Map<String, Object> queryMap, Long numeroSolicitacao) {
        String urlSolicitacao = numeroSolicitacao != null ? String.format("%s/%d", URL_BBPAY_SOLICITACOES, numeroSolicitacao) : URL_BBPAY_SOLICITACOES;
        return this.bbUtilsService.montarUrlBbPay(urlSolicitacao, queryMap);
    }

    @Generated
    public IntegracaoBoletoBBPayService(BoletoRepository bloquetoRepository, BloquetoService bloquetoService, ObjectMapper mapper, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, BbUtilsService bbUtilsService, ConsultaPagamentoBBPayService consultaPagamentoBBPayService) {
        this.bloquetoRepository = bloquetoRepository;
        this.bloquetoService = bloquetoService;
        this.mapper = mapper;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.bbUtilsService = bbUtilsService;
        this.consultaPagamentoBBPayService = consultaPagamentoBBPayService;
    }
}

