/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.autoinfracao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.autoinfracao.TipoFiscal;
import br.com.elotech.tributos.repository.autoinfracao.FiscalRepository;
import br.com.elotech.tributos.repository.autoinfracao.TipoFiscalRepository;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class TipoFiscalService
extends CrudService<TipoFiscal, Long> {
    private final FiscalRepository fiscalRepository;
    private final TipoFiscalRepository tipoFiscalRepository;

    protected void beforeSave(TipoFiscal entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        if (this.tipoFiscalRepository.existsComConflito(entity.getId(), entity.getDescricao())) {
            throw new EloValidationException(String.format("J\u00e1 existe um tipo de fiscal com a descri\u00e7\u00e3o '%s'.", entity.getDescricao()));
        }
    }

    protected void beforeDelete(TipoFiscal entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        if (this.fiscalRepository.existsByTipoFiscal(entity.getId())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel excluir o tipo de fiscal %d - %s pois ele est\u00e1 vinculado com um fiscal", entity.getId(), entity.getDescricao()));
        }
    }

    @Generated
    public TipoFiscalService(FiscalRepository fiscalRepository, TipoFiscalRepository tipoFiscalRepository) {
        this.fiscalRepository = fiscalRepository;
        this.tipoFiscalRepository = tipoFiscalRepository;
    }
}

