/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.autoinfracao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracao;
import br.com.elotech.tributos.domain.autoinfracao.TipoAutoInfracao;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.autoinfracao.AutoInfracaoDescontoDTO;
import br.com.elotech.tributos.enums.autoinfracao.SituacaoAutoInfracao;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.autoinfracao.AutoInfracaoService;
import br.com.elotech.tributos.service.contencioso.ContenciosoHistoricoService;
import br.com.elotech.tributos.util.ContenciosoUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AutoInfracaoBoletoService {
    private final GeraBoletoService geraBoletoService;
    private final DiaUtilService diaUtilService;
    private final ContextService contextService;
    private final AutoInfracaoService autoInfracaoService;
    private final ContenciosoHistoricoService contenciosoHistoricoService;
    private final MotivoDeducaoService motivoDeducaoService;

    public BloquetoDTO geraBoletoSemDesconto(Long idAutoInfracao) {
        AutoInfracao autoInfracao = this.validateBeforeBoleto(idAutoInfracao);
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.AGRUPADO);
        geraBoletoDTO.setDebitos(Collections.singletonList(DebitoParcelaDTO.from((Long)autoInfracao.getDebito().getId(), (Long)1L)));
        geraBoletoDTO.setDataReferencia(this.contextService.getDataAtual());
        geraBoletoDTO.setSomenteConstituidos(Boolean.FALSE);
        List boletos = this.geraBoletoService.geraBoleto(geraBoletoDTO).stream().map(Bloqueto::toBloquetoDTO).collect(Collectors.toList());
        return (BloquetoDTO)this.geraBoletoService.resolveUrlImpressaoBoleto(boletos, Boolean.FALSE).stream().findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel gerar o boleto para o auto de infra\u00e7\u00e3o."));
    }

    private AutoInfracao validateBeforeBoleto(Long idAuto) {
        AutoInfracao autoInfracao = (AutoInfracao)this.autoInfracaoService.findById((Serializable)idAuto).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar auto de infra\u00e7\u00e3o com o id %d.", idAuto)));
        if (SituacaoAutoInfracao.CANCELADO.equals((Object)autoInfracao.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto para o auto de infra\u00e7\u00e3o %d/%d pois ele j\u00e1 foi cancelado.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        if (Objects.isNull(autoInfracao.getDebito())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto para o auto de infra\u00e7\u00e3o %d/%d pois ele n\u00e3o est\u00e1 vinculado com nenhum d\u00e9bito.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        DebitoParcela parcela = Optional.ofNullable(autoInfracao.getDebito().getParcela(Long.valueOf(1L))).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto para o auto de infra\u00e7\u00e3o %d/%d pois o d\u00e9bito vinculado n\u00e3o possui parcela 1.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio())));
        if (!parcela.getSituacaoDebito().isAberto().booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto para o auto de infra\u00e7\u00e3o %d/%d pois a parcela 1 do d\u00e9bito n\u00e3o est\u00e1 aberta.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        return autoInfracao;
    }

    public AutoInfracaoDescontoDTO simulaValorBoletoDesconto(Long idAutoInfracao) {
        return this.simulaValorBoletoDesconto(this.validateBeforeBoleto(idAutoInfracao));
    }

    public AutoInfracaoDescontoDTO simulaValorBoletoDesconto(AutoInfracao autoInfracao) {
        boolean isContenciosoDeferido;
        boolean isDebitoVencido;
        LocalDate dataReferencia = LocalDate.now();
        LocalDate dataVencimento = autoInfracao.getDebito().getDataPrimeiraParcela();
        LocalDate diaUtilVencimento = this.diaUtilService.diaUtilProximo(dataVencimento);
        DebitoParcela parcela = autoInfracao.getDebito().getParcela(Long.valueOf(1L));
        boolean hasContencioso = Objects.nonNull(autoInfracao.getContencioso());
        boolean bl = isDebitoVencido = parcela.getSituacaoLegal().isDividaAtivaOrJuizo() != false || dataReferencia.isAfter(diaUtilVencimento);
        if (isDebitoVencido && !hasContencioso) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o d\u00e9bito j\u00e1 est\u00e1 vencido.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        if (hasContencioso && autoInfracao.getContencioso().getData().isAfter(diaUtilVencimento)) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o recurso foi criado ap\u00f3s o vencimento do d\u00e9bito.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        boolean bl2 = isContenciosoDeferido = hasContencioso && this.isContenciosoDeferido(autoInfracao.getContencioso().getId());
        if (isDebitoVencido && !isContenciosoDeferido) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o d\u00e9bito j\u00e1 est\u00e1 vencido e o recurso n\u00e3o foi deferido.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        BigDecimal percentualMaximoDesconto = this.resolveMaximoDesconto(autoInfracao, Boolean.valueOf(hasContencioso), Boolean.valueOf(isContenciosoDeferido));
        AutoInfracaoDescontoDTO dto = new AutoInfracaoDescontoDTO();
        dto.setPercentualDesconto(percentualMaximoDesconto);
        dto.setHasContenciosoDeferido(Boolean.valueOf(isContenciosoDeferido));
        return dto;
    }

    public BloquetoDTO geraBoletoComDesconto(Long idAutoInfracao, AutoInfracaoDescontoDTO autoInfracaoDescontoDTO) {
        AutoInfracao autoInfracao = this.validateBeforeBoleto(idAutoInfracao);
        if (autoInfracaoDescontoDTO.getPercentualDesconto().compareTo(BigDecimal.ZERO) <= 0) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o percentual de desconto informado deve ser maior que zero.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        AutoInfracaoDescontoDTO simulacao = this.simulaValorBoletoDesconto(autoInfracao);
        if (autoInfracaoDescontoDTO.getPercentualDesconto().compareTo(simulacao.getPercentualDesconto()) > 0) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o percentual de desconto informado excede o m\u00e1ximo permitido (%.2f).", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio(), simulacao.getPercentualDesconto()));
        }
        MotivoDeducao motivoDesconto = this.resolveMotivoDesconto(autoInfracaoDescontoDTO.getMotivoDeducao());
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.PARCELADO);
        geraBoletoDTO.setDebitos(Collections.singletonList(DebitoParcelaDTO.from((Long)autoInfracao.getDebito().getId(), (Long)1L)));
        geraBoletoDTO.setDataReferencia(this.contextService.getDataAtual());
        geraBoletoDTO.setSomenteConstituidos(Boolean.FALSE);
        List boletos = this.geraBoletoService.geraBoleto(geraBoletoDTO, this.buildConsumerDescontoAutoInfracao(autoInfracao, autoInfracaoDescontoDTO.getPercentualDesconto(), simulacao.getHasContenciosoDeferido(), motivoDesconto)).stream().map(Bloqueto::toBloquetoDTO).collect(Collectors.toList());
        autoInfracao.setMotivoDesconto(motivoDesconto);
        autoInfracao.setDescontoAuto(autoInfracaoDescontoDTO.getPercentualDesconto());
        autoInfracao.setIdProcessoDesconto(autoInfracaoDescontoDTO.getNumeroProcesso());
        autoInfracao.setExercicioProcessoDesconto(autoInfracaoDescontoDTO.getExercicioProcesso());
        this.autoInfracaoService.save((EloEntity)autoInfracao, null);
        return (BloquetoDTO)this.geraBoletoService.resolveUrlImpressaoBoleto(boletos, Boolean.FALSE).stream().findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel gerar o boleto para o auto de infra\u00e7\u00e3o."));
    }

    private Consumer<Bloqueto> buildConsumerDescontoAutoInfracao(AutoInfracao autoInfracao, BigDecimal percentualDesconto, Boolean retiraJurosMultaCorrecao, MotivoDeducao motivoDeducao) {
        return boleto -> {
            boleto.setMotivoDeducao(motivoDeducao);
            autoInfracao.getPenalidades().forEach(penalidade -> {
                Tributo tributo = penalidade.getPenalidade().getTributo();
                BigDecimal valorDesconto = penalidade.getValor().multiply(percentualDesconto).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_EVEN);
                BoletoDebito boletoDebito = boleto.getDebitos().stream().filter(bd -> bd.getId().getDebitoParcelaTributo().getTributo().equals(tributo.getTributo())).findFirst().orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o tributo %s da penalidade %d/%d nos d\u00e9bitos do boleto.", tributo.getTributo(), penalidade.getPenalidade().getId().getPenalidade(), penalidade.getPenalidade().getId().getExercicio())));
                boletoDebito.setValorDesconto(boletoDebito.getValorDesconto().add(valorDesconto));
                boletoDebito.setValorDescontoPrincipal(boletoDebito.getValorDescontoPrincipal().add(valorDesconto));
                if (retiraJurosMultaCorrecao.booleanValue()) {
                    boletoDebito.setValorJuros(BigDecimal.ZERO);
                    boletoDebito.setValorMulta(BigDecimal.ZERO);
                    boletoDebito.setValorCorrecao(BigDecimal.ZERO);
                }
            });
        };
    }

    private MotivoDeducao resolveMotivoDesconto(Long motivoDeducao) {
        return (MotivoDeducao)this.motivoDeducaoService.findById((Serializable)motivoDeducao).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o motivo dedu\u00e7\u00e3o %d.", motivoDeducao)));
    }

    private BigDecimal resolveMaximoDesconto(AutoInfracao autoInfracao, Boolean hasContencioso, Boolean isContenciosoDeferido) {
        if (hasContencioso.booleanValue() && !isContenciosoDeferido.booleanValue()) {
            Long instancia = autoInfracao.getContencioso().getInstancia();
            if (instancia == 1L || instancia == 3L) {
                return BigDecimal.valueOf(30L);
            }
            if (instancia == 2L || instancia == 4L) {
                throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o recurso se encontra em segunda inst\u00e2ncia.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
            }
            if (instancia == 5L) {
                throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o recurso se encontra em terceira inst\u00e2ncia.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
            }
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o recurso se encontra em uma inst\u00e2ncia inv\u00e1lida.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        Long divida = autoInfracao.getDebito().getGuiaRecolhimento();
        if (Arrays.asList(64L, 6L, 24L, 17L, 31L, 37L, 44L, 45L, 49L).contains(divida)) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o d\u00e9bito gerado est\u00e1 vinculado com alguma das d\u00edvidas que n\u00e3o permitem desconto (64,06,24,17,31,37,44,45,49).", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        if (Arrays.asList(27L, 98L, 126L, 152L).contains(divida)) {
            return BigDecimal.valueOf(50L);
        }
        TipoAutoInfracao tipoAutoInfracao = autoInfracao.getTipoAutoInfracao();
        if (!tipoAutoInfracao.getPermiteDesconto().booleanValue()) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o tipo de auto de infra\u00e7\u00e3o n\u00e3o permite desconto.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio()));
        }
        if (tipoAutoInfracao.getPercentualDesconto().compareTo(BigDecimal.ZERO) <= 0) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar o boleto com desconto para o auto de infra\u00e7\u00e3o %d/%d pois o valor m\u00e1ximo de desconto do tipo de auto de infra\u00e7\u00e3o %d - %s \u00e9 0.", autoInfracao.getAutoInfracaoFiscal(), autoInfracao.getExercicio(), tipoAutoInfracao.getId(), tipoAutoInfracao.getDescricao()));
        }
        return tipoAutoInfracao.getPercentualDesconto();
    }

    private boolean isContenciosoDeferido(Long idContencioso) {
        return ContenciosoUtils.isDeferido((List)this.contenciosoHistoricoService.findByContenciosoId(idContencioso));
    }

    @Generated
    public AutoInfracaoBoletoService(GeraBoletoService geraBoletoService, DiaUtilService diaUtilService, ContextService contextService, AutoInfracaoService autoInfracaoService, ContenciosoHistoricoService contenciosoHistoricoService, MotivoDeducaoService motivoDeducaoService) {
        this.geraBoletoService = geraBoletoService;
        this.diaUtilService = diaUtilService;
        this.contextService = contextService;
        this.autoInfracaoService = autoInfracaoService;
        this.contenciosoHistoricoService = contenciosoHistoricoService;
        this.motivoDeducaoService = motivoDeducaoService;
    }
}

