/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.executors.implementations;

import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaParcelamentoParams;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.exception.AtualizacaoMonetariaException;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.agendamentorotina.executors.AgendamentoRotinaExecutorImpl;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import br.com.elotech.tributos.service.batch.atualizacaomonetariaparcelamento.AtualizacaoMonetariaParcelamentoJobStarter;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AtualizacaoMonetariaExecutor
extends AgendamentoRotinaExecutorImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoMonetariaExecutor.class);
    private final AtualizacaoMonetariaParcelamentoJobStarter jobStarter;
    private final List<AgendamentoRotinaNotifier> notifiers;
    private final ContextService contextService;

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.ATUALIZACAO_MONETARIA.equals((Object)agendamentoRotina.getRotina());
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void execute(AgendamentoRotina agendamentoRotina) {
        AtualizacaoMonetariaParcelamentoParams filtros = (AtualizacaoMonetariaParcelamentoParams)this.parseFilter(agendamentoRotina.getParametros());
        LocalDate dataProximoMes = this.contextService.getDataAtual().plusMonths(1L);
        Long proximoMes = dataProximoMes.getMonthValue();
        Long exercicioProximoMes = dataProximoMes.getYear();
        filtros.setExercicio(exercicioProximoMes);
        filtros.setMes(proximoMes);
        filtros.setEntidade(this.contextService.getEntidadePrincipal());
        try {
            log.debug("Iniciando job de atualiza\u00e7\u00e3o monet\u00e1ria. Filtros: {}", (Object)filtros);
            this.jobStarter.startJob(filtros);
            log.debug("Job de atualiza\u00e7\u00e3o monet\u00e1ria iniciado com sucesso.");
        }
        catch (Exception e) {
            log.error("Erro ao iniciar o job de atualiza\u00e7\u00e3o monet\u00e1ria: {}", (Object)e.getMessage(), (Object)e);
            throw new AtualizacaoMonetariaException("Erro ao iniciar o job de atualiza\u00e7\u00e3o monet\u00e1ria", (Throwable)e);
        }
    }

    public List<AgendamentoRotinaNotifier> getNotifiers() {
        log.debug("Obtendo notifiers para o executor de atualiza\u00e7\u00e3o monet\u00e1ria.");
        return this.notifiers;
    }

    protected Object parseFilter(Map<String, String> param) {
        log.debug("Convertendo par\u00e2metros para AtualizacaoMonetariaParcelamentoParams: {}", param);
        AtualizacaoMonetariaParcelamentoParams filtros = new AtualizacaoMonetariaParcelamentoParams();
        param.forEach((key, value) -> this.setField((Object)filtros, key, value));
        return filtros;
    }

    @Generated
    public AtualizacaoMonetariaExecutor(AtualizacaoMonetariaParcelamentoJobStarter jobStarter, List<AgendamentoRotinaNotifier> notifiers, ContextService contextService) {
        this.jobStarter = jobStarter;
        this.notifiers = notifiers;
        this.contextService = contextService;
    }
}

