/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acertopagameto;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.AcertoPagamento;
import br.com.elotech.tributos.domain.AcertoPagamentoItem;
import br.com.elotech.tributos.domain.AcertoPagamentoItemId;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.domain.pagamentocredito.PagamentoCredito;
import br.com.elotech.tributos.dto.BoletoDTO;
import br.com.elotech.tributos.dto.pagamento.AcertoPagamentoItemDTO;
import br.com.elotech.tributos.dto.pagamento.AcertoPagamentoNovoDTO;
import br.com.elotech.tributos.dto.pagamento.AcertoPagamentoResponseDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoResumoDTO;
import br.com.elotech.tributos.dto.pagamentocredito.PagamentoCreditoDTO;
import br.com.elotech.tributos.dto.pagamentocredito.PagamentoCreditoMovimentacaoDTO;
import br.com.elotech.tributos.enums.pagamentocredito.OrigemCredito;
import br.com.elotech.tributos.repository.AcertoPagamentoRepository;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.PagamentoLoteManualService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.pagamentocredito.CreditoService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AcertoPagamentoService
extends CrudService<AcertoPagamento, Long> {
    private final AcertoPagamentoRepository acertoPagamentoRepository;
    private final ConvenioService convenioService;
    private final PagamentoLoteService pagamentoLoteService;
    private final BloquetoService boletoService;
    private final PagamentoLoteManualService pagamentoLoteManualService;
    private final CreditoService pagamentoCreditoService;
    private final ContextService contextService;
    private final ParametroGeralService parametroGeralService;

    @Transactional
    public AcertoPagamentoResponseDTO salvarAcertoPagamento(AcertoPagamentoNovoDTO acertoPagamentoNovoDTO) {
        if (acertoPagamentoNovoDTO.getBoletos().isEmpty()) {
            throw new EloValidationException("Acerto pagamento deve possuir pelo menos um boleto.");
        }
        Convenio convenioContaAcerto = this.findConvenioContaAcertoPagamento();
        List boletos = this.validaBoletos(acertoPagamentoNovoDTO);
        PagamentoLote pagamentoLote = this.createPagamentoLote(acertoPagamentoNovoDTO, convenioContaAcerto);
        List pagamentosNovos = this.geraPagamentos(pagamentoLote, boletos);
        this.pagamentoLoteService.fecharLote(pagamentoLote);
        List creditos = this.createMovimentacaoCredito(acertoPagamentoNovoDTO);
        this.transferirSaldoRemanescenteCredito(creditos, acertoPagamentoNovoDTO.getTransferirSaldoRemanescente());
        AcertoPagamento acertoPagamento = this.createAcertoPagamento(pagamentosNovos, creditos, acertoPagamentoNovoDTO);
        return this.mountResponseDTO(acertoPagamento);
    }

    public Optional<AcertoPagamento> findByPagamentoNovo(Pagamento pagamento) {
        return this.acertoPagamentoRepository.findAcertoPagamentoByPagamentoNovo(pagamento);
    }

    private List<PagamentoCredito> createMovimentacaoCredito(AcertoPagamentoNovoDTO novoPagamento) {
        List creditos = this.findCreditoPagamento(novoPagamento.getPagamentoCreditos());
        List bloquetos = this.findBloquetos(novoPagamento.getBoletos());
        Map pagamentoCreditos = this.pagamentoCreditoService.usarCredito(creditos, bloquetos);
        return this.pagamentoCreditoService.save(new ArrayList(pagamentoCreditos.keySet()));
    }

    private List<Bloqueto> findBloquetos(List<BoletoDTO> boletosDTO) {
        List bloquetoIds = boletosDTO.stream().map(BoletoDTO::getId).collect(Collectors.toList());
        List bloquetos = this.boletoService.findByBloquetoIds(bloquetoIds);
        if (bloquetos.isEmpty()) {
            throw new EloValidationException("Boleto n\u00e3o encontrado.");
        }
        return bloquetos;
    }

    private List<PagamentoCredito> findCreditoPagamento(List<PagamentoCreditoDTO> creditosDTO) {
        List creditoIds = creditosDTO.stream().map(PagamentoCreditoDTO::getId).collect(Collectors.toList());
        List creditos = this.pagamentoCreditoService.findAllById(creditoIds);
        if (creditos.isEmpty()) {
            throw new EloValidationException("Cr\u00e9dito de Pagamento n\u00e3o encontrado.");
        }
        return creditos;
    }

    private AcertoPagamento createAcertoPagamento(List<Pagamento> pagamentosNovos, List<PagamentoCredito> creditos, AcertoPagamentoNovoDTO acertoPagamentoNovoDTO) {
        AtomicLong sequencia = new AtomicLong(1L);
        AcertoPagamento acertoPagamento = new AcertoPagamento();
        acertoPagamento.setDataAcerto(LocalDateTime.now());
        acertoPagamento.setUsuario(UsuarioUtils.getUsuarioAise());
        acertoPagamento.setNumeroProtocolo(acertoPagamentoNovoDTO.getNumeroProtocolo());
        acertoPagamento.setProcessoSei(acertoPagamentoNovoDTO.getProcessoSei());
        Map bloquetoToPagamentoCreditoHashTable = this.getBloquetoToPagamentoCreditoHashTable(creditos);
        pagamentosNovos.stream().map(pagamentoNovo -> {
            Bloqueto boleto = pagamentoNovo.getPagamentoBoleto().getBoleto();
            AcertoPagamentoItemId acertoPagamentoItemId = new AcertoPagamentoItemId();
            acertoPagamentoItemId.setAcertoPagamento(acertoPagamento);
            acertoPagamentoItemId.setSequencia(Long.valueOf(sequencia.getAndIncrement()));
            List creditosUtilizados = (List)bloquetoToPagamentoCreditoHashTable.get(boleto);
            AcertoPagamentoItem acertoPagamentoItem = new AcertoPagamentoItem();
            acertoPagamentoItem.setPagamentoNovo(pagamentoNovo);
            acertoPagamentoItem.setId(acertoPagamentoItemId);
            List movimentacoesUtilizadas = creditosUtilizados.stream().map(credito -> credito.getMovimentacaoPorBoleto(boleto)).collect(Collectors.toList());
            acertoPagamentoItem.setMovimentacoes(movimentacoesUtilizadas);
            return acertoPagamentoItem;
        }).forEach(acertoPagamento.getAcertoPagamentoItemList()::add);
        return (AcertoPagamento)this.acertoPagamentoRepository.save((Object)acertoPagamento);
    }

    private Map<Bloqueto, List<PagamentoCredito>> getBloquetoToPagamentoCreditoHashTable(List<PagamentoCredito> creditos) {
        HashMap<Bloqueto, List<PagamentoCredito>> bloquetoToPagamentoHashTable = new HashMap<Bloqueto, List<PagamentoCredito>>();
        creditos.stream().flatMap(credito -> credito.getMovimentacoes().stream()).forEach(movimentacao -> {
            PagamentoCredito credito = movimentacao.getPagamentoCredito();
            List creditoList = bloquetoToPagamentoHashTable.getOrDefault(movimentacao.getBoletoPago(), new ArrayList());
            creditoList.add(credito);
            bloquetoToPagamentoHashTable.putIfAbsent(movimentacao.getBoletoPago(), creditoList);
        });
        return bloquetoToPagamentoHashTable;
    }

    public String createDescricaoAcertoPagamento(PagamentoId pagamentoId, AcertoPagamento acertoPagamento, Bloqueto bloquetoDestino) {
        return String.format("Pagamento realizado pelo Acerto de Pagamento %d. Baixa do Pagamento %d/%d, pelo Boleto %d/%d. %s", acertoPagamento.getId(), pagamentoId.getPagamento(), pagamentoId.getExercicioPagamento(), bloquetoDestino.getBloqueto(), bloquetoDestino.getExercicioBloqueto(), acertoPagamento.getUsuario());
    }

    public List<Pagamento> geraPagamentos(PagamentoLote pagamentoLote, List<Bloqueto> boletos) {
        return this.pagamentoLoteManualService.geraPagamentos(pagamentoLote, boletos, Boolean.FALSE);
    }

    private List<Bloqueto> validaBoletos(AcertoPagamentoNovoDTO acertoPagamento) {
        return acertoPagamento.getBoletos().stream().map(boletoDTO -> {
            Bloqueto boleto = (Bloqueto)this.boletoService.findById((Serializable)boletoDTO.getId()).orElseThrow(() -> new EloValidationException("Boleto n\u00e3o encontrado."));
            if (boleto.getPago().booleanValue() || boleto.validaSeBoletoComParcelaPaga()) {
                throw new EloValidationException(String.format("Boleto %d/%d pago ou com parcelas pagas.", boleto.getBloqueto(), boleto.getExercicioBloqueto()));
            }
            this.preencheCamposValorAcrescimoBoleto(boleto);
            return boleto;
        }).collect(Collectors.toList());
    }

    private void preencheCamposValorAcrescimoBoleto(Bloqueto boleto) {
        boleto.getDebitos().forEach(boletoDebito -> {
            boletoDebito.setValorPrincipalAcrescimo(boletoDebito.getValorPrincipal());
            boletoDebito.setValorJurosAcrescimo(boletoDebito.getValorJuros());
            boletoDebito.setValorMultaAcrescimo(boletoDebito.getValorMulta());
            boletoDebito.setValorCorrecaoAcrescimo(boletoDebito.getValorCorrecao());
        });
    }

    private PagamentoLote createPagamentoLote(AcertoPagamentoNovoDTO acertoPagamento, Convenio convenio) {
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(this.contextService.getEntidadePrincipal());
        id.setExercicio(this.contextService.getExercicioAtual());
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataMovimento(acertoPagamento.getDataMovimento().toLocalDate());
        pagamentoLote.setDataCredito(acertoPagamento.getDataCredito().toLocalDate());
        pagamentoLote.setDataLote(acertoPagamento.getDataLote().toLocalDate());
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.MANUAL);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    public AcertoPagamentoResponseDTO mountResponseDTO(AcertoPagamento acertoPagamento) {
        AcertoPagamentoResponseDTO acertoPagamentoResponseDTO = new AcertoPagamentoResponseDTO();
        acertoPagamentoResponseDTO.setAcertoPgto(acertoPagamento.getId());
        acertoPagamentoResponseDTO.setDataAcerto(acertoPagamento.getDataAcerto());
        acertoPagamentoResponseDTO.setUsuario(acertoPagamento.getUsuario());
        acertoPagamentoResponseDTO.setEstornado(acertoPagamento.getEstornado());
        acertoPagamentoResponseDTO.setObservacao(acertoPagamento.getObservacao());
        acertoPagamentoResponseDTO.setNumeroProtocolo(acertoPagamento.getNumeroProtocolo());
        acertoPagamentoResponseDTO.setProcessoSei(acertoPagamento.getProcessoSei());
        List itensDTO = acertoPagamento.getAcertoPagamentoItemList().stream().map(item -> {
            AcertoPagamentoItemDTO itemDTO = new AcertoPagamentoItemDTO();
            itemDTO.setSequencia(item.getId().getSequencia());
            itemDTO.setIdAcertoPagamento(item.getId().getAcertoPagamento().getId());
            itemDTO.setMovimentacao(item.getMovimentacoes().stream().map(PagamentoCreditoMovimentacaoDTO::from).collect(Collectors.toList()));
            Optional.ofNullable(item.getPagamentoOrigem()).ifPresent(pagamento -> itemDTO.setPagamentoOrigem(PagamentoResumoDTO.of((Pagamento)item.getPagamentoOrigem())));
            Optional.ofNullable(item.getPagamentoNovo()).ifPresent(pagamento -> itemDTO.setPagamentoNovo(PagamentoResumoDTO.of((Pagamento)item.getPagamentoNovo())));
            return itemDTO;
        }).collect(Collectors.toList());
        acertoPagamentoResponseDTO.setItens(itensDTO);
        return acertoPagamentoResponseDTO;
    }

    private Convenio findConvenioContaAcertoPagamento() {
        Long contaBancaria = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.CONTAACERTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        return (Convenio)this.convenioService.findByContaBancaria(contaBancaria).orElseThrow(() -> new EloValidationException("Conv\u00eanio n\u00e3o encontrado."));
    }

    private void transferirSaldoRemanescenteCredito(List<PagamentoCredito> creditos, Boolean transferir) {
        if (Boolean.FALSE.equals(transferir)) {
            return;
        }
        creditos.stream().filter(credito -> credito.existeSaldo() && credito.isRemanescente()).forEach(creditoATransferir -> this.pagamentoCreditoService.transferirCredito(creditoATransferir, OrigemCredito.REMANESCENTE));
    }

    @Generated
    public AcertoPagamentoService(AcertoPagamentoRepository acertoPagamentoRepository, ConvenioService convenioService, PagamentoLoteService pagamentoLoteService, BloquetoService boletoService, PagamentoLoteManualService pagamentoLoteManualService, CreditoService pagamentoCreditoService, ContextService contextService, ParametroGeralService parametroGeralService) {
        this.acertoPagamentoRepository = acertoPagamentoRepository;
        this.convenioService = convenioService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.boletoService = boletoService;
        this.pagamentoLoteManualService = pagamentoLoteManualService;
        this.pagamentoCreditoService = pagamentoCreditoService;
        this.contextService = contextService;
        this.parametroGeralService = parametroGeralService;
    }
}

