/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.ParcelamentoCarne;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.parcelamento.ImpressaoBoletoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.repository.ParcelamentoCarneRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ParcelamentoCarneService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParcelamentoCarneService.class);
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;
    private final CarneService carneService;
    private final ParcelamentoCarneRepository parcelamentoCarneRepository;

    @Async
    public void gerarBoletoCarneAsync(ImpressaoBoletoParcelamentoDTO request, List<ParcelamentoDebitoParcelasDTO> parcelas, String chave, TarefaAssincronaExecucao execucao, Long parcelaInicial, Long parcelaFinal) {
        Long tarefa = execucao.getTarefaAssincrona().getId();
        UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
        Optional notificacaoID = this.notificacaoService.send("Iniciada gera\u00e7\u00e3o do carn\u00ea de Parcelamento", String.format("Iniciada a gera\u00e7\u00e3o do carn\u00ea do parcelamento da tarefa %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.carneService.gerarBoletoCarne(request, parcelas, chave, parcelaInicial, parcelaFinal);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Finalizada gera\u00e7\u00e3o do carn\u00ea de Parcelamento", String.format("Finalizada com sucesso a gera\u00e7\u00e3o do carn\u00ea para o parcelamento da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoID, userSecurityDTO, NotificationStatus.COMPLETED);
            stopwatch.stop();
            log.info(String.format("Fim da geracao de boleto: %s", stopwatch));
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            log.error("Erro ao gerar o carn\u00ea para o parcelamento", (Throwable)e);
            this.notificacaoService.send("Finalizada gera\u00e7\u00e3o do carn\u00ea de Parcelamento", String.format("Ocorreu um erro na gera\u00e7\u00e3o do carn\u00ea para o parcelamento tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoID, userSecurityDTO, NotificationStatus.FAILED);
        }
    }

    public List<ParcelamentoCarne> getByChaveAndParcela(String chave, Long parcelaInicial, Long parcelaFinal) {
        return this.parcelamentoCarneRepository.getByChaveAndParcela(chave, parcelaInicial, parcelaFinal);
    }

    public ParcelamentoCarne save(ParcelamentoCarne parcelamentoCarne) {
        return (ParcelamentoCarne)this.parcelamentoCarneRepository.save((Object)parcelamentoCarne);
    }

    @Generated
    public ParcelamentoCarneService(TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService, CarneService carneService, ParcelamentoCarneRepository parcelamentoCarneRepository) {
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
        this.carneService = carneService;
        this.parcelamentoCarneRepository = parcelamentoCarneRepository;
    }
}

