/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.ConfigHonorario;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.service.ConfigHonorarioService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.GeraDebitoService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class HonorarioService {
    private final GeraDebitoService geraDebitoService;
    private final DividaService dividaService;
    private final DebitoParcelaTributoService debitoParcelaTributoService;
    private final ConfigHonorarioService configHonorarioService;
    private final ContextService contextService;

    public void gerarDebitoAndBoletoDebitoHonorarioByBoleto(Bloqueto boleto) {
        if (boleto.getValorHonorario().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        ConfigHonorario configHonorario = this.getConfiguracaoHonorarioByExercicio(this.contextService.getExercicioAtual());
        Map cadastrosToGenerateDebito = this.getListDebitoManualHonorarioByBloqueto(boleto);
        ArrayList<DebitoIdDTO> debitosGerados = new ArrayList<DebitoIdDTO>();
        for (Map.Entry entry : cadastrosToGenerateDebito.entrySet()) {
            CadastroGeralResumidoDTO cadastro = (CadastroGeralResumidoDTO)entry.getKey();
            BigDecimal valor = (BigDecimal)entry.getValue();
            debitosGerados.add(this.gerarDebitoHonorario(cadastro, valor, configHonorario, boleto));
        }
        debitosGerados.forEach(debitoIdDTO -> this.inserirDebitoHonorarioNoBoleto(debitoIdDTO, boleto));
    }

    public void inserirDebitoHonorarioNoBoleto(DebitoIdDTO debitoIdDTO, Bloqueto bloqueto) {
        List debitoParcelaTributos = this.debitoParcelaTributoService.findByDebitoKey(debitoIdDTO);
        debitoParcelaTributos.forEach(debitoParcelaTributo -> bloqueto.getDebitos().add(BoletoDebito.of((Bloqueto)bloqueto, (DebitoParcelaTributo)debitoParcelaTributo)));
    }

    public ConfigHonorario getConfiguracaoHonorarioByExercicio(Long exercicio) {
        return this.configHonorarioService.findByExercicio(exercicio);
    }

    public DebitoIdDTO gerarDebitoHonorario(CadastroGeralResumidoDTO cadastro, BigDecimal valor, ConfigHonorario configHonorario, Bloqueto boleto) {
        Long divida = configHonorario.getGuiaRecolhimentoHono();
        Long exercicio = this.contextService.getExercicioAtual();
        DividaTributo dividaTributo = (DividaTributo)this.getDividaTributo(divida, exercicio).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o tributo padr\u00e3o da d\u00edvida %d/%d.", divida, exercicio)));
        DebitoManualTributoDTO tributo = new DebitoManualTributoDTO();
        tributo.setTributo(dividaTributo.getTributo().getTributo());
        tributo.setOrdem(dividaTributo.getOrdem());
        tributo.setValorTributo(valor);
        DebitoManualParcelaDTO parcela = new DebitoManualParcelaDTO();
        parcela.setParcela(Long.valueOf(1L));
        parcela.setDataVencimento(LocalDate.now());
        parcela.setValor(valor);
        DebitoManualObservacaoDTO observacao = new DebitoManualObservacaoDTO();
        observacao.setObservacao(String.format("D\u00e9bito de honor\u00e1rios gerado na baixa do boleto %d", boleto.getId()));
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setExercicio(exercicio);
        debitoManualDTO.setDataLancamento(LocalDate.now());
        debitoManualDTO.setDivida(divida);
        debitoManualDTO.setTipoCadastro(cadastro.getTipoCadastro());
        debitoManualDTO.setCadastroGeral(cadastro.getCadastroGeral());
        debitoManualDTO.setPrograma("HonorarioService");
        debitoManualDTO.getTributos().add(tributo);
        debitoManualDTO.getParcelas().add(parcela);
        debitoManualDTO.getObservacoes().add(observacao);
        return this.geraDebitoService.geraDebitoManual(debitoManualDTO);
    }

    public Optional<DividaTributo> getDividaTributo(Long dividaId, Long exercicio) {
        Long entidade = 1L;
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, exercicio, dividaId).orElseThrow(() -> new EloValidationException(String.format("D\u00edvida %d n\u00e3o encontrada no exerc\u00edcio %d para entidade %d", dividaId, exercicio, entidade)));
        return divida.getTributos().stream().filter(DividaTributo::getReceitaPadrao).findFirst();
    }

    public Map<CadastroGeralResumidoDTO, BigDecimal> getListDebitoManualHonorarioByBloqueto(Bloqueto boleto) {
        return boleto.getDebitos().stream().collect(Collectors.toMap(arg_0 -> this.buildCadastroGeralDTO(arg_0), BoletoDebito::getValorHonorario, BigDecimal::add));
    }

    private CadastroGeralResumidoDTO buildCadastroGeralDTO(BoletoDebito boletoDebito) {
        return new CadastroGeralResumidoDTO(TipoCadastro.fromValue((Long)boletoDebito.getId().getDebitoParcelaTributo().getTipoCadastro()), boletoDebito.getId().getDebitoParcelaTributo().getCadastroGeral());
    }

    @Generated
    public HonorarioService(GeraDebitoService geraDebitoService, DividaService dividaService, DebitoParcelaTributoService debitoParcelaTributoService, ConfigHonorarioService configHonorarioService, ContextService contextService) {
        this.geraDebitoService = geraDebitoService;
        this.dividaService = dividaService;
        this.debitoParcelaTributoService = debitoParcelaTributoService;
        this.configHonorarioService = configHonorarioService;
        this.contextService = contextService;
    }
}

