/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.DebitoParcelaObservacao;
import br.com.elotech.tributos.domain.DebitoParcelaObservacaoId;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.LivroParcelaTributo;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.SituacaoParcelamento;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.protesto.GeracaoProtestoErro;
import br.com.elotech.tributos.dto.DebitoDetalheParcelasDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.repository.DebitoParcelaRepository;
import br.com.elotech.tributos.repository.GeracaoProtestoErroRepository;
import br.com.elotech.tributos.repository.impl.DebitoParcelaRepositoryImpl;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DocumentoItemDividaAtivaService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.batch.core.JobExecution;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DebitoParcelaService
extends CrudService<DebitoParcela, DebitoParcelaId> {
    private DebitoParcelaRepository debitoParcelaRepository;
    private DebitoParcelaRepositoryImpl debitoParcelaRepositoryImpl;
    private SituacaoParcelaService situacaoParcelaService;
    private ParcelamentoService parcelamentoService;
    private DocumentoItemDividaAtivaService documentoItemDividaAtivaService;
    private GeracaoProtestoErroRepository geracaoProtestoErroRepository;

    public DebitoParcela updateVencimentoParcela(Long idDebito, Long idParcela, LocalDate novoVencimento) {
        DebitoParcela parcela = this.findDebitoParcelaByIdDebitoAndParcela(idDebito, idParcela);
        if (Objects.isNull(parcela)) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a parcela para atualiza\u00e7\u00e3o");
        }
        parcela.setDataVencimento(novoVencimento);
        return (DebitoParcela)this.debitoParcelaRepository.save((Object)parcela);
    }

    public DebitoParcela updateParcela(DebitoDetalheParcelasDTO debitoDetalheParcelasDTO) {
        DebitoParcela parcela = this.findDebitoParcelaByIdDebitoAndParcela(debitoDetalheParcelasDTO.getId(), debitoDetalheParcelasDTO.getParcela());
        if (Objects.isNull(parcela)) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a parcela para atualiza\u00e7\u00e3o");
        }
        parcela.updateDadosParcelas(debitoDetalheParcelasDTO);
        return (DebitoParcela)this.debitoParcelaRepository.save((Object)parcela);
    }

    public List<DebitoParcela> updateParcelas(DebitoDetalheParcelasDTO debitoDetalheParcelasDTO) {
        List parcelas = this.debitoParcelaRepository.findParcelasByDebitoIdAndIdParcelaBetween(debitoDetalheParcelasDTO.getId(), debitoDetalheParcelasDTO.getParcelaInicio(), debitoDetalheParcelasDTO.getParcelaFim());
        if (parcelas.isEmpty()) {
            throw new EloValidationException("N\u00e3o foram encontradas as parcelas para atualiza\u00e7\u00e3o");
        }
        parcelas.forEach(item -> item.updateDadosParcelas(debitoDetalheParcelasDTO));
        return this.debitoParcelaRepository.saveAll((Iterable)parcelas);
    }

    public List<DebitoParcela> findByIdIn(List<DebitoParcelaId> debitoParcelaIds) {
        return this.debitoParcelaRepository.findByIdIn(debitoParcelaIds);
    }

    public Optional<DebitoParcela> findById(DebitoParcelaId id) {
        return this.getCrudRepository().findById((Object)id);
    }

    public DebitoParcela findByDebitoParcela(DebitoIdDTO idDebito, Long parcela) {
        return (DebitoParcela)this.findByDebitoParcela(idDebito.getEntidade(), idDebito.getExercicio(), idDebito.getTipoCadastro(), idDebito.getCadastroGeral(), idDebito.getDivida(), idDebito.getSubDivida(), parcela).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a parcela para estorno."));
    }

    public Optional<DebitoParcela> findByDebitoParcela(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral, Long divida, Long subDivida, Long parcela) {
        return this.debitoParcelaRepository.findByDebitoParcela(entidade, exercicio, tipoCadastro, cadastroGeral, divida, subDivida, parcela);
    }

    public List<DebitoParcela> findByDebitoAndAberto(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral, Long divida, Long subDivida) {
        return this.debitoParcelaRepository.findByDebitoAndAberto(entidade, exercicio, tipoCadastro, cadastroGeral, divida, subDivida);
    }

    public void updateSituacaoLegalParcela(DebitoParcelaDTO debitoParcelaDTO) {
        DebitoParcela debitoParcela = this.findDebitoParcelaByIdDebitoAndParcela(debitoParcelaDTO.getIdDebito(), debitoParcelaDTO.getParcela());
        if (Objects.isNull(debitoParcela)) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a parcela para atualiza\u00e7\u00e3o");
        }
        debitoParcela.setSituacaoLegal(SituacaoLegal.DIVIDA_ATIVA);
        this.debitoParcelaRepository.save((Object)debitoParcela);
    }

    private DebitoParcela findDebitoParcelaByIdDebitoAndParcela(Long idDebito, Long parcela) {
        return this.debitoParcelaRepository.findParcelasByDebitoIdAndIdParcela(idDebito, parcela);
    }

    public void pagarParcela(DebitoParcela debitoParcela) {
        SituacaoParcela situacaoParcela = this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.PAGAMENTO, debitoParcela.getSituacaoDebito());
        if (!debitoParcela.getSituacaoDebito().getId().equals(situacaoParcela.getId())) {
            debitoParcela.setSituacaoDebito(situacaoParcela);
            debitoParcela.setDataSituacao(LocalDate.now());
            this.debitoParcelaRepository.save((Object)debitoParcela);
            this.quitarContratoParcelamento(debitoParcela);
        }
    }

    public void pagarParcelaWebHookPix(DebitoParcela debitoParcela) {
        if (Objects.nonNull(debitoParcela.getSituacaoDebito()) && Boolean.FALSE.equals(debitoParcela.getSituacaoDebito().isAberto())) {
            return;
        }
        SituacaoParcela situacaoParcela = this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.PAGO_POR_PIX, debitoParcela.getSituacaoDebito());
        if (!debitoParcela.getSituacaoDebito().getId().equals(situacaoParcela.getId())) {
            debitoParcela.setSituacaoDebito(situacaoParcela);
            debitoParcela.setDataSituacao(LocalDate.now());
            this.debitoParcelaRepository.save((Object)debitoParcela);
        }
    }

    public void abrirParcela(DebitoParcela debitoParcela) {
        SituacaoParcela situacaoParcelaAberta = this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.INSCRICAO, debitoParcela.getSituacaoDebito());
        if (!debitoParcela.getSituacaoDebito().getId().equals(situacaoParcelaAberta.getId())) {
            debitoParcela.setSituacaoDebito(situacaoParcelaAberta);
            debitoParcela.setDataSituacao(LocalDate.now());
            this.debitoParcelaRepository.save((Object)debitoParcela);
            this.reabrirParcelamentoQuitado(debitoParcela);
        }
    }

    private void quitarContratoParcelamento(DebitoParcela debitoParcela) {
        this.parcelamentoService.findParcelamentoDisponivelParaQuitacao(debitoParcela).ifPresent(parcelamento -> {
            SituacaoParcelamento situacaoParcelamento = new SituacaoParcelamento();
            situacaoParcelamento.setId(Long.valueOf(4L));
            situacaoParcelamento.setDescricao("QUITADO");
            parcelamento.setSituacao(situacaoParcelamento);
            this.parcelamentoService.save((EloEntity)parcelamento, null);
        });
    }

    private void reabrirParcelamentoQuitado(DebitoParcela debitoParcela) {
        this.parcelamentoService.findParcelamentoQuitadoByParcelaTributo(debitoParcela).ifPresent(parcelamento -> {
            SituacaoParcelamento situacaoParcelamento = new SituacaoParcelamento();
            situacaoParcelamento.setId(Long.valueOf(1L));
            situacaoParcelamento.setDescricao("ABERTO");
            parcelamento.setSituacao(situacaoParcelamento);
            this.parcelamentoService.save((EloEntity)parcelamento, null);
        });
    }

    public void estornoParcelaLivroDividaAtiva(LivroParcelaTributo livroParcelaTributo, DebitoIdDTO idDebito) {
        SituacaoParcela novaSituacaoParcela;
        DebitoParcela parcela = this.findByDebitoParcela(idDebito, livroParcelaTributo.getId().getDebitoParcelaTributo().getParcela());
        boolean isPago = parcela.getSituacaoDebito().isPago();
        SituacaoParcela situacaoParcela = novaSituacaoParcela = !isPago ? this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.ESTORNO_BAIXA_INSCRICAO_DIVIDA_ATIVA, parcela.getSituacaoDebito()) : parcela.getSituacaoDebito();
        if (Boolean.FALSE.equals(isPago)) {
            parcela.setLivro(null);
            parcela.setExercicioLivro(null);
            parcela.setSituacaoLegal(SituacaoLegal.NO_EXERCICIO);
            parcela.setNumeroFolha(null);
            parcela.setNumeroInscricao(null);
            parcela.setSituacaoDebito(novaSituacaoParcela);
            this.debitoParcelaRepository.save((Object)parcela);
        }
    }

    public void estornoParcelaLivroDividaAtivaEnglobado(DebitoIdDTO idDebitoEnglobado) {
        DebitoParcela parcela = this.findByDebitoParcela(idDebitoEnglobado, Long.valueOf(1L));
        parcela.setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.BAIXA_CANCELAMENTO, parcela.getSituacaoDebito()));
        this.debitoParcelaRepository.save((Object)parcela);
    }

    public void updateDebitoParcelaPagamentoTotem(DebitoParcela debitoParcela, SituacaoParcela situacaoParcelaPagoTotem, String observacao) {
        if (!debitoParcela.getSituacaoDebito().getId().equals(situacaoParcelaPagoTotem.getId())) {
            debitoParcela.setSituacaoDebito(situacaoParcelaPagoTotem);
            debitoParcela.setDataSituacao(LocalDate.now());
            DebitoParcelaObservacaoId debitoParcelaObservacaoId = DebitoParcelaObservacaoId.create((DebitoParcela)debitoParcela);
            DebitoParcelaObservacao parcelaObservacao = new DebitoParcelaObservacao();
            parcelaObservacao.setId(debitoParcelaObservacaoId);
            parcelaObservacao.setDataInclusao(LocalDate.now());
            parcelaObservacao.setUsuario(SecurityUtils.getUserAise());
            parcelaObservacao.setObservacao(observacao);
            debitoParcela.getObservacoes().add(parcelaObservacao);
            this.debitoParcelaRepository.save((Object)debitoParcela);
        }
    }

    public void addDescricaoDebitoParcelaPagamento(DebitoParcela debitoParcela, String observacao) {
        DebitoParcelaObservacaoId debitoParcelaObservacaoId = DebitoParcelaObservacaoId.create((DebitoParcela)debitoParcela);
        DebitoParcelaObservacao parcelaObservacao = new DebitoParcelaObservacao();
        parcelaObservacao.setId(debitoParcelaObservacaoId);
        parcelaObservacao.setDataInclusao(LocalDate.now());
        parcelaObservacao.setUsuario(SecurityUtils.getUserAise());
        parcelaObservacao.setObservacao(observacao);
        debitoParcela.getObservacoes().add(parcelaObservacao);
        this.debitoParcelaRepository.save((Object)debitoParcela);
    }

    public List<DebitoParcela> findByIdPeticao(Long idPeticao) {
        return this.debitoParcelaRepository.findByIdPeticao(idPeticao);
    }

    public void updateParcelaProtesto(Documento documento, Long idProtesto, JobExecution jobExecution) {
        List documentoItemDividaAtivas = this.documentoItemDividaAtivaService.findByDocumentoId(documento.getId());
        try {
            documentoItemDividaAtivas.forEach(cda -> cda.getDebito().getParcelas().forEach(parcela -> {
                parcela.setIdProtesto(idProtesto);
                parcela.setDataSituacao(LocalDate.now());
                this.debitoParcelaRepository.save(parcela);
            }));
        }
        catch (Exception ex) {
            if (Objects.nonNull(jobExecution)) {
                GeracaoProtestoErro geracaoProtestoErro = new GeracaoProtestoErro();
                geracaoProtestoErro.setErro(String.format("Erro ao atualizar parcelas da CDA %d. %s", documento.getId(), ex.getMessage()));
                geracaoProtestoErro.setBatchJobExecutionSimulacao(BatchJobExecution.of((JobExecution)jobExecution));
                this.geracaoProtestoErroRepository.save((Object)geracaoProtestoErro);
            }
            throw new EloValidationException(String.format("Erro ao atualizar parcelas da CDA %d. %s", documento.getId(), ex.getMessage()));
        }
    }

    public Page<DebitoParcela> findValidDebtsForInclusion(Long tipoCadastro, Long cadastroGeral, String search, Pageable pageable) {
        return this.debitoParcelaRepositoryImpl.findDebitosSemVinculoCda(tipoCadastro, cadastroGeral, search, pageable);
    }

    public void cancelarParcelaAberta(DebitoParcela debitoParcela) {
        SituacaoParcela situacaoParcelaCancelado = this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.BAIXA_CANCELAMENTO, debitoParcela.getSituacaoDebito());
        if (!debitoParcela.getSituacaoDebito().getId().equals(situacaoParcelaCancelado.getId())) {
            debitoParcela.setSituacaoDebito(situacaoParcelaCancelado);
            debitoParcela.setDataSituacao(LocalDate.now());
            this.debitoParcelaRepository.save((Object)debitoParcela);
        }
    }

    public void abrirParcelaSemReabrirParcelamento(DebitoParcela debitoParcela) {
        SituacaoParcela situacaoParcelaAberta = this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.INSCRICAO, debitoParcela.getSituacaoDebito());
        if (!debitoParcela.getSituacaoDebito().getId().equals(situacaoParcelaAberta.getId())) {
            debitoParcela.setSituacaoDebito(situacaoParcelaAberta);
            debitoParcela.setDataSituacao(LocalDate.now());
            this.debitoParcelaRepository.save((Object)debitoParcela);
        }
    }

    @Generated
    public DebitoParcelaService(DebitoParcelaRepository debitoParcelaRepository, DebitoParcelaRepositoryImpl debitoParcelaRepositoryImpl, SituacaoParcelaService situacaoParcelaService, ParcelamentoService parcelamentoService, DocumentoItemDividaAtivaService documentoItemDividaAtivaService, GeracaoProtestoErroRepository geracaoProtestoErroRepository) {
        this.debitoParcelaRepository = debitoParcelaRepository;
        this.debitoParcelaRepositoryImpl = debitoParcelaRepositoryImpl;
        this.situacaoParcelaService = situacaoParcelaService;
        this.parcelamentoService = parcelamentoService;
        this.documentoItemDividaAtivaService = documentoItemDividaAtivaService;
        this.geracaoProtestoErroRepository = geracaoProtestoErroRepository;
    }
}

