/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoAutomaticoOpcao;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.debitoautomatico.ConsultaDebitoAutomaticoDTO;
import br.com.elotech.tributos.dto.debitoautomatico.ConsultaDebitoAutomaticoDetalheDTO;
import br.com.elotech.tributos.repository.DebitoAutomaticoOpcaoRepository;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import br.com.elotech.tributos.util.GeradorDigitoVerificador;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class DebitoAutomaticoOpcaoService
extends CrudService<DebitoAutomaticoOpcao, Long> {
    private static final Integer RELATORIO_INFORMACOES_DEBITO_AUTOMATICO = 200;
    private static final String PARAM_FORMAT = "%s=%s%n";
    private final DebitoAutomaticoOpcaoRepository debitoAutomaticoOpcaoRepository;
    private final DebitoRepository debitoRepository;
    private final EntidadeRepository entidadeRepository;
    private final ExercicioService exercicioService;
    private final AiseRelatorioService aiseRelatorioService;

    public Page<ConsultaDebitoAutomaticoDTO> consultaRemessa(String search, Pageable pageable) {
        return this.debitoAutomaticoOpcaoRepository.consultaDebitosAutomaticos(search, pageable);
    }

    public List<ConsultaDebitoAutomaticoDetalheDTO> consultaRemessaDetalhes(Long id) {
        return this.debitoAutomaticoOpcaoRepository.consultaDetalhesDaRemessaById(id);
    }

    public DebitoAutomaticoOpcao findOpcaoByIdDebito(Long idDebito) {
        return this.debitoAutomaticoOpcaoRepository.findByIdDebito(idDebito).orElseGet(() -> {
            DebitoAutomaticoOpcao opcao = new DebitoAutomaticoOpcao();
            this.debitoRepository.findById((Object)idDebito).ifPresent(debito -> {
                opcao.setEntidade(debito.getEntidade());
                opcao.setExercicio(debito.getExercicio());
                opcao.setTipoCadastro(debito.getTipoCadastro());
                opcao.setCadastroGeral(debito.getCadastroGeralId());
                opcao.setGuiaRecolhimento(debito.getGuiaRecolhimento());
                opcao.setSubDivida(debito.getSubDivida());
            });
            return opcao;
        });
    }

    protected void beforeSave(DebitoAutomaticoOpcao opcao, Authentication authentication) {
        if (Objects.isNull(opcao.getId())) {
            if (Objects.isNull(opcao.getDataImplantacao())) {
                opcao.setDataImplantacao(LocalDate.now());
            }
            if (StringUtils.isEmpty((CharSequence)opcao.getUsuario())) {
                opcao.setUsuario(SecurityUtils.getUserAise());
            }
        }
        if (StringUtils.isEmpty((CharSequence)opcao.getIdentificacaoOrigem())) {
            Integer digito = this.getDigitoByChaveDebito(opcao.getExercicio(), opcao.getCadastroGeral(), opcao.getGuiaRecolhimento(), opcao.getSubDivida());
            String identificacao = this.getItentificacaoOrigem(opcao, digito);
            opcao.setIdentificacaoOrigem(identificacao);
        }
        super.beforeSave((EloEntity)opcao, authentication);
    }

    public Integer getDigitoByChaveDebito(Long exercicio, Long cadastroGeral, Long guiaRecolhimento, Long subDivida) {
        StringBuilder codigo = new StringBuilder();
        codigo.append(StringUtils.leftPad((String)cadastroGeral.toString(), (int)8, (String)"0"));
        codigo.append(exercicio);
        codigo.append(StringUtils.leftPad((String)guiaRecolhimento.toString(), (int)2, (String)"0"));
        codigo.append(StringUtils.leftPad((String)subDivida.toString(), (int)2, (String)"0"));
        return GeradorDigitoVerificador.geradorDigitoVerificadorMod11((String)codigo.toString());
    }

    private Integer getDigitoByDebito(Debito debito) {
        return this.getDigitoByChaveDebito(debito.getExercicio(), debito.getCadastroGeralId(), debito.getGuiaRecolhimento(), debito.getSubDivida());
    }

    public String getItentificacaoOrigem(DebitoAutomaticoOpcao opcao, Integer digito) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.leftPad((String)opcao.getTipoCadastro().toString(), (int)2, (String)"0"));
        sb.append(StringUtils.leftPad((String)opcao.getCadastroGeral().toString(), (int)13, (String)"0"));
        sb.append(opcao.getExercicio().toString());
        sb.append(StringUtils.leftPad((String)opcao.getGuiaRecolhimento().toString(), (int)2, (String)"0"));
        sb.append(StringUtils.leftPad((String)opcao.getSubDivida().toString(), (int)2, (String)"0"));
        sb.append(digito.toString());
        sb.append(opcao.getFormaPagamento().getCodigoDebitoAutomatico().toString());
        return sb.toString();
    }

    public byte[] imprimirInformacoesDebitoAutomatico(Long idDebito) {
        Entidade entidadeprincipal = this.entidadeRepository.findByEntidadeprincipal();
        Long exercicio = this.exercicioService.getExercicio();
        Debito debito = (Debito)this.debitoRepository.findOne((Object)idDebito);
        if (Objects.isNull(debito)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado o d\u00e9bito com id %d", idDebito));
        }
        String digito = this.getDigitoByDebito(debito).toString();
        String parametros = String.format(PARAM_FORMAT, "PNomeEntidade", entidadeprincipal.getNome()).concat(String.format(PARAM_FORMAT, "PExercicio", exercicio)).concat(String.format(PARAM_FORMAT, "PDescUF", entidadeprincipal.getUnidadeFederacao())).concat(String.format(PARAM_FORMAT, "PDigito", digito));
        ImprimirRelatorioDTO imprimirRelatorioDTO = new ImprimirRelatorioDTO();
        imprimirRelatorioDTO.setRelatorio(RELATORIO_INFORMACOES_DEBITO_AUTOMATICO);
        imprimirRelatorioDTO.setFiltro(String.format(" dao.iddebito = %d ", idDebito));
        imprimirRelatorioDTO.setListParametros(parametros);
        byte[] arquivo = this.aiseRelatorioService.imprimirRelatorioGenerico(imprimirRelatorioDTO);
        if (Objects.isNull(arquivo)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "O relat\u00f3rio est\u00e1 inv\u00e1lido");
        }
        return arquivo;
    }

    @Generated
    public DebitoAutomaticoOpcaoService(DebitoAutomaticoOpcaoRepository debitoAutomaticoOpcaoRepository, DebitoRepository debitoRepository, EntidadeRepository entidadeRepository, ExercicioService exercicioService, AiseRelatorioService aiseRelatorioService) {
        this.debitoAutomaticoOpcaoRepository = debitoAutomaticoOpcaoRepository;
        this.debitoRepository = debitoRepository;
        this.entidadeRepository = entidadeRepository;
        this.exercicioService = exercicioService;
        this.aiseRelatorioService = aiseRelatorioService;
    }
}

