/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.ContenciosoArquivoS3;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoDebitoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoGerarBoletoDTO;
import br.com.elotech.tributos.enums.SituacaoRecalculoContencioso;
import br.com.elotech.tributos.repository.ContenciosoArquivoS3Repository;
import br.com.elotech.tributos.repository.ContenciosoRepository;
import br.com.elotech.tributos.service.ArquivoUnicoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.batch.ContenciosoRecalculoBoletoJobStarter;
import br.com.elotech.tributos.service.batch.ContenciosoRecalculoJobStarter;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ContenciosoRecalculoService {
    private ContenciosoRepository contenciosoRepository;
    private ContenciosoArquivoS3Repository contenciosoArquivoS3Repository;
    private ExercicioService exercicioService;
    private ContenciosoRecalculoJobStarter contenciosoRecalculoJobStarter;
    private ArquivoStorageFeignClient arquivoStorageFeignClient;
    private DebitoService debitoService;
    private ContenciosoRecalculoBoletoJobStarter contenciosoRecalculoBoletoJobStarter;
    private ArquivoUnicoService arquivoUnicoService;

    public void recalcularContencioso(Long idContencioso, ContenciosoRecalculoDTO contenciosoRecalculoDTO) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JsonProcessingException, JobRestartException {
        Contencioso contencioso = (Contencioso)this.contenciosoRepository.findById((Object)idContencioso).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Contencioso com id %d n\u00e3o foi localizado"));
        Long exercicioAtual = this.exercicioService.getExercicio();
        ArrayList debitosParaRecalculo = new ArrayList();
        contenciosoRecalculoDTO.getDebitos().forEach(cd -> contencioso.getDebitos().stream().filter(contenciosoDebito -> contenciosoDebito.getId().equals((Object)cd.getId()) && cd.isSelected() != false).findFirst().ifPresent(contenciosoDebito -> {
            ContenciosoRecalculoDebitoDTO dto = new ContenciosoRecalculoDebitoDTO();
            dto.setId(contenciosoDebito.getId());
            dto.setTipo(contenciosoRecalculoDTO.getTipo());
            dto.setDataPrimeiroVencimento(cd.getDataPrimeiroVencimento());
            debitosParaRecalculo.add(dto);
        }));
        this.contenciosoRecalculoJobStarter.startJob(idContencioso, exercicioAtual, contenciosoRecalculoDTO.getIdDivida(), debitosParaRecalculo);
    }

    public JobExecution gerarBoletosBatch(Long idContencioso, ContenciosoRecalculoGerarBoletoDTO contenciosoRecalculoGerarBoletoDTO) throws IOException, JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        Contencioso contencioso = (Contencioso)this.contenciosoRepository.findById((Object)idContencioso).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Contencioso com id %d n\u00e3o foi localizado"));
        List debitosRecalculo = contencioso.getDebitos().stream().filter(d -> SituacaoRecalculoContencioso.DEBITO_GERADO.equals((Object)d.getSituacaoRecalculo())).map(ContenciosoDebito::getDebitoRecalculo).map(Debito::getId).collect(Collectors.toList());
        List formasDePagamento = contenciosoRecalculoGerarBoletoDTO.getFormasDePagamento().stream().map(FormaPagamento::getId).collect(Collectors.toList());
        return this.contenciosoRecalculoBoletoJobStarter.startJob(idContencioso, debitosRecalculo, formasDePagamento, contenciosoRecalculoGerarBoletoDTO.getGerarCarne());
    }

    public ContenciosoArquivoS3 findByBatchJobExecutionId(Long idJobExecution) {
        return (ContenciosoArquivoS3)this.contenciosoArquivoS3Repository.findByBatchJobExecutionId(idJobExecution).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "Arquivo n\u00e3o encontrado para o job de execu\u00e7\u00e3o com id " + idJobExecution));
    }

    public byte[] download(Long idArquivoS3) {
        return this.arquivoUnicoService.baixarPDF(idArquivoS3);
    }

    @Generated
    public ContenciosoRecalculoService(ContenciosoRepository contenciosoRepository, ContenciosoArquivoS3Repository contenciosoArquivoS3Repository, ExercicioService exercicioService, ContenciosoRecalculoJobStarter contenciosoRecalculoJobStarter, ArquivoStorageFeignClient arquivoStorageFeignClient, DebitoService debitoService, ContenciosoRecalculoBoletoJobStarter contenciosoRecalculoBoletoJobStarter, ArquivoUnicoService arquivoUnicoService) {
        this.contenciosoRepository = contenciosoRepository;
        this.contenciosoArquivoS3Repository = contenciosoArquivoS3Repository;
        this.exercicioService = exercicioService;
        this.contenciosoRecalculoJobStarter = contenciosoRecalculoJobStarter;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.debitoService = debitoService;
        this.contenciosoRecalculoBoletoJobStarter = contenciosoRecalculoBoletoJobStarter;
        this.arquivoUnicoService = arquivoUnicoService;
    }
}

