/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetaria;
import br.com.elotech.tributos.domain.parcelamento.EstornoAtualizacaoMonetaria;
import br.com.elotech.tributos.domain.parcelamento.TipoAtualizacaoMonetaria;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaItemDTO;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaParcelamentoParams;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.FiltroItensAtualizacaoMonetariaDTO;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.TotalizadorAtualizacaoMonetariaDTO;
import br.com.elotech.tributos.repository.atualizacaomonetaria.AtualizacaoMonetariaParcelamentoRepository;
import br.com.elotech.tributos.repository.parcelamento.AtualizacaoMonetariaRepository;
import br.com.elotech.tributos.service.EstornoAtualizacaoMonetariaService;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AtualizacaoMonetariaService
extends CrudService<AtualizacaoMonetaria, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoMonetariaService.class);
    private final AtualizacaoMonetariaRepository atualizacaoMonetariaRepository;
    private final AtualizacaoMonetariaParcelamentoRepository atualizacaoMonetariaParcelamentoRepository;
    private final EstornoAtualizacaoMonetariaService estornoAtualizacaoMonetariaService;

    public boolean existsAtualizacaoRealizadaNoMes(Long entidade, Long exercicio, Long mes, TipoAtualizacaoMonetaria tipo) {
        return this.atualizacaoMonetariaRepository.existsByEntidadeEqualsAndAnoEqualsAndMesAndTipoAndEstornadoEquals(entidade, Integer.valueOf(exercicio.intValue()), Integer.valueOf(mes.intValue()), tipo, Boolean.FALSE);
    }

    public boolean existsDebitoByFiltro(AtualizacaoMonetariaParcelamentoParams params) {
        return this.atualizacaoMonetariaParcelamentoRepository.existsByFiltro(params);
    }

    public boolean possuiItensEstornados(Long id) {
        return this.atualizacaoMonetariaRepository.existsItensEstornadosById(id);
    }

    public AtualizacaoMonetaria marcarComoEstornado(Long idEstornoAtualizacaoMonetaria) {
        EstornoAtualizacaoMonetaria estorno = (EstornoAtualizacaoMonetaria)this.estornoAtualizacaoMonetariaService.findById((Serializable)idEstornoAtualizacaoMonetaria).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar um estorno com o id %d.", idEstornoAtualizacaoMonetaria)));
        AtualizacaoMonetaria atualizacao = estorno.getAtualizacaoMonetaria();
        atualizacao.setDataEstorno(LocalDateTime.now());
        atualizacao.setUsuarioEstorno(estorno.getUsuario());
        atualizacao.setMotivoEstorno(estorno.getObservacao());
        atualizacao.setEstornado(Boolean.TRUE);
        return (AtualizacaoMonetaria)this.save((EloEntity)atualizacao, null);
    }

    public void delete(Long id) {
        this.findById((Serializable)id).ifPresent(atualizacao -> this.delete((EloEntity)atualizacao, null));
    }

    public Page<AtualizacaoMonetariaItemDTO> searchItensById(Long id, FiltroItensAtualizacaoMonetariaDTO params, Boolean agrupadoPorDebito, Pageable pageable) {
        return this.atualizacaoMonetariaParcelamentoRepository.searchItens(id, params, agrupadoPorDebito, pageable);
    }

    public TotalizadorAtualizacaoMonetariaDTO getTotalizadorAtualizacaoMonetaria(Long id, FiltroItensAtualizacaoMonetariaDTO filtro) {
        return this.atualizacaoMonetariaParcelamentoRepository.getTotalizador(id, filtro);
    }

    @Generated
    public AtualizacaoMonetariaService(AtualizacaoMonetariaRepository atualizacaoMonetariaRepository, AtualizacaoMonetariaParcelamentoRepository atualizacaoMonetariaParcelamentoRepository, EstornoAtualizacaoMonetariaService estornoAtualizacaoMonetariaService) {
        this.atualizacaoMonetariaRepository = atualizacaoMonetariaRepository;
        this.atualizacaoMonetariaParcelamentoRepository = atualizacaoMonetariaParcelamentoRepository;
        this.estornoAtualizacaoMonetariaService = estornoAtualizacaoMonetariaService;
    }
}

