/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.supersimples.pgfn;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnArquivo;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoDTO;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoItemDTO;
import br.com.elotech.tributos.service.supersimples.pgfn.ImportacaoArquivoPgfnJobStarter;
import br.com.elotech.tributos.service.supersimples.pgfn.PgfnArquivoItemService;
import br.com.elotech.tributos.service.supersimples.pgfn.PgfnArquivoService;
import br.com.elotech.tributos.service.supersimples.pgfn.ProcessamentoArquivoPgfnJobStarter;
import br.com.elotech.tributos.service.supersimples.pgfn.VerificacaoArquivoPgfnJobStarter;
import java.io.IOException;
import java.io.Serializable;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/pgfn-arquivo"})
public class PgfnArquivoResource {
    private final PgfnArquivoService pgfnArquivoService;
    private final PgfnArquivoItemService pgfnArquivoItemService;
    private final ImportacaoArquivoPgfnJobStarter importacaoArquivoPgfnJobStarter;
    private final VerificacaoArquivoPgfnJobStarter verificacaoArquivoPgfnJobStarter;
    private final ProcessamentoArquivoPgfnJobStarter processamentoArquivoPgfnJobStarter;

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PgfnArquivoDTO> findOne(@PathVariable(value="id") Long id) {
        return this.pgfnArquivoService.findById((Serializable)id).map(PgfnArquivoDTO::from).map(ResponseEntity::ok).orElseThrow(RestException::notFound);
    }

    @GetMapping
    public ResponseEntity<Page<PgfnArquivoDTO>> search(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page pgfnArquivos = this.pgfnArquivoService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)pgfnArquivos.map(PgfnArquivoDTO::from));
    }

    @PostMapping(value={"/importar"})
    public ResponseEntity<PgfnArquivoDTO> importar(@RequestParam MultipartFile file) throws IOException, JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        PgfnArquivo pgfnArquivo = this.pgfnArquivoService.importArquivo(file);
        this.importacaoArquivoPgfnJobStarter.startJob(pgfnArquivo);
        return ResponseEntity.ok((Object)PgfnArquivoDTO.from((PgfnArquivo)pgfnArquivo));
    }

    @PostMapping(value={"/{id}/itens/verificar"})
    public ResponseEntity<Void> verificarItensBatch(@PathVariable(value="id") Long id) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.pgfnArquivoService.validateConfiguracao();
        this.verificacaoArquivoPgfnJobStarter.startJob(id);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/itens/{idItem}/verificar"})
    public ResponseEntity<Void> verificarItem(@PathVariable(value="idItem") Long iditem) {
        this.pgfnArquivoItemService.findItemAndVerificar(iditem);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{id}/itens/processar"})
    public ResponseEntity<Void> processarItensBatch(@PathVariable(value="id") Long id) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.pgfnArquivoService.validateConfiguracao();
        this.processamentoArquivoPgfnJobStarter.startJob(id);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/itens/{idItem}/processar"})
    public ResponseEntity<Void> processarItem(@PathVariable(value="idItem") Long iditem) {
        this.pgfnArquivoItemService.findItemAndProcessar(iditem);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{id}/itens"})
    public ResponseEntity<Page<PgfnArquivoItemDTO>> searchItens(@PathVariable(value="id") Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.pgfnArquivoItemService.searchItens(id, search, pageable));
    }

    @GetMapping(value={"/itens/{idItem}"})
    public ResponseEntity<PgfnArquivoItemDTO> findOneItem(@PathVariable(value="idItem") Long idItem) {
        return this.pgfnArquivoItemService.findById((Serializable)idItem).map(PgfnArquivoItemDTO::new).map(ResponseEntity::ok).orElseThrow(RestException::notFound);
    }

    @Generated
    public PgfnArquivoResource(PgfnArquivoService pgfnArquivoService, PgfnArquivoItemService pgfnArquivoItemService, ImportacaoArquivoPgfnJobStarter importacaoArquivoPgfnJobStarter, VerificacaoArquivoPgfnJobStarter verificacaoArquivoPgfnJobStarter, ProcessamentoArquivoPgfnJobStarter processamentoArquivoPgfnJobStarter) {
        this.pgfnArquivoService = pgfnArquivoService;
        this.pgfnArquivoItemService = pgfnArquivoItemService;
        this.importacaoArquivoPgfnJobStarter = importacaoArquivoPgfnJobStarter;
        this.verificacaoArquivoPgfnJobStarter = verificacaoArquivoPgfnJobStarter;
        this.processamentoArquivoPgfnJobStarter = processamentoArquivoPgfnJobStarter;
    }
}

