/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.solicitacaoaprovacao;

import br.com.elotech.tributos.domain.solicitacaoaprovacao.SolicitacaoAprovacao;
import br.com.elotech.tributos.dto.solicitacaoaprovacao.AproveSolicitacaoAprovacaoDTO;
import br.com.elotech.tributos.dto.solicitacaoaprovacao.NewSolicitacaoAprovacaoDTO;
import br.com.elotech.tributos.dto.solicitacaoaprovacao.SolicitacaoAprovacaoDTO;
import br.com.elotech.tributos.service.solicitacaoaprovacao.SolicitacaoAprovacaoService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/solicitacao-aprovacao"})
public class SolicitacaoAprovacaoResource {
    private final SolicitacaoAprovacaoService service;

    public SolicitacaoAprovacaoResource(SolicitacaoAprovacaoService service) {
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<Page<SolicitacaoAprovacao>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.service.findAll(search, pageable));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<SolicitacaoAprovacao> findById(@PathVariable Long id) {
        SolicitacaoAprovacao solicitacaoAprovacao = this.service.buscaPorId(id);
        return ResponseEntity.ok((Object)solicitacaoAprovacao);
    }

    @PostMapping
    public ResponseEntity<SolicitacaoAprovacao> create(@RequestBody NewSolicitacaoAprovacaoDTO dto) {
        SolicitacaoAprovacao solicitacaoAprovacao = this.service.create(dto);
        return ResponseEntity.ok((Object)solicitacaoAprovacao);
    }

    @PutMapping(value={"/aprovar"})
    public ResponseEntity<SolicitacaoAprovacao> aprovar(@RequestBody AproveSolicitacaoAprovacaoDTO dto) {
        SolicitacaoAprovacao solicitacaoAprovacao = this.service.aprovar(dto);
        return ResponseEntity.ok((Object)solicitacaoAprovacao);
    }

    @PutMapping(value={"/rejeitar"})
    public ResponseEntity<SolicitacaoAprovacao> rejeitar(@RequestBody SolicitacaoAprovacaoDTO dto) {
        SolicitacaoAprovacao solicitacaoAprovacao = this.service.rejeitar(dto);
        return ResponseEntity.ok((Object)solicitacaoAprovacao);
    }
}

