/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.ServicoElogeoDTO;
import br.com.elotech.tributos.service.ServicoService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/servico"})
public class ServicoElogeoResource {
    private final ServicoService servicoService;

    public ServicoElogeoResource(ServicoService servicoService) {
        this.servicoService = servicoService;
    }

    @Operation(summary="Retorna uma lista de servi\u00e7os")
    @GetMapping
    public ResponseEntity<Page<ServicoElogeoDTO>> findAll(Pageable page) {
        Page servico = this.servicoService.findAll(page).map(ServicoElogeoDTO::from);
        return ResponseEntity.ok((Object)servico);
    }

    @Operation(summary="Retorna um servi\u00e7o em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<ServicoElogeoDTO> findById(@PathVariable Long id) {
        ServicoElogeoDTO servicoElogeoDTO = this.servicoService.findById((Serializable)id).map(ServicoElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o servi\u00e7o com o id '%d'.", id)));
        return ResponseEntity.ok((Object)servicoElogeoDTO);
    }
}

