/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.ProprietarioElogeoDTO;
import br.com.elotech.tributos.service.ProprietarioService;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/proprietario"})
public class ProprietarioElogeoResource {
    private final ProprietarioService proprietarioService;

    public ProprietarioElogeoResource(ProprietarioService proprietarioService) {
        this.proprietarioService = proprietarioService;
    }

    @Operation(summary="Retorna uma lista de propriet\u00e1rios")
    @GetMapping
    public ResponseEntity<Page<ProprietarioElogeoDTO>> findAll(@ParameterObject Pageable page) {
        Page proprietarios = this.proprietarioService.findAll(page).map(ProprietarioElogeoDTO::from);
        return ResponseEntity.ok((Object)proprietarios);
    }

    @Operation(summary="Retorna um propriet\u00e1rio em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<ProprietarioElogeoDTO> findById(@PathVariable Long id) {
        ProprietarioElogeoDTO proprietarioElogeoDTO = this.proprietarioService.findById((Serializable)id).map(ProprietarioElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Propriet\u00e1rio com o id '%d'.", id)));
        return ResponseEntity.ok((Object)proprietarioElogeoDTO);
    }
}

