/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReport;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.dto.FiltroArrecadacaoPorTributoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoResumoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoValoresDTO;
import br.com.elotech.tributos.enums.TipoArquivoJasper;
import br.com.elotech.tributos.report.loader.ExtratoDebitoParamLoader;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoJasperService;
import br.com.elotech.tributos.service.integracaocontabil.ArrecadacaoPorTributoService;
import br.com.elotech.tributos.util.JasperUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/arrecadacao-por-tributos"})
public class ArrecadacaoPorTributoResource {
    private final ArrecadacaoPorTributoService arrecadacaoPorTributoService;
    private final ArquivoJasperService arquivoJasperService;
    private final ObjectMapper objectMapper;
    private final ExtratoDebitoParamLoader extratoDebitoParamLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;

    public ArrecadacaoPorTributoResource(ArrecadacaoPorTributoService arrecadacaoPorTributoService, ArquivoJasperService arquivoJasperService, ObjectMapper objectMapper, ExtratoDebitoParamLoader extratoDebitoParamLoader, ReportFileResolverFactory reportFileResolverFactory) {
        this.arrecadacaoPorTributoService = arrecadacaoPorTributoService;
        this.arquivoJasperService = arquivoJasperService;
        this.objectMapper = objectMapper;
        this.extratoDebitoParamLoader = extratoDebitoParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
    }

    @PostMapping(value={"/imprimir"})
    public ResponseEntity<byte[]> printArrecadacaoPorTributos(@RequestBody @Valid FiltroArrecadacaoPorTributoDTO filtro, @RequestParam(value="reportType") String reportType, Pageable pageable) throws IOException {
        byte[] fileBytes;
        String fileExtension = Objects.equals(reportType, "pdf") ? "pdf" : "csv";
        String contentType = Objects.equals(reportType, "pdf") ? "application/pdf" : "text/csv";
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarArquivoJasperPorTipo(TipoArquivoJasper.ARRECADACAO_POR_TRIBUTO);
        String filePath = JasperUtils.geraCaminhoArquivoJasper((ArquivoJasper)arquivoJasper, (String)"arrecadacao-por-tributo.jrxml");
        Page tributoValoresDTOSPage = this.arrecadacaoPorTributoService.imprimir(filtro, pageable);
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)tributoValoresDTOSPage.getContent(), ArrecadacaoPorTributoValoresDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.extratoDebitoParamLoader).param(Param.of((String)"USUARIO", (Object)SecurityUtils.getUserAise())).param(Param.of((String)"FILTRO", (Object)filtro.getSearch())).build();
        EloReport report = EloReportFactory.jasper().reportFile(new ReportFileResolverFactory("").fromFile(filePath)).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build();
        byte[] byArray = fileBytes = Objects.equals(reportType, "pdf") ? report.exportToPdf() : report.exportToCsv();
        if (Objects.nonNull(arquivoJasper)) {
            Files.deleteIfExists(Paths.get(filePath, new String[0]));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)contentType));
        headers.setContentDisposition(ContentDisposition.builder((String)"attachment").filename("arrecadacao-por-tributo." + fileExtension).build());
        headers.setContentLength((long)fileBytes.length);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)fileBytes);
    }

    @GetMapping(value={"/get-all-tipos-receita"})
    public ResponseEntity<Map<String, String>> getAllTiposReceita(@RequestParam(value="search") String search) {
        return ResponseEntity.ok((Object)this.arrecadacaoPorTributoService.getAllTiposReceita(search));
    }

    @PostMapping(value={"/consulta"})
    public ResponseEntity<ArrecadacaoPorTributoResumoDTO> findArrecadacaoPorTributos(@RequestBody @Valid FiltroArrecadacaoPorTributoDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.arrecadacaoPorTributoService.getArrecadacaoPorTributo(filtro, pageable));
    }
}

