/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.autoinfracao;

import br.com.elotech.tributos.domain.autoinfracao.AutoInfracao;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.autoinfracao.AutoInfracaoCancelamentoDTO;
import br.com.elotech.tributos.dto.autoinfracao.AutoInfracaoDTO;
import br.com.elotech.tributos.dto.autoinfracao.AutoInfracaoDescontoDTO;
import br.com.elotech.tributos.dto.autoinfracao.AutoInfracaoRowDTO;
import br.com.elotech.tributos.service.autoinfracao.AutoInfracaoBoletoService;
import br.com.elotech.tributos.service.autoinfracao.AutoInfracaoService;
import java.net.URI;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/auto-infracao"})
@Transactional
public class AutoInfracaoResource {
    private final AutoInfracaoService service;
    private final AutoInfracaoBoletoService autoInfracaoBoletoService;

    @GetMapping
    public ResponseEntity<Page<AutoInfracaoRowDTO>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.service.findByRsql(search, pageable).map(AutoInfracaoRowDTO::from));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<AutoInfracaoDTO> findOne(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.service.findDto(id));
    }

    @PostMapping
    public ResponseEntity<AutoInfracaoDTO> save(@RequestBody AutoInfracaoDTO dto) {
        AutoInfracao auto = this.service.save(dto);
        URI resourceURI = ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{auto.getId()}).toUri();
        return ResponseEntity.created((URI)resourceURI).body((Object)AutoInfracaoDTO.from((AutoInfracao)auto));
    }

    @PostMapping(value={"/{id}/validar-alteracao-valores"})
    public ResponseEntity<Boolean> validarAlteracaoValores(@PathVariable Long id, @RequestBody @Valid AutoInfracaoDTO dto) {
        return ResponseEntity.ok((Object)this.service.validaAlteracaoValores(id, dto));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<AutoInfracaoDTO> update(@PathVariable Long id, @RequestBody AutoInfracaoDTO dto) {
        return ResponseEntity.ok((Object)AutoInfracaoDTO.from((AutoInfracao)this.service.update(id, dto)));
    }

    @PostMapping(value={"/{id}/gerar-debito"})
    public ResponseEntity<AutoInfracaoDTO> gerarDebito(@PathVariable Long id) {
        AutoInfracao auto = this.service.gerarDebito(id);
        return ResponseEntity.ok((Object)AutoInfracaoDTO.from((AutoInfracao)auto));
    }

    @PostMapping(value={"/{id}/gerar-boleto"})
    public ResponseEntity<BloquetoDTO> gerarBoleto(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.autoInfracaoBoletoService.geraBoletoSemDesconto(id));
    }

    @GetMapping(value={"/{id}/simular-boleto-desconto"})
    public ResponseEntity<AutoInfracaoDescontoDTO> simularBoletoComDesconto(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.autoInfracaoBoletoService.simulaValorBoletoDesconto(id));
    }

    @PostMapping(value={"/{id}/gerar-boleto-com-desconto"})
    public ResponseEntity<BloquetoDTO> gerarBoleto(@PathVariable Long id, @RequestBody @Valid AutoInfracaoDescontoDTO dto) {
        return ResponseEntity.ok((Object)this.autoInfracaoBoletoService.geraBoletoComDesconto(id, dto));
    }

    @PutMapping(value={"/{id}/cancelar"})
    public ResponseEntity<Void> cancelar(@PathVariable Long id, @RequestBody @Valid AutoInfracaoCancelamentoDTO dto) {
        this.service.cancelarAutoInfracao(id, dto);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public AutoInfracaoResource(AutoInfracaoService service, AutoInfracaoBoletoService autoInfracaoBoletoService) {
        this.service = service;
        this.autoInfracaoBoletoService = autoInfracaoBoletoService;
    }
}

