/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.acrescimo;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.acrescimo.IndiceCorrecao;
import br.com.elotech.tributos.dto.acrescimo.CalculaValorIndiceMensalDTO;
import br.com.elotech.tributos.service.acrescimo.IndiceCorrecaoService;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/indice-correcao"})
@Transactional(readOnly=true)
public class IndiceCorrecaoResource
extends CrudResource<IndiceCorrecao, Long> {
    private final IndiceCorrecaoService indiceCorrecaoService;

    public IndiceCorrecaoResource(IndiceCorrecaoService indiceCorrecaoService) {
        this.indiceCorrecaoService = indiceCorrecaoService;
    }

    @PostMapping(value={"/calcular-valor-indice-mensal"})
    public ResponseEntity<CalculaValorIndiceMensalDTO> calcularValorIndiceMensal(@RequestBody @Valid CalculaValorIndiceMensalDTO dto) {
        return ResponseEntity.ok((Object)this.indiceCorrecaoService.calcularValorIndiceMensal(dto));
    }
}

