/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.service.PessoaService;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pessoa"})
public class PessoaResource
extends CrudResource<Pessoa, Long> {
    private final PessoaService pessoaService;

    public PessoaResource(PessoaService pessoaService) {
        this.pessoaService = pessoaService;
    }

    @GetMapping(params={"cnpjCpf"})
    public ResponseEntity<Pessoa> getByCnpjCpf(@RequestParam(value="cnpjCpf") String cnpjCpf) {
        return ResponseEntity.ok().body((Object)this.pessoaService.findByCnpjCpf(cnpjCpf));
    }

    @GetMapping(value={"/endereco"}, params={"cnpjCpf"})
    public ResponseEntity<EnderecoPessoa> getEnderecoByCnpjCpf(@RequestParam(value="cnpjCpf") String cnpjCpf) {
        return Optional.ofNullable(this.pessoaService.findByCnpjCpf(cnpjCpf)).map(Pessoa::getEnderecoPrincipal).map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/validar-codigo-alvara/{cnpj}/{codigoValidador}"})
    public ResponseEntity<Boolean> isCodigoAlvaraValido(@PathVariable(value="cnpj") String cnpj, @PathVariable(value="codigoValidador") String codigoValidador) {
        return ResponseEntity.ok((Object)this.pessoaService.isCodigoAlvaraValido(cnpj, codigoValidador));
    }
}

