/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.service.DocumentoUnificadoPeticaoCdaService;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/arquivo-unificado-peticoes"})
public class DocumentoUnificadoPeticaoCdaResource {
    private final DocumentoUnificadoPeticaoCdaService documentoUnificadoPeticaoCdaService;

    @GetMapping(value={"/{idPeticao}"})
    public void gerarArquivoUnificado(@PathVariable Long idPeticao, HttpServletResponse response) throws IOException {
        ArquivoNovoRequest arquivo = this.documentoUnificadoPeticaoCdaService.buildDocumentoUnificado(idPeticao);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "O arquivo est\u00e1 inv\u00e1lido");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (InputStream)arquivo.getContent(), (String)arquivo.getFileName());
        response.setHeader("Content-Disposition", "attachment; filename=" + arquivo.getFileName());
    }

    @PostMapping
    public ResponseEntity<Void> gerarArquivoUnificadoEmLote(@RequestBody List<Long> idsPeticoes) {
        this.documentoUnificadoPeticaoCdaService.gerarArquivoUnificadoEmLote(idsPeticoes);
        return ResponseEntity.accepted().build();
    }

    @Generated
    public DocumentoUnificadoPeticaoCdaResource(DocumentoUnificadoPeticaoCdaService documentoUnificadoPeticaoCdaService) {
        this.documentoUnificadoPeticaoCdaService = documentoUnificadoPeticaoCdaService;
    }
}

