/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.relatoriogerencial;

import br.com.elotech.core.utils.FileUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LancamentoArrecadacaoRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;

    private <T> T executarConsulta(String caminhoSql, Map<String, Object> parametros, String nomeColuna, Class<T> tipoRetorno) {
        String sql = FileUtils.readResourceAsString((String)caminhoSql);
        MapSqlParameterSource paramSource = new MapSqlParameterSource(parametros);
        return (T)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)paramSource, (rs, rowNum) -> rs.getObject(nomeColuna, tipoRetorno));
    }

    public BigDecimal buscaValorRevisadoAnterior(Long entidade, Long exercicio, Long mesAnalise) {
        HashMap<String, Long> parametros = new HashMap<String, Long>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("MesAnalise", mesAnalise);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/buscavalorrevisaoanterior.sql", parametros, "Revisoes", BigDecimal.class);
    }

    public BigDecimal buscaLancamentoAnualOxy(Long entidade, Long exercicio, LocalDate dataInclusao) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/lancamentoanualoxy.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal buscaLancamentoAnualAise(Long entidade, Long exercicio, LocalDate dataInclusao) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/lancamentoanualaise.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaArrecadacaoTotal(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal, boolean isLancamentoAnualOxy) {
        String sqlCalculaArrecadacaoTotal = "";
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        sqlCalculaArrecadacaoTotal = isLancamentoAnualOxy ? "sql/batch/relatoriogerencial/calculaarrecadacaototaloxy.sql" : "sql/batch/relatoriogerencial/calculaarrecadacaototalaise.sql";
        return (BigDecimal)this.executarConsulta(sqlCalculaArrecadacaoTotal, parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaSaldoEmAberto(Long entidade, Long exercicio, LocalDate dataFinal, boolean isLancamentoAnualOxy) {
        String sqlCalculaSaldoEmAberto = "";
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataFinal", dataFinal);
        sqlCalculaSaldoEmAberto = isLancamentoAnualOxy ? "sql/batch/relatoriogerencial/calculasaldoemabertooxy.sql" : "sql/batch/relatoriogerencial/calculasaldoemabertoaise.sql";
        return (BigDecimal)this.executarConsulta(sqlCalculaSaldoEmAberto, parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaDesconto(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculadesconto.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaArrecadacaoAVista(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculaarrecadacaoavista.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaCreditoAVista(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculacreditoavista.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaDescontoArrecadacaoAVista(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculadescontoarrecadacaoavista.sql", parametros, "Valor", BigDecimal.class);
    }

    public BigDecimal calculaDevolucaoAVista(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (BigDecimal)this.executarConsulta("sql/batch/relatoriogerencial/calculadevolucaoavista.sql", parametros, "Valor", BigDecimal.class);
    }

    public Long calculaArrecadadoAVistaCadastro(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (Long)this.executarConsulta("sql/batch/relatoriogerencial/calculaarrecadadoavistacadastro.sql", parametros, "Qtde", Long.class);
    }

    public Long calculaArrecadadoParceladoCadastro(Long entidade, Long exercicio, LocalDate dataInicial, LocalDate dataFinal) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInicial", dataInicial);
        parametros.put("DataFinal", dataFinal);
        return (Long)this.executarConsulta("sql/batch/relatoriogerencial/calculaarrecadadoparceladocadastro.sql", parametros, "Qtde", Long.class);
    }

    public Long calculaLancamentoAnualCadastro(Long entidade, Long exercicio, LocalDate dataInclusao, boolean isLancamentoAnualOxy) {
        String sqlCalculaLancamentoAnualCadastro = "";
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        sqlCalculaLancamentoAnualCadastro = isLancamentoAnualOxy ? "sql/batch/relatoriogerencial/calculalancamentoanualcadastrooxy.sql" : "sql/batch/relatoriogerencial/calculalancamentoanualcadastroaise.sql";
        return (Long)this.executarConsulta(sqlCalculaLancamentoAnualCadastro, parametros, "Qtde", Long.class);
    }

    public Long calculaSaldoEmAbertoCadastro(Long entidade, Long exercicio, LocalDate dataFinal, boolean isLancamentoAnualOxy) {
        String sqlCalculaSaldoEmAbertoCadastro = "";
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataFinal", dataFinal);
        sqlCalculaSaldoEmAbertoCadastro = isLancamentoAnualOxy ? "sql/batch/relatoriogerencial/calculasaldoemabertocadastrooxy.sql" : "sql/batch/relatoriogerencial/calculasaldoemabertocadastroaise.sql";
        return (Long)this.executarConsulta(sqlCalculaSaldoEmAbertoCadastro, parametros, "Qtde", Long.class);
    }

    public Long calculaRenunciaCadastro(Long entidade, Long exercicio, LocalDate dataInclusao, boolean isLancamentoAnualOxy) {
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        String sqlCalculaRenunciaCadastro = "";
        sqlCalculaRenunciaCadastro = isLancamentoAnualOxy ? "sql/batch/relatoriogerencial/calcularenunciacadastrooxy.sql" : "sql/batch/relatoriogerencial/calcularenunciacadastroaise.sql";
        return (Long)this.executarConsulta(sqlCalculaRenunciaCadastro, parametros, "Qtde", Long.class);
    }

    public Long calculaRenunciaCadastroValorZerado(Long entidade, Long exercicio, LocalDate dataInclusao, boolean isLancamentoAnualOxy) {
        String sqlCalculaRenunciaCadastroValorZerado = "";
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        sqlCalculaRenunciaCadastroValorZerado = isLancamentoAnualOxy ? "sql/batch/relatoriogerencial/calcularenunciacadastrovalorzeradooxy.sql" : "sql/batch/relatoriogerencial/calcularenunciacadastrovalorzeradoaise.sql";
        return (Long)this.executarConsulta(sqlCalculaRenunciaCadastroValorZerado, parametros, "Qtde", Long.class);
    }

    public Long calculaCancelamentoCadastro(Long entidade, Long exercicio, LocalDate dataInclusao, boolean isLancamentoAnualOxy) {
        String sqlCalculaCancelamentoCadastro = "";
        HashMap<String, LocalDate> parametros = new HashMap<String, LocalDate>(this.mapEntidadeExercicio(entidade, exercicio));
        parametros.put("DataInclusao", dataInclusao);
        sqlCalculaCancelamentoCadastro = isLancamentoAnualOxy ? "sql/batch/relatoriogerencial/calculacancelamentocadastrooxy.sql" : "sql/batch/relatoriogerencial/calculacancelamentocadastroaise.sql";
        return (Long)this.executarConsulta(sqlCalculaCancelamentoCadastro, parametros, "Qtde", Long.class);
    }

    private Map<String, Object> mapEntidadeExercicio(Long entidade, Long exercicio) {
        return Map.of("Entidade", entidade, "Exercicio", exercicio);
    }

    @Generated
    public LancamentoArrecadacaoRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

