/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaocontabil.LoteItemIntegracaoContabilAgrupadoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.LoteItemPagamentoIntegracaoContabilDTO;
import br.com.elotech.tributos.repository.integracaocontabil.LoteItemIntegracaoContabilCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LoteItemIntegracaoContabilRepositoryImpl
implements LoteItemIntegracaoContabilCustomRepository {
    private static final String CONSULTA_LOTE_PAGAMENTO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-lote-pagamento.sql";
    private static final String CONSULTA_LOTE_ESTORNO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-lote-estorno.sql";
    private static final String CONSULTA_LOTE_RESTITUICAO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-lote-restituicao.sql";
    private static final String CONSULTA_LOTE_REABILITACAO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-lote-reabilitacao.sql";
    private static final String CONSULTA_LOTE_ESTORNO_CREDITO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-lote-estorno-credito.sql";
    private static final String CONSULTA_ITENS_AGRUPADOS = "br/com/elotech/tributos/repository/integracaocontabil/consulta-itens-agrupados.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public LoteItemIntegracaoContabilRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<LoteItemPagamentoIntegracaoContabilDTO> findItensLotePagamento(Long entidade, Long exercicio, Long lote) {
        String sql = FileUtils.readResourceAsString((String)CONSULTA_LOTE_PAGAMENTO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade);
        params.addValue("exercicio", (Object)exercicio);
        params.addValue("lote", (Object)lote);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LoteItemPagamentoIntegracaoContabilDTO.class));
    }

    public List<LoteItemIntegracaoContabilAgrupadoDTO> findItensAgrupados(Long idLote) {
        String sql = FileUtils.readResourceAsString((String)CONSULTA_ITENS_AGRUPADOS);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("idLote", (Object)idLote);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LoteItemIntegracaoContabilAgrupadoDTO.class));
    }

    public List<LoteItemPagamentoIntegracaoContabilDTO> findItensEstornoPagamento(LocalDate dataEstorno) {
        String sql = FileUtils.readResourceAsString((String)CONSULTA_LOTE_ESTORNO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("dataParam", (Object)Date.valueOf(dataEstorno));
        params.addValue("exercicio", (Object)dataEstorno.getYear());
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LoteItemPagamentoIntegracaoContabilDTO.class));
    }

    public List<LoteItemPagamentoIntegracaoContabilDTO> findItensRestituicao(LocalDate dataRestituicao) {
        String sql = FileUtils.readResourceAsString((String)CONSULTA_LOTE_RESTITUICAO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("dataParam", (Object)Date.valueOf(dataRestituicao));
        params.addValue("exercicio", (Object)dataRestituicao.getYear());
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LoteItemPagamentoIntegracaoContabilDTO.class));
    }

    public List<LoteItemPagamentoIntegracaoContabilDTO> findItensReabilitacaoPagamento(LocalDate dataReabilitacao) {
        String sql = FileUtils.readResourceAsString((String)CONSULTA_LOTE_REABILITACAO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("dataReabilitacao", (Object)Date.valueOf(dataReabilitacao));
        params.addValue("exercicio", (Object)dataReabilitacao.getYear());
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LoteItemPagamentoIntegracaoContabilDTO.class));
    }

    public List<LoteItemPagamentoIntegracaoContabilDTO> findItensEstornoCredito(LocalDate dataEstorno) {
        String sql = FileUtils.readResourceAsString((String)CONSULTA_LOTE_ESTORNO_CREDITO);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("dataEstorno", (Object)Date.valueOf(dataEstorno));
        params.addValue("exercicio", (Object)dataEstorno.getYear());
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(LoteItemPagamentoIntegracaoContabilDTO.class));
    }
}

