/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.dto.CreditoContribuintePesquisaDTO;
import br.com.elotech.tributos.dto.FiltroCreditoContribuinteDTO;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoDTO;
import br.com.elotech.tributos.repository.CreditoContribuinteCustom;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.transform.Transformers;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CreditoContribuinteRepositoryImpl
implements CreditoContribuinteCustom {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final EntityManager entityManager;

    public CreditoContribuinteRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate, EntityManager entityManager) {
        this.jdbcTemplate = jdbcTemplate;
        this.entityManager = entityManager;
    }

    public Page<CreditoContribuintePesquisaDTO> findCreditos(FiltroCreditoContribuinteDTO filtroCreditoContribuinte, Pageable pageable) {
        String sqlFrom = String.format(" from CreditoContribuinte credito  join credito.contaBancaria contaBancaria where %s ", filtroCreditoContribuinte.buildFiltro());
        String sqlCreditos = String.format(" select credito.id.entidade as entidade, credito.id.exercicio as exercicio, credito.id.creditoContribuinte as creditoContribuinte, credito.lote.id.lote as lote, credito.lote.id.exercicio as exercicioLote,  credito.dataMovimento as dataMovimento,  credito.dataPagamento as dataPagamento,  (select sum(item.valorLancado) from CreditoContribuinteItem item where item.creditoContribuinte.id.creditoContribuinte = credito.id.creditoContribuinte and item.creditoContribuinte.id.entidade = credito.id.entidade and item.creditoContribuinte.id.exercicio = credito.id.exercicio) as valorCredito,  credito.sequenciaArquivo as sequenciaArquivo  %s  order by credito.id.exercicio desc, credito.id.creditoContribuinte desc ", sqlFrom);
        String sqlCount = String.format(" select count(1) %s ", sqlFrom);
        TypedQuery queryCount = this.entityManager.createQuery(sqlCount, Long.class);
        this.setFiltroDatas((Query)queryCount, filtroCreditoContribuinte);
        Long quantidadeTotal = (Long)queryCount.getSingleResult();
        Query query = this.entityManager.createQuery(sqlCreditos);
        this.setFiltroDatas(query, filtroCreditoContribuinte);
        List result = ((org.hibernate.query.Query)query.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).unwrap(org.hibernate.query.Query.class)).setResultTransformer(Transformers.aliasToBean(CreditoContribuintePesquisaDTO.class)).getResultList();
        return new PageImpl(result, pageable, quantidadeTotal.longValue());
    }

    public List<DevolucaoCreditoDTO> findDevolucoes(Long entidade, Long exercicio, Long credito) {
        String sql = "select tdc.iddevolucaocredito as id,       tdci.valordevolucao as valor,        tdc.data,        tdc.usuario,        tmd.descricao as motivodeducao,        case tdc.situacao          when 'D' then 'Devolvido'          when 'C' then 'Cancelado'          when 'I' then 'Inutilizado'          when 'A' then 'Aguardando'        end as situacao   from tribdevolucaocredito tdc   join tribdevolucaocreditoitem tdci on tdci.iddevolucaocredito = tdc.iddevolucaocredito   left join tribmotivodesconto tmd on tmd.motivodesconto = tdc.motivodesconto  where tdci.entidade = :entidade    and tdci.exercicio = :exercicio    and tdci.creditocontribuinte = :credito  order by tdc.data desc";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exercicio", (Object)exercicio);
        parameters.addValue("credito", (Object)credito);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DevolucaoCreditoDTO.class));
    }

    private void setFiltroDatas(Query query, FiltroCreditoContribuinteDTO filtroCreditoContribuinte) {
        Map filtros = filtroCreditoContribuinte.getFiltroDatas();
        filtros.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
    }
}

