/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.tributos.domain.tarefaassincrona.SituacaoTarefaAssincrona;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TarefaRepository {
    private static final String HAS_RUNNING_EXECUTION = "SELECT CASE WHEN SUM(total) > 0 THEN 1 ELSE 0 END AS hasexecution FROM (SELECT COUNT(1) total FROM trib_job_execution WHERE start_time IS NOT NULL AND end_time IS NULL UNION ALL SELECT COUNT(1) total FROM tarefaassincronaexecucao WHERE situacao = :situacaotarefaassincrona) TABLETOTAL";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public TarefaRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Boolean hasRunningExecution() {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("situacaotarefaassincrona", (Object)SituacaoTarefaAssincrona.PROCESSANDO.getValue());
        return (Boolean)this.jdbcTemplate.queryForObject(HAS_RUNNING_EXECUTION, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getBoolean("hasexecution"));
    }
}

