/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.ConsultaDebitoTipoAgrupamento;
import br.com.elotech.tributos.dto.ConsultaDebitoItemDTO;
import br.com.elotech.tributos.dto.ConsultaDebitoValoresDTO;
import br.com.elotech.tributos.repository.ConsultaDebitoCustomRepository;
import br.com.elotech.tributos.repository.ConsultaDebitoRepositoryImpl;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ConsultaDebitoRepositoryImpl
implements ConsultaDebitoCustomRepository {
    private static final String SQL_CONSULTA_DEBITO = "br/com/elotech/tributos/repository/find-consulta-debito.sql";
    private static final String SQL_CONSULTA_DEBITO_DETALHADO = "br/com/elotech/tributos/repository/find-consulta-debito-detalhado.sql";
    private static final String ID_CONSULTA = "idConsulta";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public ConsultaDebitoRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public ConsultaDebitoValoresDTO getResumo(Long idConsulta) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(ID_CONSULTA, (Object)idConsulta);
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_CONSULTA_DEBITO), "", "", "", "");
        return (ConsultaDebitoValoresDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaDebitoValoresDTO.class));
    }

    public Page<ConsultaDebitoItemDTO> findDebitos(Long idConsulta, String tipoAgrupamento, Pageable pageable) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(ID_CONSULTA, (Object)idConsulta);
        String query = this.isAgrupamentoDetalhado(tipoAgrupamento) ? FileUtils.readResourceAsString((String)SQL_CONSULTA_DEBITO_DETALHADO) : String.format(FileUtils.readResourceAsString((String)SQL_CONSULTA_DEBITO), this.getSelectFields(tipoAgrupamento), this.getJoinSelectFields(tipoAgrupamento), this.getGroupByFields(tipoAgrupamento), this.getOrderByFields(tipoAgrupamento));
        String queryCount = String.format("select count(*) as total from (%s) queryCount", query);
        Long sqlCount = (Long)this.namedParameterJdbcTemplate.queryForObject(queryCount, (SqlParameterSource)parameterSource, (rs, rowNum) -> rs.getLong("total"));
        String pagedQuery = SqlUtils.withPagination((String)query, (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        List pagedContent = this.namedParameterJdbcTemplate.query(pagedQuery, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaDebitoItemDTO.class));
        return new PageImpl(pagedContent, pageable, sqlCount.longValue());
    }

    private boolean isAgrupamentoDetalhado(String tipoAgrupamento) {
        return ConsultaDebitoTipoAgrupamento.DETALHADO.equals((Object)ConsultaDebitoTipoAgrupamento.fromValue((String)tipoAgrupamento));
    }

    private String getSelectFields(String tipoAgrupamento) {
        String selectDadosPessoaContatoPessoa = "pessoa.nome,\npessoa.cnpj_cpf as cpfCnpj,\ncp.telefoneresidencial,\ncp.telefonecomercial,\ncp.telefonefax,\ncp.telefonecelular,\ncp.email,\n";
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$ConsultaDebitoTipoAgrupamento[ConsultaDebitoTipoAgrupamento.fromValue((String)tipoAgrupamento).ordinal()]) {
            case 1: {
                return " consultadebitoitem.tipocadastro, \nconsultadebitoitem.cadastrogeral, \nconsultadebitoitem.pessoa, \nCASE \n WHEN consultadebitoitem.tipocadastro = 1 THEN 'IMOBILI\u00c1RIO' \n WHEN consultadebitoitem.tipocadastro = 2 THEN 'MOBILI\u00c1RIO' \n WHEN consultadebitoitem.tipocadastro = 3 THEN 'RURAL' \n WHEN consultadebitoitem.tipocadastro = 4 THEN 'CEMIT\u00c9RIO' \n WHEN consultadebitoitem.tipocadastro = 9 THEN 'AVULSO'\nELSE '-'\nEND as descricaoTipoCadastro,\n" + selectDadosPessoaContatoPessoa;
            }
            case 2: {
                return "consultadebitoitem.pessoa, \n" + selectDadosPessoaContatoPessoa;
            }
            case 3: {
                return "consultadebitoitem.exercicio, \nconsultadebitoitem.divida, \ndivida.descricao as descricaoDivida, ";
            }
            case 4: {
                return "consultadebitoitem.tipotributo, \ntipoTributo.descricao as descricaoTipoTributo, \nconsultadebitoitem.situacaolegal, \n CASE \n WHEN consultadebitoitem.situacaolegal = 0 THEN 'No Exerc\u00edcio' \n WHEN consultadebitoitem.situacaolegal = 1 THEN 'Em D\u00edvida Ativa' \n WHEN consultadebitoitem.situacaolegal = 2 THEN 'Em Ju\u00edzo' \n ELSE '-'\n END as descricaoSituacaoLegal,";
            }
            case 5: {
                return "consultadebitoitem.pessoa, \n" + selectDadosPessoaContatoPessoa;
            }
        }
        return "";
    }

    private String getGroupByFields(String tipoAgrupamento) {
        String agrupamentoPessoa = "pessoa.nome,\npessoa.cnpj_cpf,\ncp.telefoneresidencial,\ncp.telefonecomercial,\ncp.telefonefax,\ncp.telefonecelular,\ncp.email\n";
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$ConsultaDebitoTipoAgrupamento[ConsultaDebitoTipoAgrupamento.fromValue((String)tipoAgrupamento).ordinal()]) {
            case 1: {
                return "GROUP BY  consultadebitoitem.tipocadastro, \nconsultadebitoitem.cadastrogeral, \nconsultadebitoitem.pessoa, \n" + agrupamentoPessoa;
            }
            case 2: {
                return "GROUP BY consultadebitoitem.pessoa, \n" + agrupamentoPessoa;
            }
            case 3: {
                return "GROUP BY consultadebitoitem.exercicio, \nconsultadebitoitem.divida, \ndivida.descricao ";
            }
            case 4: {
                return "GROUP BY consultadebitoitem.situacaolegal, \ntipoTributo.descricao, \nconsultadebitoitem.tipotributo ";
            }
            case 5: {
                return "GROUP BY consultadebitoitem.pessoa, \n" + agrupamentoPessoa;
            }
        }
        return "";
    }

    private String getJoinSelectFields(String tipoAgrupamento) {
        String joinContatoPessoa = "LEFT JOIN contatopessoa cp \n ON cp.sequencia = pessoa.sequenciacontato \n AND cp.pessoa  = pessoa.pessoa \n";
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$ConsultaDebitoTipoAgrupamento[ConsultaDebitoTipoAgrupamento.fromValue((String)tipoAgrupamento).ordinal()]) {
            case 1: {
                return joinContatoPessoa;
            }
            case 2: {
                return joinContatoPessoa;
            }
            case 5: {
                return joinContatoPessoa;
            }
        }
        return "";
    }

    private String getOrderByFields(String tipoAgrupamento) {
        return this.getGroupByFields(tipoAgrupamento).replace("GROUP BY", "ORDER BY");
    }

    public List<ConsultaDebitoItemDTO> getDebitosPorAgrupamento(Long idConsulta, ConsultaDebitoTipoAgrupamento tipoAgrupamento) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(ID_CONSULTA, (Object)idConsulta);
        String query = this.isAgrupamentoDetalhado(tipoAgrupamento.getTipoAgrupamento()) ? FileUtils.readResourceAsString((String)SQL_CONSULTA_DEBITO_DETALHADO) : String.format(FileUtils.readResourceAsString((String)SQL_CONSULTA_DEBITO), this.getSelectFields(tipoAgrupamento.getTipoAgrupamento()), this.getJoinSelectFields(tipoAgrupamento.getTipoAgrupamento()), this.getGroupByFields(tipoAgrupamento.getTipoAgrupamento()), this.getOrderByFields(tipoAgrupamento.getTipoAgrupamento()));
        List consultaDebitos = this.namedParameterJdbcTemplate.query(query, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaDebitoItemDTO.class));
        return consultaDebitos;
    }
}

