/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.repository.BoletoRepositoryCustom;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface BoletoRepository
extends CrudRepository<Bloqueto, Long>,
BoletoRepositoryCustom {
    public Bloqueto findByEntidadeAndExercicioBloquetoAndBloqueto(@Param(value="entidade") Long var1, @Param(value="exercicioBloqueto") Long var2, @Param(value="bloqueto") Long var3);

    @Query(value="select bloq from Bloqueto bloq where bloq.id.entidade = :entidade and bloq.id.exercicioBloqueto = :exercicioBloqueto and bloq.id.bloqueto = :bloqueto")
    public Bloqueto findByBloqueto(@Param(value="entidade") Long var1, @Param(value="exercicioBloqueto") Long var2, @Param(value="bloqueto") Long var3);

    public Bloqueto findByCodigoValidacao(String var1);

    @Query(value=" select formasPagamento.modeloBoleto  from Divida divida  inner join divida.formasPagamento formasPagamento  where divida.entidade = :entidade  and   divida.exercicio = :exercicio  and   divida.divida = :divida  and   formasPagamento.formaPagamento.id = :formaPagamento ")
    public Optional<ModeloBoleto> findModeloBoleto(@Param(value="entidade") Long var1, @Param(value="exercicio") Long var2, @Param(value="divida") Long var3, @Param(value="formaPagamento") Long var4);

    @Query(value="select count(a.idkey)  from TribBloqueto a where a.dataEmissao = :data", nativeQuery=true)
    public Long getQuantidadeBoletosGerados(@Param(value="data") LocalDate var1);

    public Optional<Bloqueto> findByNossoNumero(String var1);

    public Optional<Bloqueto> findByBloquetoAndExercicioBloqueto(Long var1, Long var2);

    @Query(value="select bloq from Bloqueto bloq  join bloq.cadastroGeral cg  where (bloq.codigoBarras = :termo or concat(bloq.campo1, bloq.campo2, bloq.campo3, bloq.campo4, coalesce(bloq.campo5,'')) = :termo)  and cg.exclusaoLogica = false ")
    public Optional<Bloqueto> findByCodigoBarrasOuLinhaDigitavel(@Param(value="termo") String var1);

    @Query(value="select bloq from Bloqueto bloq  join bloq.cadastroGeral cg  where (bloq.codigoBarras = :termo or concat(bloq.campo1, bloq.campo2, bloq.campo3, bloq.campo4, coalesce(bloq.campo5,'')) = :termo)  and bloq.entidade = :entidade  and cg.cadastroGeral = :cadastroGeral  and cg.tipoCadastro = :tipoCadastro  and cg.exclusaoLogica = false ")
    public Optional<Bloqueto> findByCodigoBarrasOuLinhaDigitavelComMesmoCadastroPagamento(@Param(value="termo") String var1, @Param(value="entidade") Long var2, @Param(value="cadastroGeral") Long var3, @Param(value="tipoCadastro") TipoCadastro var4);

    public Optional<Bloqueto> findByTxidPix(String var1);

    public Optional<Bloqueto> findByCodigoBarras(String var1);

    @Query(value="select tb.* from tribcnab750arquivodetalhe ad\n    left join tribarquivoremessadetalhe ard on ad.identificadortxid = ard.identificadortxid\n    left join tribbloquetocalc tbc on ard.bloquetocalc = tbc.bloqueto and ard.exerciciobloquetocalc = tbc.exerciciobloqueto and ard.entidade = tbc.entidade\n    left join tribbloqueto tb on tbc.bloqueto = tb.bloqueto and tbc.exerciciobloqueto = tb.exerciciobloqueto and tbc.entidade = tb.entidade\n   where tb.pago = 'N' and ad.codigoerro is null and tb.idkey = :idBloqueto ", nativeQuery=true)
    public Bloqueto findBloquetoNaoPagoAndcnab750arquivodetalhe(@Param(value="idBloqueto") Long var1);

    @Query(value="select distinct bloq from Bloqueto bloq left join bloq.debitos dbts where not exists ( select bd from BoletoDebito bd where bd.id.entidade = bloq.entidade and bd.id.exercicioBoleto = bloq.exercicioBloqueto and bd.id.boleto = bloq.bloqueto and bd.id.debitoParcelaTributo.id not in :ids ) and dbts.id.debitoParcelaTributo.id in :ids and bloq.pago = false and bloq.tipoBloqueto in ('P', 'A') and bloq.dataVencimento >= :dataReferencia")
    public List<Bloqueto> findByListIdDebitoParcelaReceitaAndNaoVencido(@Param(value="ids") List<Long> var1, @Param(value="dataReferencia") LocalDate var2);

    @Query(value="select distinct tb.idKey from tribbloqueto tb left join tribbloquetodebito tbd on tbd.entidade  = tb.entidade                                  and tbd.exerciciobloqueto  = tb.exerciciobloqueto                                  and tbd.bloqueto  = tb.bloqueto left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tbd.iddebitoparcelareceita left join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade                                 and tdp.exercicio = tdpr.exercicio                                 and tdp.tipocadastro = tdpr.tipocadastro                                 and tdp.cadastrogeral  = tdpr.cadastrogeral                                 and tdp.guiarecolhimento = tdpr.guiarecolhimento                                 and tdp.subdivida = tdpr.subdivida                                 and tdp.parcela = tdpr.parcela left join tribdebito td on td.entidade = tdp.entidade                         and td.exercicio = tdp.exercicio                         and td.tipocadastro = tdp.tipocadastro                         and td.cadastrogeral  = tdp.cadastrogeral                         and td.guiarecolhimento = tdp.guiarecolhimento                         and td.subdivida = tdp.subdivida join tribparcelamentodebito tpd on tpd.iddebito = td.iddebito where tpd.idparcelamento  = :idParcelamento and tb.pago  = 'N'", nativeQuery=true)
    public List<Long> findByIdParcelamento(@Param(value="idParcelamento") Long var1);
}

