/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.sicredi;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ContatoPessoa;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoDesconto;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoEspecieTitulo;
import br.com.elotech.tributos.domain.cnab240.CNAB240CodigoJuros;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.EmissaoBoletoSicrediDTO;
import br.com.elotech.tributos.util.EmailValidator;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmissaoBoletoSicrediDTO {
    private static String TIPO_VALOR = "A";
    private static String TIPO_PERCENTUAL = "B";
    public static Long TIPO_DESCONTO_VALOR_FIXO = 1L;
    public static Long TIPO_DESCONTO_PERCENTUAL = 2L;
    public static Long TIPO_JUROS_VALOR_FIXO = 1L;
    public static Long TIPO_JUROS_PERCENTUAL = 2L;
    public static Long TIPO_MULTA_VALOR_FIXO = 1L;
    public static Long TIPO_MULTA_PERCENTUAL = 2L;
    private static final int QUANTIDADE_MAXIMA_CARACTERES_EMAIL_SICREDI = 40;
    private String agencia;
    private String posto;
    private String cedente;
    private String nossoNumero;
    private String codigoPagador;
    private String tipoPessoa;
    private String cpfCnpj;
    private String nome;
    private String endereco;
    private String cidade;
    private String uf;
    private String cep;
    private String telefone;
    private String email;
    private String especieDocumento;
    private String codigoSacadorAvalista;
    private String seuNumero;
    private String dataVencimento;
    private BigDecimal valor;
    private String tipoDesconto;
    private BigDecimal valorDesconto1;
    private String dataDesconto1;
    private BigDecimal valorDesconto2;
    private String dataDesconto2;
    private BigDecimal valorDesconto3;
    private String dataDesconto3;
    private String tipoJuros;
    private BigDecimal juros;
    private BigDecimal multas;
    private BigDecimal descontoAntecipado;
    private String informativo;
    private String mensagem;
    private String codigoMensagem;

    public static EmissaoBoletoSicrediDTO from(Bloqueto boleto, ParametroCNAB240 parametrosCNAB240Sicredi) {
        Convenio convenio = boleto.getModeloBloqueto().getConvenio();
        Pessoa pessoa = boleto.getPessoa();
        EnderecoPessoa endereco = pessoa.getEnderecoPrincipal();
        String email = Optional.ofNullable(pessoa.getContatoPrincipal()).map(ContatoPessoa::getEmail).filter(EmailValidator::isEmailValido).orElse(null);
        EmissaoBoletoSicrediDTO dto = new EmissaoBoletoSicrediDTO();
        dto.setAgencia(StringUtils.leftPad((String)convenio.getContaBancaria().getAgencia().getAgencia(), (int)4, (String)"0"));
        dto.setPosto(convenio.getCodigoPosto());
        dto.setCedente(convenio.getCodigoCedente());
        dto.setCodigoPagador(null);
        dto.setNossoNumero(boleto.getNossoNumero());
        dto.setTipoPessoa(pessoa.getTipoPessoa());
        dto.setCpfCnpj(pessoa.getCnpjCpfSemMascara());
        dto.setNome(StringUtils.substring((String)pessoa.getNome(), (int)0, (int)40));
        if (Objects.nonNull(endereco)) {
            dto.setEndereco(EmissaoBoletoSicrediDTO.loadEndereco((EnderecoPessoa)endereco));
            dto.setCep(EmissaoBoletoSicrediDTO.loadCep((EnderecoPessoa)endereco));
            dto.setCidade(StringUtils.substring((String)endereco.getCidade().getDescricao(), (int)0, (int)25));
            dto.setUf(endereco.getCidade().getUnidadeFederacao());
        }
        dto.setTelefone(EmissaoBoletoSicrediDTO.loadTelefone((Pessoa)pessoa, (Entidade)boleto.getModeloBloqueto().getConvenio().getEntidadeRegistro()));
        if (StringUtils.isNotEmpty((String)email) && email.length() <= 40) {
            dto.setEmail(email);
        }
        dto.setCodigoSacadorAvalista(null);
        dto.setSeuNumero(boleto.getPessoa().getId().toString());
        dto.setDataVencimento(boleto.getDataVencimento());
        dto.setValor(boleto.getValorBloqueto());
        if (Objects.nonNull(parametrosCNAB240Sicredi)) {
            dto.setTipoDesconto(parametrosCNAB240Sicredi.getCodigoDesconto());
            if (Objects.nonNull(parametrosCNAB240Sicredi.getCodigoDesconto()) && (TIPO_DESCONTO_PERCENTUAL.equals(parametrosCNAB240Sicredi.getCodigoDesconto().getCodigo()) || TIPO_DESCONTO_VALOR_FIXO.equals(parametrosCNAB240Sicredi.getCodigoDesconto().getCodigo()))) {
                dto.setValorDesconto1(parametrosCNAB240Sicredi.getValorPercentualDesconto());
                dto.setDataDesconto1(boleto.getDataVencimento());
            }
            dto.setEspecieDocumento((String)Optional.ofNullable(parametrosCNAB240Sicredi.getIdEspecieTitulo()).map(CNAB240CodigoEspecieTitulo::getIdEspecie).orElse(null));
            dto.setTipoJuros((Long)Optional.ofNullable(parametrosCNAB240Sicredi.getCodigoJuros()).map(CNAB240CodigoJuros::getId).orElse(null));
            if (Objects.nonNull(parametrosCNAB240Sicredi.getCodigoJuros()) && (TIPO_JUROS_VALOR_FIXO.equals(parametrosCNAB240Sicredi.getCodigoJuros().getId()) || TIPO_JUROS_PERCENTUAL.equals(parametrosCNAB240Sicredi.getCodigoJuros().getId()))) {
                dto.setJuros(parametrosCNAB240Sicredi.getValorJurosDiaTaxa());
            }
            if (Objects.nonNull(parametrosCNAB240Sicredi.getCodigoMulta()) && (TIPO_MULTA_VALOR_FIXO.equals(parametrosCNAB240Sicredi.getCodigoMulta().getId()) || TIPO_MULTA_PERCENTUAL.equals(parametrosCNAB240Sicredi.getCodigoMulta().getId()))) {
                dto.setMultas(parametrosCNAB240Sicredi.getValorPercentualMulta());
            } else {
                dto.setMultas(BigDecimal.ZERO);
            }
        }
        dto.setDescontoAntecipado(null);
        dto.setInformativo(null);
        dto.setMensagem(null);
        dto.setCodigoMensagem(null);
        return dto;
    }

    public static String loadTelefone(Pessoa pessoa, Entidade entidade) {
        return Optional.ofNullable(pessoa.getContatoPrincipal()).map(contato -> Optional.ofNullable(contato.getTelefoneCelular()).filter(StringUtils::isNotBlank).or(() -> Optional.ofNullable(contato.getTelefoneResidencial()).filter(StringUtils::isNotBlank)).orElse(contato.getTelefoneComercial())).filter(StringUtils::isNotBlank).orElse(Optional.ofNullable(entidade).map(Entidade::getTelefone).orElse(null));
    }

    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
    }

    public void setDataDesconto1(LocalDate dataDesconto) {
        this.dataDesconto1 = dataDesconto.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
    }

    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        switch (1.$SwitchMap$br$com$elotech$core$enumerable$common$TipoPessoa[tipoPessoa.ordinal()]) {
            case 1: {
                this.tipoPessoa = "1";
                break;
            }
            case 2: {
                this.tipoPessoa = "2";
                break;
            }
            default: {
                this.tipoPessoa = null;
            }
        }
    }

    public void setTipoDesconto(CNAB240CodigoDesconto codigoDesconto) {
        if (Objects.nonNull(codigoDesconto) && TIPO_DESCONTO_PERCENTUAL.equals(codigoDesconto.getCodigo())) {
            this.tipoDesconto = TIPO_PERCENTUAL;
            return;
        }
        this.tipoDesconto = TIPO_VALOR;
    }

    public void setTipoJuros(Long tipo) {
        if (Objects.nonNull(tipo) && TIPO_JUROS_PERCENTUAL.equals(tipo)) {
            this.tipoJuros = TIPO_PERCENTUAL;
            return;
        }
        this.tipoJuros = TIPO_VALOR;
    }

    public void setTelefone(String telefone) {
        if (Objects.isNull(telefone)) {
            this.telefone = null;
            return;
        }
        this.telefone = telefone.replaceAll("[^0-9]", "");
    }

    public static String loadEndereco(EnderecoPessoa endereco) {
        return StringUtils.substring((String)StringUtils.normalizeSpace((String)String.format("%s %s %s %s", Optional.ofNullable(endereco.getLogradouro()).map(Logradouro::getTipoLogradouroDescricao).orElse(""), Optional.ofNullable(endereco.getLogradouro()).map(Logradouro::getDescricao).orElse(""), Optional.ofNullable(endereco.getNumero()).orElse(""), Optional.ofNullable(endereco.getComplemento()).orElse(""))), (int)0, (int)40);
    }

    public static String loadCep(EnderecoPessoa endereco) {
        return Optional.ofNullable(endereco.getCep()).map(cep -> org.apache.commons.lang3.StringUtils.leftPad((String)cep.toString(), (int)8, (String)"0")).orElse(null);
    }

    @Generated
    public EmissaoBoletoSicrediDTO() {
    }

    @Generated
    public String getAgencia() {
        return this.agencia;
    }

    @Generated
    public String getPosto() {
        return this.posto;
    }

    @Generated
    public String getCedente() {
        return this.cedente;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getCodigoPagador() {
        return this.codigoPagador;
    }

    @Generated
    public String getTipoPessoa() {
        return this.tipoPessoa;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getEndereco() {
        return this.endereco;
    }

    @Generated
    public String getCidade() {
        return this.cidade;
    }

    @Generated
    public String getUf() {
        return this.uf;
    }

    @Generated
    public String getCep() {
        return this.cep;
    }

    @Generated
    public String getTelefone() {
        return this.telefone;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getEspecieDocumento() {
        return this.especieDocumento;
    }

    @Generated
    public String getCodigoSacadorAvalista() {
        return this.codigoSacadorAvalista;
    }

    @Generated
    public String getSeuNumero() {
        return this.seuNumero;
    }

    @Generated
    public String getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public String getTipoDesconto() {
        return this.tipoDesconto;
    }

    @Generated
    public BigDecimal getValorDesconto1() {
        return this.valorDesconto1;
    }

    @Generated
    public String getDataDesconto1() {
        return this.dataDesconto1;
    }

    @Generated
    public BigDecimal getValorDesconto2() {
        return this.valorDesconto2;
    }

    @Generated
    public String getDataDesconto2() {
        return this.dataDesconto2;
    }

    @Generated
    public BigDecimal getValorDesconto3() {
        return this.valorDesconto3;
    }

    @Generated
    public String getDataDesconto3() {
        return this.dataDesconto3;
    }

    @Generated
    public String getTipoJuros() {
        return this.tipoJuros;
    }

    @Generated
    public BigDecimal getJuros() {
        return this.juros;
    }

    @Generated
    public BigDecimal getMultas() {
        return this.multas;
    }

    @Generated
    public BigDecimal getDescontoAntecipado() {
        return this.descontoAntecipado;
    }

    @Generated
    public String getInformativo() {
        return this.informativo;
    }

    @Generated
    public String getMensagem() {
        return this.mensagem;
    }

    @Generated
    public String getCodigoMensagem() {
        return this.codigoMensagem;
    }

    @Generated
    public void setAgencia(String agencia) {
        this.agencia = agencia;
    }

    @Generated
    public void setPosto(String posto) {
        this.posto = posto;
    }

    @Generated
    public void setCedente(String cedente) {
        this.cedente = cedente;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setCodigoPagador(String codigoPagador) {
        this.codigoPagador = codigoPagador;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    @Generated
    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setUf(String uf) {
        this.uf = uf;
    }

    @Generated
    public void setCep(String cep) {
        this.cep = cep;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setEspecieDocumento(String especieDocumento) {
        this.especieDocumento = especieDocumento;
    }

    @Generated
    public void setCodigoSacadorAvalista(String codigoSacadorAvalista) {
        this.codigoSacadorAvalista = codigoSacadorAvalista;
    }

    @Generated
    public void setSeuNumero(String seuNumero) {
        this.seuNumero = seuNumero;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorDesconto1(BigDecimal valorDesconto1) {
        this.valorDesconto1 = valorDesconto1;
    }

    @Generated
    public void setValorDesconto2(BigDecimal valorDesconto2) {
        this.valorDesconto2 = valorDesconto2;
    }

    @Generated
    public void setDataDesconto2(String dataDesconto2) {
        this.dataDesconto2 = dataDesconto2;
    }

    @Generated
    public void setValorDesconto3(BigDecimal valorDesconto3) {
        this.valorDesconto3 = valorDesconto3;
    }

    @Generated
    public void setDataDesconto3(String dataDesconto3) {
        this.dataDesconto3 = dataDesconto3;
    }

    @Generated
    public void setJuros(BigDecimal juros) {
        this.juros = juros;
    }

    @Generated
    public void setMultas(BigDecimal multas) {
        this.multas = multas;
    }

    @Generated
    public void setDescontoAntecipado(BigDecimal descontoAntecipado) {
        this.descontoAntecipado = descontoAntecipado;
    }

    @Generated
    public void setInformativo(String informativo) {
        this.informativo = informativo;
    }

    @Generated
    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    @Generated
    public void setCodigoMensagem(String codigoMensagem) {
        this.codigoMensagem = codigoMensagem;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmissaoBoletoSicrediDTO)) {
            return false;
        }
        EmissaoBoletoSicrediDTO other = (EmissaoBoletoSicrediDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$agencia = this.getAgencia();
        String other$agencia = other.getAgencia();
        if (this$agencia == null ? other$agencia != null : !this$agencia.equals(other$agencia)) {
            return false;
        }
        String this$posto = this.getPosto();
        String other$posto = other.getPosto();
        if (this$posto == null ? other$posto != null : !this$posto.equals(other$posto)) {
            return false;
        }
        String this$cedente = this.getCedente();
        String other$cedente = other.getCedente();
        if (this$cedente == null ? other$cedente != null : !this$cedente.equals(other$cedente)) {
            return false;
        }
        String this$nossoNumero = this.getNossoNumero();
        String other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !this$nossoNumero.equals(other$nossoNumero)) {
            return false;
        }
        String this$codigoPagador = this.getCodigoPagador();
        String other$codigoPagador = other.getCodigoPagador();
        if (this$codigoPagador == null ? other$codigoPagador != null : !this$codigoPagador.equals(other$codigoPagador)) {
            return false;
        }
        String this$tipoPessoa = this.getTipoPessoa();
        String other$tipoPessoa = other.getTipoPessoa();
        if (this$tipoPessoa == null ? other$tipoPessoa != null : !this$tipoPessoa.equals(other$tipoPessoa)) {
            return false;
        }
        String this$cpfCnpj = this.getCpfCnpj();
        String other$cpfCnpj = other.getCpfCnpj();
        if (this$cpfCnpj == null ? other$cpfCnpj != null : !this$cpfCnpj.equals(other$cpfCnpj)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$endereco = this.getEndereco();
        String other$endereco = other.getEndereco();
        if (this$endereco == null ? other$endereco != null : !this$endereco.equals(other$endereco)) {
            return false;
        }
        String this$cidade = this.getCidade();
        String other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        String this$uf = this.getUf();
        String other$uf = other.getUf();
        if (this$uf == null ? other$uf != null : !this$uf.equals(other$uf)) {
            return false;
        }
        String this$cep = this.getCep();
        String other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !this$cep.equals(other$cep)) {
            return false;
        }
        String this$telefone = this.getTelefone();
        String other$telefone = other.getTelefone();
        if (this$telefone == null ? other$telefone != null : !this$telefone.equals(other$telefone)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$especieDocumento = this.getEspecieDocumento();
        String other$especieDocumento = other.getEspecieDocumento();
        if (this$especieDocumento == null ? other$especieDocumento != null : !this$especieDocumento.equals(other$especieDocumento)) {
            return false;
        }
        String this$codigoSacadorAvalista = this.getCodigoSacadorAvalista();
        String other$codigoSacadorAvalista = other.getCodigoSacadorAvalista();
        if (this$codigoSacadorAvalista == null ? other$codigoSacadorAvalista != null : !this$codigoSacadorAvalista.equals(other$codigoSacadorAvalista)) {
            return false;
        }
        String this$seuNumero = this.getSeuNumero();
        String other$seuNumero = other.getSeuNumero();
        if (this$seuNumero == null ? other$seuNumero != null : !this$seuNumero.equals(other$seuNumero)) {
            return false;
        }
        String this$dataVencimento = this.getDataVencimento();
        String other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !this$dataVencimento.equals(other$dataVencimento)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        String this$tipoDesconto = this.getTipoDesconto();
        String other$tipoDesconto = other.getTipoDesconto();
        if (this$tipoDesconto == null ? other$tipoDesconto != null : !this$tipoDesconto.equals(other$tipoDesconto)) {
            return false;
        }
        BigDecimal this$valorDesconto1 = this.getValorDesconto1();
        BigDecimal other$valorDesconto1 = other.getValorDesconto1();
        if (this$valorDesconto1 == null ? other$valorDesconto1 != null : !((Object)this$valorDesconto1).equals(other$valorDesconto1)) {
            return false;
        }
        String this$dataDesconto1 = this.getDataDesconto1();
        String other$dataDesconto1 = other.getDataDesconto1();
        if (this$dataDesconto1 == null ? other$dataDesconto1 != null : !this$dataDesconto1.equals(other$dataDesconto1)) {
            return false;
        }
        BigDecimal this$valorDesconto2 = this.getValorDesconto2();
        BigDecimal other$valorDesconto2 = other.getValorDesconto2();
        if (this$valorDesconto2 == null ? other$valorDesconto2 != null : !((Object)this$valorDesconto2).equals(other$valorDesconto2)) {
            return false;
        }
        String this$dataDesconto2 = this.getDataDesconto2();
        String other$dataDesconto2 = other.getDataDesconto2();
        if (this$dataDesconto2 == null ? other$dataDesconto2 != null : !this$dataDesconto2.equals(other$dataDesconto2)) {
            return false;
        }
        BigDecimal this$valorDesconto3 = this.getValorDesconto3();
        BigDecimal other$valorDesconto3 = other.getValorDesconto3();
        if (this$valorDesconto3 == null ? other$valorDesconto3 != null : !((Object)this$valorDesconto3).equals(other$valorDesconto3)) {
            return false;
        }
        String this$dataDesconto3 = this.getDataDesconto3();
        String other$dataDesconto3 = other.getDataDesconto3();
        if (this$dataDesconto3 == null ? other$dataDesconto3 != null : !this$dataDesconto3.equals(other$dataDesconto3)) {
            return false;
        }
        String this$tipoJuros = this.getTipoJuros();
        String other$tipoJuros = other.getTipoJuros();
        if (this$tipoJuros == null ? other$tipoJuros != null : !this$tipoJuros.equals(other$tipoJuros)) {
            return false;
        }
        BigDecimal this$juros = this.getJuros();
        BigDecimal other$juros = other.getJuros();
        if (this$juros == null ? other$juros != null : !((Object)this$juros).equals(other$juros)) {
            return false;
        }
        BigDecimal this$multas = this.getMultas();
        BigDecimal other$multas = other.getMultas();
        if (this$multas == null ? other$multas != null : !((Object)this$multas).equals(other$multas)) {
            return false;
        }
        BigDecimal this$descontoAntecipado = this.getDescontoAntecipado();
        BigDecimal other$descontoAntecipado = other.getDescontoAntecipado();
        if (this$descontoAntecipado == null ? other$descontoAntecipado != null : !((Object)this$descontoAntecipado).equals(other$descontoAntecipado)) {
            return false;
        }
        String this$informativo = this.getInformativo();
        String other$informativo = other.getInformativo();
        if (this$informativo == null ? other$informativo != null : !this$informativo.equals(other$informativo)) {
            return false;
        }
        String this$mensagem = this.getMensagem();
        String other$mensagem = other.getMensagem();
        if (this$mensagem == null ? other$mensagem != null : !this$mensagem.equals(other$mensagem)) {
            return false;
        }
        String this$codigoMensagem = this.getCodigoMensagem();
        String other$codigoMensagem = other.getCodigoMensagem();
        return !(this$codigoMensagem == null ? other$codigoMensagem != null : !this$codigoMensagem.equals(other$codigoMensagem));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmissaoBoletoSicrediDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $agencia = this.getAgencia();
        result = result * 59 + ($agencia == null ? 43 : $agencia.hashCode());
        String $posto = this.getPosto();
        result = result * 59 + ($posto == null ? 43 : $posto.hashCode());
        String $cedente = this.getCedente();
        result = result * 59 + ($cedente == null ? 43 : $cedente.hashCode());
        String $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : $nossoNumero.hashCode());
        String $codigoPagador = this.getCodigoPagador();
        result = result * 59 + ($codigoPagador == null ? 43 : $codigoPagador.hashCode());
        String $tipoPessoa = this.getTipoPessoa();
        result = result * 59 + ($tipoPessoa == null ? 43 : $tipoPessoa.hashCode());
        String $cpfCnpj = this.getCpfCnpj();
        result = result * 59 + ($cpfCnpj == null ? 43 : $cpfCnpj.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $endereco = this.getEndereco();
        result = result * 59 + ($endereco == null ? 43 : $endereco.hashCode());
        String $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        String $uf = this.getUf();
        result = result * 59 + ($uf == null ? 43 : $uf.hashCode());
        String $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : $cep.hashCode());
        String $telefone = this.getTelefone();
        result = result * 59 + ($telefone == null ? 43 : $telefone.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $especieDocumento = this.getEspecieDocumento();
        result = result * 59 + ($especieDocumento == null ? 43 : $especieDocumento.hashCode());
        String $codigoSacadorAvalista = this.getCodigoSacadorAvalista();
        result = result * 59 + ($codigoSacadorAvalista == null ? 43 : $codigoSacadorAvalista.hashCode());
        String $seuNumero = this.getSeuNumero();
        result = result * 59 + ($seuNumero == null ? 43 : $seuNumero.hashCode());
        String $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : $dataVencimento.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        String $tipoDesconto = this.getTipoDesconto();
        result = result * 59 + ($tipoDesconto == null ? 43 : $tipoDesconto.hashCode());
        BigDecimal $valorDesconto1 = this.getValorDesconto1();
        result = result * 59 + ($valorDesconto1 == null ? 43 : ((Object)$valorDesconto1).hashCode());
        String $dataDesconto1 = this.getDataDesconto1();
        result = result * 59 + ($dataDesconto1 == null ? 43 : $dataDesconto1.hashCode());
        BigDecimal $valorDesconto2 = this.getValorDesconto2();
        result = result * 59 + ($valorDesconto2 == null ? 43 : ((Object)$valorDesconto2).hashCode());
        String $dataDesconto2 = this.getDataDesconto2();
        result = result * 59 + ($dataDesconto2 == null ? 43 : $dataDesconto2.hashCode());
        BigDecimal $valorDesconto3 = this.getValorDesconto3();
        result = result * 59 + ($valorDesconto3 == null ? 43 : ((Object)$valorDesconto3).hashCode());
        String $dataDesconto3 = this.getDataDesconto3();
        result = result * 59 + ($dataDesconto3 == null ? 43 : $dataDesconto3.hashCode());
        String $tipoJuros = this.getTipoJuros();
        result = result * 59 + ($tipoJuros == null ? 43 : $tipoJuros.hashCode());
        BigDecimal $juros = this.getJuros();
        result = result * 59 + ($juros == null ? 43 : ((Object)$juros).hashCode());
        BigDecimal $multas = this.getMultas();
        result = result * 59 + ($multas == null ? 43 : ((Object)$multas).hashCode());
        BigDecimal $descontoAntecipado = this.getDescontoAntecipado();
        result = result * 59 + ($descontoAntecipado == null ? 43 : ((Object)$descontoAntecipado).hashCode());
        String $informativo = this.getInformativo();
        result = result * 59 + ($informativo == null ? 43 : $informativo.hashCode());
        String $mensagem = this.getMensagem();
        result = result * 59 + ($mensagem == null ? 43 : $mensagem.hashCode());
        String $codigoMensagem = this.getCodigoMensagem();
        result = result * 59 + ($codigoMensagem == null ? 43 : $codigoMensagem.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EmissaoBoletoSicrediDTO(agencia=" + this.getAgencia() + ", posto=" + this.getPosto() + ", cedente=" + this.getCedente() + ", nossoNumero=" + this.getNossoNumero() + ", codigoPagador=" + this.getCodigoPagador() + ", tipoPessoa=" + this.getTipoPessoa() + ", cpfCnpj=" + this.getCpfCnpj() + ", nome=" + this.getNome() + ", endereco=" + this.getEndereco() + ", cidade=" + this.getCidade() + ", uf=" + this.getUf() + ", cep=" + this.getCep() + ", telefone=" + this.getTelefone() + ", email=" + this.getEmail() + ", especieDocumento=" + this.getEspecieDocumento() + ", codigoSacadorAvalista=" + this.getCodigoSacadorAvalista() + ", seuNumero=" + this.getSeuNumero() + ", dataVencimento=" + this.getDataVencimento() + ", valor=" + this.getValor() + ", tipoDesconto=" + this.getTipoDesconto() + ", valorDesconto1=" + this.getValorDesconto1() + ", dataDesconto1=" + this.getDataDesconto1() + ", valorDesconto2=" + this.getValorDesconto2() + ", dataDesconto2=" + this.getDataDesconto2() + ", valorDesconto3=" + this.getValorDesconto3() + ", dataDesconto3=" + this.getDataDesconto3() + ", tipoJuros=" + this.getTipoJuros() + ", juros=" + this.getJuros() + ", multas=" + this.getMultas() + ", descontoAntecipado=" + this.getDescontoAntecipado() + ", informativo=" + this.getInformativo() + ", mensagem=" + this.getMensagem() + ", codigoMensagem=" + this.getCodigoMensagem() + ")";
    }
}

