/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.sicoob;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.validation.EloValidatorExecutor;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.ContatoPessoa;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.CalendarioCobrancaPixSicoob;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.CobrancaPixSicoobDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.DevedorCobrancaPixSicoob;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.InfoAdicionaisCobrancaPixSicoob;
import br.com.elotech.tributos.dto.integracaoboleto.sicoob.ValorCobrancaPixSicoob;
import br.com.elotech.tributos.util.CnpjCpfValidator;
import br.com.elotech.tributos.util.EmailValidator;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CobrancaPixSicoobDTO {
    private CalendarioCobrancaPixSicoob calendario;
    private DevedorCobrancaPixSicoob devedor;
    private ValorCobrancaPixSicoob valor;
    private String solicitacaoPagador;
    private List<InfoAdicionaisCobrancaPixSicoob> infoAdicionais;
    @NotEmpty(message="A chave pix do recebedor deve ser informada")
    private @NotEmpty(message="A chave pix do recebedor deve ser informada") String chave;

    public static CobrancaPixSicoobDTO from(Bloqueto boleto) {
        Pessoa pessoa = boleto.getPessoa();
        ContatoPessoa contatoPrincipal = pessoa.getContatoPrincipal();
        EnderecoPessoa enderecoPrincipal = pessoa.getEnderecoPrincipal();
        CalendarioCobrancaPixSicoob calendario = CalendarioCobrancaPixSicoob.builder().dataDeVencimento((String)Optional.ofNullable(boleto.getDataVencimento()).map(LocalDate::toString).orElse(null)).validadeAposVencimento(Integer.valueOf(0)).build();
        DevedorCobrancaPixSicoob devedor = DevedorCobrancaPixSicoob.builder().cpf(TipoPessoa.FISICA.equals((Object)pessoa.getTipoPessoa()) && CnpjCpfValidator.isValidCnpjCpf((String)pessoa.getCnpjCpf()) != false ? pessoa.getCnpjCpfSemMascara() : null).cnpj(TipoPessoa.JURIDICA.equals((Object)pessoa.getTipoPessoa()) && CnpjCpfValidator.isValidCnpjCpf((String)pessoa.getCnpjCpf()) != false ? pessoa.getCnpjCpfSemMascara() : null).nome(CnpjCpfValidator.isValidCnpjCpf((String)pessoa.getCnpjCpf()) != false ? pessoa.getNome() : null).email((String)Optional.ofNullable(contatoPrincipal).map(ContatoPessoa::getEmail).filter(EmailValidator::isEmailValido).orElse(null)).cep((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCep).map(cep -> StringUtils.leftPad((String)cep.toString(), (int)8, (String)"0")).orElse(null)).cidade((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCidade).map(Cidade::getDescricao).orElse(null)).uf((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getCidade).map(Cidade::getUnidadeFederacao).orElse(null)).logradouro((String)Optional.ofNullable(enderecoPrincipal).map(EnderecoPessoa::getLogradouro).map(Logradouro::getDescricao).orElse(null)).build();
        ValorCobrancaPixSicoob valor = ValorCobrancaPixSicoob.builder().abatimento(null).desconto(null).juros(null).multa(null).original(boleto.getValorBloqueto().toString()).build();
        CobrancaPixSicoobDTO dtoFinal = CobrancaPixSicoobDTO.builder().calendario(calendario).devedor(devedor).valor(valor).chave((String)Optional.ofNullable(boleto.getModeloBloqueto()).map(ModeloBoleto::getConvenio).map(Convenio::getChavePix).orElse(null)).solicitacaoPagador(null).infoAdicionais(null).build();
        return dtoFinal;
    }

    public void validate(EloValidatorExecutor validator) {
        ArrayList violations = new ArrayList();
        violations.addAll(validator.validate((Object)this.calendario));
        violations.addAll(validator.validate((Object)this.devedor));
        violations.addAll(validator.validate((Object)this.valor));
        violations.addAll(validator.validate((Object)this));
        if (!violations.isEmpty()) {
            throw new EloValidationException("Erro ao integrar com o PIX", violations);
        }
    }

    @Generated
    CobrancaPixSicoobDTO(CalendarioCobrancaPixSicoob calendario, DevedorCobrancaPixSicoob devedor, ValorCobrancaPixSicoob valor, String solicitacaoPagador, List<InfoAdicionaisCobrancaPixSicoob> infoAdicionais, String chave) {
        this.calendario = calendario;
        this.devedor = devedor;
        this.valor = valor;
        this.solicitacaoPagador = solicitacaoPagador;
        this.infoAdicionais = infoAdicionais;
        this.chave = chave;
    }

    @Generated
    public static CobrancaPixSicoobDTOBuilder builder() {
        return new CobrancaPixSicoobDTOBuilder();
    }

    @Generated
    public CalendarioCobrancaPixSicoob getCalendario() {
        return this.calendario;
    }

    @Generated
    public DevedorCobrancaPixSicoob getDevedor() {
        return this.devedor;
    }

    @Generated
    public ValorCobrancaPixSicoob getValor() {
        return this.valor;
    }

    @Generated
    public String getSolicitacaoPagador() {
        return this.solicitacaoPagador;
    }

    @Generated
    public List<InfoAdicionaisCobrancaPixSicoob> getInfoAdicionais() {
        return this.infoAdicionais;
    }

    @Generated
    public String getChave() {
        return this.chave;
    }

    @Generated
    public void setCalendario(CalendarioCobrancaPixSicoob calendario) {
        this.calendario = calendario;
    }

    @Generated
    public void setDevedor(DevedorCobrancaPixSicoob devedor) {
        this.devedor = devedor;
    }

    @Generated
    public void setValor(ValorCobrancaPixSicoob valor) {
        this.valor = valor;
    }

    @Generated
    public void setSolicitacaoPagador(String solicitacaoPagador) {
        this.solicitacaoPagador = solicitacaoPagador;
    }

    @Generated
    public void setInfoAdicionais(List<InfoAdicionaisCobrancaPixSicoob> infoAdicionais) {
        this.infoAdicionais = infoAdicionais;
    }

    @Generated
    public void setChave(String chave) {
        this.chave = chave;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CobrancaPixSicoobDTO)) {
            return false;
        }
        CobrancaPixSicoobDTO other = (CobrancaPixSicoobDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        CalendarioCobrancaPixSicoob this$calendario = this.getCalendario();
        CalendarioCobrancaPixSicoob other$calendario = other.getCalendario();
        if (this$calendario == null ? other$calendario != null : !this$calendario.equals(other$calendario)) {
            return false;
        }
        DevedorCobrancaPixSicoob this$devedor = this.getDevedor();
        DevedorCobrancaPixSicoob other$devedor = other.getDevedor();
        if (this$devedor == null ? other$devedor != null : !this$devedor.equals(other$devedor)) {
            return false;
        }
        ValorCobrancaPixSicoob this$valor = this.getValor();
        ValorCobrancaPixSicoob other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !this$valor.equals(other$valor)) {
            return false;
        }
        String this$solicitacaoPagador = this.getSolicitacaoPagador();
        String other$solicitacaoPagador = other.getSolicitacaoPagador();
        if (this$solicitacaoPagador == null ? other$solicitacaoPagador != null : !this$solicitacaoPagador.equals(other$solicitacaoPagador)) {
            return false;
        }
        List this$infoAdicionais = this.getInfoAdicionais();
        List other$infoAdicionais = other.getInfoAdicionais();
        if (this$infoAdicionais == null ? other$infoAdicionais != null : !((Object)this$infoAdicionais).equals(other$infoAdicionais)) {
            return false;
        }
        String this$chave = this.getChave();
        String other$chave = other.getChave();
        return !(this$chave == null ? other$chave != null : !this$chave.equals(other$chave));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CobrancaPixSicoobDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CalendarioCobrancaPixSicoob $calendario = this.getCalendario();
        result = result * 59 + ($calendario == null ? 43 : $calendario.hashCode());
        DevedorCobrancaPixSicoob $devedor = this.getDevedor();
        result = result * 59 + ($devedor == null ? 43 : $devedor.hashCode());
        ValorCobrancaPixSicoob $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : $valor.hashCode());
        String $solicitacaoPagador = this.getSolicitacaoPagador();
        result = result * 59 + ($solicitacaoPagador == null ? 43 : $solicitacaoPagador.hashCode());
        List $infoAdicionais = this.getInfoAdicionais();
        result = result * 59 + ($infoAdicionais == null ? 43 : ((Object)$infoAdicionais).hashCode());
        String $chave = this.getChave();
        result = result * 59 + ($chave == null ? 43 : $chave.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CobrancaPixSicoobDTO(calendario=" + this.getCalendario() + ", devedor=" + this.getDevedor() + ", valor=" + this.getValor() + ", solicitacaoPagador=" + this.getSolicitacaoPagador() + ", infoAdicionais=" + this.getInfoAdicionais() + ", chave=" + this.getChave() + ")";
    }
}

