/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.autoinfracao;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ContenciosoHistorico;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracao;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoHistorico;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoPenalidade;
import br.com.elotech.tributos.domain.autoinfracao.Fiscal;
import br.com.elotech.tributos.domain.autoinfracao.TipoAutoInfracao;
import br.com.elotech.tributos.domain.autoinfracao.TipoFiscal;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.ContenciosoIdDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.autoinfracao.AutoInfracaoPenalidadeDTO;
import br.com.elotech.tributos.dto.autoinfracao.FiscalDTO;
import br.com.elotech.tributos.dto.autoinfracao.NotificacaoDTO;
import br.com.elotech.tributos.dto.autoinfracao.TipoAutoInfracaoRowDTO;
import br.com.elotech.tributos.enums.autoinfracao.SituacaoAutoInfracao;
import br.com.elotech.tributos.util.ListUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class AutoInfracaoDTO {
    private Long id;
    private Long entidade;
    private Long exercicio;
    private Long autoInfracaoFiscal;
    private TipoAutoInfracaoRowDTO tipo;
    private LocalDate data;
    private SituacaoAutoInfracao situacao;
    private LocalDateTime dataSituacao;
    private LocalDate dataEntrega;
    private NotificacaoDTO notificacao;
    private CadastroGeralResumidoDTO cadastroGeral;
    private String proprietario;
    private Boolean cancelaIssHomologado;
    private LocalDate dataInicial;
    private LocalDate dataFim;
    private TipoFiscal tipoFiscal;
    private FiscalDTO fiscal;
    private Long processo;
    private Long exercicioProcesso;
    private Long exercicioProcessoProcon;
    private Long processoProcon;
    private Long exercicioProcesso156;
    private Long processo156;
    private LocalDate dataProcesso156;
    private ContenciosoIdDTO contencioso;
    private List<ContenciosoHistorico> historicoContencioso = new ArrayList();
    private List<AutoInfracaoPenalidadeDTO> penalidades = new ArrayList();
    private List<AutoInfracaoHistorico> historicos = new ArrayList();
    private List<DebitoIdDTO> debitos = new ArrayList();
    private DebitoIdDTO debito;
    private ProjetoPK idProjeto;
    private BigDecimal valorCreditoImposto = BigDecimal.ZERO;
    private BigDecimal valorCreditoCorrecao = BigDecimal.ZERO;
    private BigDecimal valorAuto = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorTotal = BigDecimal.ZERO;
    private BigDecimal valorPenalidades = BigDecimal.ZERO;
    private LocalDate dataVencimento;
    private String observacao;
    private String processoProconFA;
    private String processoSei;
    private String processoSeiCancelamento;
    private Long numeroProcessoCancelamento;
    private Long exercicioProcessoCancelamento;
    private MotivoDeducao motivoCancelamento;
    private String observacaoCancelamento;
    private Boolean permiteGerarDebito = Boolean.FALSE;
    private Long motivoDeducaoAlteracaoDebito;

    public static AutoInfracaoDTO from(AutoInfracao autoInfracao) {
        AutoInfracaoDTO dto = new AutoInfracaoDTO();
        dto.setId(autoInfracao.getId());
        dto.setEntidade(autoInfracao.getEntidade());
        dto.setExercicio(autoInfracao.getExercicio());
        dto.setAutoInfracaoFiscal(autoInfracao.getAutoInfracaoFiscal());
        dto.setTipo(TipoAutoInfracaoRowDTO.from((TipoAutoInfracao)autoInfracao.getTipoAutoInfracao()));
        dto.setData(autoInfracao.getData());
        dto.setSituacao(autoInfracao.getSituacao());
        dto.setDataSituacao(autoInfracao.getDataSituacao());
        dto.setDataEntrega(autoInfracao.getDataEntregaNotificacao());
        dto.setTipoFiscal(autoInfracao.getFiscal().getTipo());
        dto.setFiscal(FiscalDTO.from((Fiscal)autoInfracao.getFiscal()));
        Optional.ofNullable(autoInfracao.getNotificacao()).map(NotificacaoDTO::from).ifPresent(arg_0 -> dto.setNotificacao(arg_0));
        Optional.ofNullable(autoInfracao.getDebito()).map(DebitoIdDTO::from).ifPresent(arg_0 -> dto.setDebito(arg_0));
        Optional.ofNullable(autoInfracao.getProjeto()).map(Projeto::getId).ifPresent(arg_0 -> dto.setIdProjeto(arg_0));
        Optional.ofNullable(autoInfracao.getContencioso()).map(ContenciosoIdDTO::from).ifPresent(arg_0 -> dto.setContencioso(arg_0));
        dto.setCadastroGeral(CadastroGeralResumidoDTO.from((CadastroGeral)autoInfracao.getCadastroGeral()));
        dto.setProprietario(autoInfracao.getCadastroGeral().getPessoa().getNome());
        dto.setCancelaIssHomologado(autoInfracao.getTipoAutoInfracao().getCancelaIssHomologado());
        dto.setDataInicial(autoInfracao.getDataInicial());
        dto.setDataFim(autoInfracao.getDataFim());
        dto.setProcesso(autoInfracao.getIdProcesso());
        dto.setExercicioProcesso(autoInfracao.getExercicioProcesso());
        dto.setProcessoProcon(autoInfracao.getProcessoProcon());
        dto.setExercicioProcessoProcon(autoInfracao.getExercicioProcessoProcon());
        dto.setExercicioProcesso156(autoInfracao.getExercicioProcesso156());
        dto.setProcesso156(autoInfracao.getProcesso156());
        dto.setDataProcesso156(autoInfracao.getDataProcesso156());
        dto.setPenalidades(autoInfracao.getPenalidades().stream().map(AutoInfracaoPenalidadeDTO::new).collect(Collectors.toList()));
        dto.setHistoricos(autoInfracao.getHistoricos());
        dto.setDebitos(autoInfracao.getDebitos().stream().filter(autoInfracaoDebito -> Objects.nonNull(autoInfracaoDebito.getDebito())).map(autoInfracaoDebito -> DebitoIdDTO.from((Debito)autoInfracaoDebito.getDebito())).collect(Collectors.toList()));
        dto.setValorCreditoImposto(autoInfracao.getValorCreditoImposto());
        dto.setValorCreditoCorrecao(autoInfracao.getValorCreditoCorrecao());
        dto.setValorAuto(autoInfracao.getValorAuto());
        dto.setValorMulta(autoInfracao.getValorMulta());
        dto.setValorJuros(autoInfracao.getValorJuros());
        dto.setValorCorrecao(autoInfracao.getValorCorrecao());
        dto.setValorTotal(autoInfracao.getValorTotal());
        dto.setValorPenalidades(autoInfracao.getValorPenalidades());
        dto.setDataVencimento(autoInfracao.getDataVencimento());
        dto.setObservacao(autoInfracao.getObservacao());
        dto.setProcessoProconFA(autoInfracao.getProcessoProconFA());
        dto.setProcessoSei(autoInfracao.getProcessoSei());
        dto.setProcessoSeiCancelamento(autoInfracao.getProcessoSeiCancelamento());
        dto.setNumeroProcessoCancelamento(autoInfracao.getIdProcessoCancelamento());
        dto.setExercicioProcessoCancelamento(autoInfracao.getExercicioCancelamento());
        dto.setMotivoCancelamento(autoInfracao.getMotivoCancelamento());
        dto.setObservacaoCancelamento(autoInfracao.getObservacaoCancelamento());
        dto.setPermiteGerarDebito(Boolean.valueOf(Objects.isNull(autoInfracao.getDebito())));
        return dto;
    }

    public AutoInfracao toEntity() {
        AutoInfracao autoInfracao = new AutoInfracao();
        autoInfracao.setExercicio(this.exercicio);
        autoInfracao.setAutoInfracaoFiscal(this.autoInfracaoFiscal);
        autoInfracao.setTipoAutoInfracao(this.tipo.toEntity());
        return this.toEntity(autoInfracao);
    }

    public AutoInfracao toEntity(AutoInfracao autoInfracao) {
        autoInfracao.setFiscal(this.fiscal.toEntity(this.tipoFiscal));
        autoInfracao.setDataEntregaNotificacao(this.dataEntrega);
        autoInfracao.setDataInicial(this.dataInicial);
        autoInfracao.setDataFim(this.dataFim);
        autoInfracao.setObservacao(this.observacao);
        Optional.ofNullable(this.notificacao).map(NotificacaoDTO::toEntity).ifPresent(arg_0 -> ((AutoInfracao)autoInfracao).setNotificacao(arg_0));
        autoInfracao.setIdProcesso(this.processo);
        autoInfracao.setExercicioProcesso(this.exercicioProcesso);
        autoInfracao.setProcessoProcon(this.processoProcon);
        autoInfracao.setExercicioProcessoProcon(this.exercicioProcessoProcon);
        autoInfracao.setProcesso156(this.processo156);
        autoInfracao.setExercicioProcesso156(this.exercicioProcesso156);
        autoInfracao.setDataProcesso156(this.dataProcesso156);
        autoInfracao.setObservacao(this.observacao);
        autoInfracao.setDataVencimento(this.dataVencimento);
        autoInfracao.setValorAuto(this.valorAuto);
        autoInfracao.setValorJuros(this.valorJuros);
        autoInfracao.setValorMulta(this.valorMulta);
        autoInfracao.setValorCorrecao(this.valorCorrecao);
        autoInfracao.setValorCreditoImposto(this.valorCreditoImposto);
        autoInfracao.setValorCreditoCorrecao(this.valorCreditoCorrecao);
        autoInfracao.setProcessoSei(this.processoSei);
        autoInfracao.setProcessoProconFA(this.processoProconFA);
        List penalidades = this.penalidades.stream().map(penalidade -> {
            AutoInfracaoPenalidade autoInfracaoPenalidade = penalidade.toEntity();
            autoInfracaoPenalidade.setAutoInfracao(autoInfracao);
            return autoInfracaoPenalidade;
        }).collect(Collectors.toList());
        List penalidadesAlteradas = ListUtils.merge((List)autoInfracao.getPenalidades(), penalidades, AutoInfracaoPenalidade::getPenalidade, AutoInfracaoPenalidade::merge);
        autoInfracao.getPenalidades().clear();
        autoInfracao.getPenalidades().addAll(penalidadesAlteradas);
        return autoInfracao;
    }

    public boolean alterouValoresDebito(AutoInfracao autoInfracao) {
        return autoInfracao.getValorAuto().compareTo(this.getValorAuto()) != 0 || autoInfracao.getValorJuros().compareTo(this.getValorJuros()) != 0 || autoInfracao.getValorMulta().compareTo(this.getValorMulta()) != 0 || autoInfracao.getValorCorrecao().compareTo(this.getValorCorrecao()) != 0 || autoInfracao.getValorCreditoCorrecao().compareTo(this.getValorCreditoCorrecao()) != 0 || autoInfracao.getValorCreditoImposto().compareTo(this.getValorCreditoImposto()) != 0 || !autoInfracao.getDataVencimento().isEqual(this.getDataVencimento()) || this.alterouValoresPenalidades(autoInfracao);
    }

    private boolean alterouValoresPenalidades(AutoInfracao autoInfracao) {
        boolean sameSize = autoInfracao.getPenalidades().size() == this.getPenalidades().size();
        return !sameSize || autoInfracao.getPenalidades().stream().anyMatch(p -> {
            Optional<AutoInfracaoPenalidadeDTO> penalidadeDTO = this.getPenalidades().stream().filter(pdto -> pdto.getIdPenalidade().equals((Object)p.getPenalidade().getId())).findFirst();
            return penalidadeDTO.isEmpty() || penalidadeDTO.get().getValor().compareTo(p.getValor()) != 0;
        });
    }

    @Generated
    public AutoInfracaoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getAutoInfracaoFiscal() {
        return this.autoInfracaoFiscal;
    }

    @Generated
    public TipoAutoInfracaoRowDTO getTipo() {
        return this.tipo;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public SituacaoAutoInfracao getSituacao() {
        return this.situacao;
    }

    @Generated
    public LocalDateTime getDataSituacao() {
        return this.dataSituacao;
    }

    @Generated
    public LocalDate getDataEntrega() {
        return this.dataEntrega;
    }

    @Generated
    public NotificacaoDTO getNotificacao() {
        return this.notificacao;
    }

    @Generated
    public CadastroGeralResumidoDTO getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getProprietario() {
        return this.proprietario;
    }

    @Generated
    public Boolean getCancelaIssHomologado() {
        return this.cancelaIssHomologado;
    }

    @Generated
    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    @Generated
    public LocalDate getDataFim() {
        return this.dataFim;
    }

    @Generated
    public TipoFiscal getTipoFiscal() {
        return this.tipoFiscal;
    }

    @Generated
    public FiscalDTO getFiscal() {
        return this.fiscal;
    }

    @Generated
    public Long getProcesso() {
        return this.processo;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getExercicioProcessoProcon() {
        return this.exercicioProcessoProcon;
    }

    @Generated
    public Long getProcessoProcon() {
        return this.processoProcon;
    }

    @Generated
    public Long getExercicioProcesso156() {
        return this.exercicioProcesso156;
    }

    @Generated
    public Long getProcesso156() {
        return this.processo156;
    }

    @Generated
    public LocalDate getDataProcesso156() {
        return this.dataProcesso156;
    }

    @Generated
    public ContenciosoIdDTO getContencioso() {
        return this.contencioso;
    }

    @Generated
    public List<ContenciosoHistorico> getHistoricoContencioso() {
        return this.historicoContencioso;
    }

    @Generated
    public List<AutoInfracaoPenalidadeDTO> getPenalidades() {
        return this.penalidades;
    }

    @Generated
    public List<AutoInfracaoHistorico> getHistoricos() {
        return this.historicos;
    }

    @Generated
    public List<DebitoIdDTO> getDebitos() {
        return this.debitos;
    }

    @Generated
    public DebitoIdDTO getDebito() {
        return this.debito;
    }

    @Generated
    public ProjetoPK getIdProjeto() {
        return this.idProjeto;
    }

    @Generated
    public BigDecimal getValorCreditoImposto() {
        return this.valorCreditoImposto;
    }

    @Generated
    public BigDecimal getValorCreditoCorrecao() {
        return this.valorCreditoCorrecao;
    }

    @Generated
    public BigDecimal getValorAuto() {
        return this.valorAuto;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public BigDecimal getValorPenalidades() {
        return this.valorPenalidades;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getProcessoProconFA() {
        return this.processoProconFA;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public String getProcessoSeiCancelamento() {
        return this.processoSeiCancelamento;
    }

    @Generated
    public Long getNumeroProcessoCancelamento() {
        return this.numeroProcessoCancelamento;
    }

    @Generated
    public Long getExercicioProcessoCancelamento() {
        return this.exercicioProcessoCancelamento;
    }

    @Generated
    public MotivoDeducao getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    @Generated
    public String getObservacaoCancelamento() {
        return this.observacaoCancelamento;
    }

    @Generated
    public Boolean getPermiteGerarDebito() {
        return this.permiteGerarDebito;
    }

    @Generated
    public Long getMotivoDeducaoAlteracaoDebito() {
        return this.motivoDeducaoAlteracaoDebito;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setAutoInfracaoFiscal(Long autoInfracaoFiscal) {
        this.autoInfracaoFiscal = autoInfracaoFiscal;
    }

    @Generated
    public void setTipo(TipoAutoInfracaoRowDTO tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setSituacao(SituacaoAutoInfracao situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setDataSituacao(LocalDateTime dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    @Generated
    public void setDataEntrega(LocalDate dataEntrega) {
        this.dataEntrega = dataEntrega;
    }

    @Generated
    public void setNotificacao(NotificacaoDTO notificacao) {
        this.notificacao = notificacao;
    }

    @Generated
    public void setCadastroGeral(CadastroGeralResumidoDTO cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setProprietario(String proprietario) {
        this.proprietario = proprietario;
    }

    @Generated
    public void setCancelaIssHomologado(Boolean cancelaIssHomologado) {
        this.cancelaIssHomologado = cancelaIssHomologado;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFim(LocalDate dataFim) {
        this.dataFim = dataFim;
    }

    @Generated
    public void setTipoFiscal(TipoFiscal tipoFiscal) {
        this.tipoFiscal = tipoFiscal;
    }

    @Generated
    public void setFiscal(FiscalDTO fiscal) {
        this.fiscal = fiscal;
    }

    @Generated
    public void setProcesso(Long processo) {
        this.processo = processo;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setExercicioProcessoProcon(Long exercicioProcessoProcon) {
        this.exercicioProcessoProcon = exercicioProcessoProcon;
    }

    @Generated
    public void setProcessoProcon(Long processoProcon) {
        this.processoProcon = processoProcon;
    }

    @Generated
    public void setExercicioProcesso156(Long exercicioProcesso156) {
        this.exercicioProcesso156 = exercicioProcesso156;
    }

    @Generated
    public void setProcesso156(Long processo156) {
        this.processo156 = processo156;
    }

    @Generated
    public void setDataProcesso156(LocalDate dataProcesso156) {
        this.dataProcesso156 = dataProcesso156;
    }

    @Generated
    public void setContencioso(ContenciosoIdDTO contencioso) {
        this.contencioso = contencioso;
    }

    @Generated
    public void setHistoricoContencioso(List<ContenciosoHistorico> historicoContencioso) {
        this.historicoContencioso = historicoContencioso;
    }

    @Generated
    public void setPenalidades(List<AutoInfracaoPenalidadeDTO> penalidades) {
        this.penalidades = penalidades;
    }

    @Generated
    public void setHistoricos(List<AutoInfracaoHistorico> historicos) {
        this.historicos = historicos;
    }

    @Generated
    public void setDebitos(List<DebitoIdDTO> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public void setDebito(DebitoIdDTO debito) {
        this.debito = debito;
    }

    @Generated
    public void setIdProjeto(ProjetoPK idProjeto) {
        this.idProjeto = idProjeto;
    }

    @Generated
    public void setValorCreditoImposto(BigDecimal valorCreditoImposto) {
        this.valorCreditoImposto = valorCreditoImposto;
    }

    @Generated
    public void setValorCreditoCorrecao(BigDecimal valorCreditoCorrecao) {
        this.valorCreditoCorrecao = valorCreditoCorrecao;
    }

    @Generated
    public void setValorAuto(BigDecimal valorAuto) {
        this.valorAuto = valorAuto;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setValorPenalidades(BigDecimal valorPenalidades) {
        this.valorPenalidades = valorPenalidades;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setProcessoProconFA(String processoProconFA) {
        this.processoProconFA = processoProconFA;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public void setProcessoSeiCancelamento(String processoSeiCancelamento) {
        this.processoSeiCancelamento = processoSeiCancelamento;
    }

    @Generated
    public void setNumeroProcessoCancelamento(Long numeroProcessoCancelamento) {
        this.numeroProcessoCancelamento = numeroProcessoCancelamento;
    }

    @Generated
    public void setExercicioProcessoCancelamento(Long exercicioProcessoCancelamento) {
        this.exercicioProcessoCancelamento = exercicioProcessoCancelamento;
    }

    @Generated
    public void setMotivoCancelamento(MotivoDeducao motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Generated
    public void setObservacaoCancelamento(String observacaoCancelamento) {
        this.observacaoCancelamento = observacaoCancelamento;
    }

    @Generated
    public void setPermiteGerarDebito(Boolean permiteGerarDebito) {
        this.permiteGerarDebito = permiteGerarDebito;
    }

    @Generated
    public void setMotivoDeducaoAlteracaoDebito(Long motivoDeducaoAlteracaoDebito) {
        this.motivoDeducaoAlteracaoDebito = motivoDeducaoAlteracaoDebito;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoInfracaoDTO)) {
            return false;
        }
        AutoInfracaoDTO other = (AutoInfracaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$autoInfracaoFiscal = this.getAutoInfracaoFiscal();
        Long other$autoInfracaoFiscal = other.getAutoInfracaoFiscal();
        if (this$autoInfracaoFiscal == null ? other$autoInfracaoFiscal != null : !((Object)this$autoInfracaoFiscal).equals(other$autoInfracaoFiscal)) {
            return false;
        }
        Boolean this$cancelaIssHomologado = this.getCancelaIssHomologado();
        Boolean other$cancelaIssHomologado = other.getCancelaIssHomologado();
        if (this$cancelaIssHomologado == null ? other$cancelaIssHomologado != null : !((Object)this$cancelaIssHomologado).equals(other$cancelaIssHomologado)) {
            return false;
        }
        Long this$processo = this.getProcesso();
        Long other$processo = other.getProcesso();
        if (this$processo == null ? other$processo != null : !((Object)this$processo).equals(other$processo)) {
            return false;
        }
        Long this$exercicioProcesso = this.getExercicioProcesso();
        Long other$exercicioProcesso = other.getExercicioProcesso();
        if (this$exercicioProcesso == null ? other$exercicioProcesso != null : !((Object)this$exercicioProcesso).equals(other$exercicioProcesso)) {
            return false;
        }
        Long this$exercicioProcessoProcon = this.getExercicioProcessoProcon();
        Long other$exercicioProcessoProcon = other.getExercicioProcessoProcon();
        if (this$exercicioProcessoProcon == null ? other$exercicioProcessoProcon != null : !((Object)this$exercicioProcessoProcon).equals(other$exercicioProcessoProcon)) {
            return false;
        }
        Long this$processoProcon = this.getProcessoProcon();
        Long other$processoProcon = other.getProcessoProcon();
        if (this$processoProcon == null ? other$processoProcon != null : !((Object)this$processoProcon).equals(other$processoProcon)) {
            return false;
        }
        Long this$exercicioProcesso156 = this.getExercicioProcesso156();
        Long other$exercicioProcesso156 = other.getExercicioProcesso156();
        if (this$exercicioProcesso156 == null ? other$exercicioProcesso156 != null : !((Object)this$exercicioProcesso156).equals(other$exercicioProcesso156)) {
            return false;
        }
        Long this$processo156 = this.getProcesso156();
        Long other$processo156 = other.getProcesso156();
        if (this$processo156 == null ? other$processo156 != null : !((Object)this$processo156).equals(other$processo156)) {
            return false;
        }
        Long this$numeroProcessoCancelamento = this.getNumeroProcessoCancelamento();
        Long other$numeroProcessoCancelamento = other.getNumeroProcessoCancelamento();
        if (this$numeroProcessoCancelamento == null ? other$numeroProcessoCancelamento != null : !((Object)this$numeroProcessoCancelamento).equals(other$numeroProcessoCancelamento)) {
            return false;
        }
        Long this$exercicioProcessoCancelamento = this.getExercicioProcessoCancelamento();
        Long other$exercicioProcessoCancelamento = other.getExercicioProcessoCancelamento();
        if (this$exercicioProcessoCancelamento == null ? other$exercicioProcessoCancelamento != null : !((Object)this$exercicioProcessoCancelamento).equals(other$exercicioProcessoCancelamento)) {
            return false;
        }
        Boolean this$permiteGerarDebito = this.getPermiteGerarDebito();
        Boolean other$permiteGerarDebito = other.getPermiteGerarDebito();
        if (this$permiteGerarDebito == null ? other$permiteGerarDebito != null : !((Object)this$permiteGerarDebito).equals(other$permiteGerarDebito)) {
            return false;
        }
        Long this$motivoDeducaoAlteracaoDebito = this.getMotivoDeducaoAlteracaoDebito();
        Long other$motivoDeducaoAlteracaoDebito = other.getMotivoDeducaoAlteracaoDebito();
        if (this$motivoDeducaoAlteracaoDebito == null ? other$motivoDeducaoAlteracaoDebito != null : !((Object)this$motivoDeducaoAlteracaoDebito).equals(other$motivoDeducaoAlteracaoDebito)) {
            return false;
        }
        TipoAutoInfracaoRowDTO this$tipo = this.getTipo();
        TipoAutoInfracaoRowDTO other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        SituacaoAutoInfracao this$situacao = this.getSituacao();
        SituacaoAutoInfracao other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        LocalDateTime this$dataSituacao = this.getDataSituacao();
        LocalDateTime other$dataSituacao = other.getDataSituacao();
        if (this$dataSituacao == null ? other$dataSituacao != null : !((Object)this$dataSituacao).equals(other$dataSituacao)) {
            return false;
        }
        LocalDate this$dataEntrega = this.getDataEntrega();
        LocalDate other$dataEntrega = other.getDataEntrega();
        if (this$dataEntrega == null ? other$dataEntrega != null : !((Object)this$dataEntrega).equals(other$dataEntrega)) {
            return false;
        }
        NotificacaoDTO this$notificacao = this.getNotificacao();
        NotificacaoDTO other$notificacao = other.getNotificacao();
        if (this$notificacao == null ? other$notificacao != null : !this$notificacao.equals(other$notificacao)) {
            return false;
        }
        CadastroGeralResumidoDTO this$cadastroGeral = this.getCadastroGeral();
        CadastroGeralResumidoDTO other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$proprietario = this.getProprietario();
        String other$proprietario = other.getProprietario();
        if (this$proprietario == null ? other$proprietario != null : !this$proprietario.equals(other$proprietario)) {
            return false;
        }
        LocalDate this$dataInicial = this.getDataInicial();
        LocalDate other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        LocalDate this$dataFim = this.getDataFim();
        LocalDate other$dataFim = other.getDataFim();
        if (this$dataFim == null ? other$dataFim != null : !((Object)this$dataFim).equals(other$dataFim)) {
            return false;
        }
        TipoFiscal this$tipoFiscal = this.getTipoFiscal();
        TipoFiscal other$tipoFiscal = other.getTipoFiscal();
        if (this$tipoFiscal == null ? other$tipoFiscal != null : !this$tipoFiscal.equals(other$tipoFiscal)) {
            return false;
        }
        FiscalDTO this$fiscal = this.getFiscal();
        FiscalDTO other$fiscal = other.getFiscal();
        if (this$fiscal == null ? other$fiscal != null : !this$fiscal.equals(other$fiscal)) {
            return false;
        }
        LocalDate this$dataProcesso156 = this.getDataProcesso156();
        LocalDate other$dataProcesso156 = other.getDataProcesso156();
        if (this$dataProcesso156 == null ? other$dataProcesso156 != null : !((Object)this$dataProcesso156).equals(other$dataProcesso156)) {
            return false;
        }
        ContenciosoIdDTO this$contencioso = this.getContencioso();
        ContenciosoIdDTO other$contencioso = other.getContencioso();
        if (this$contencioso == null ? other$contencioso != null : !this$contencioso.equals(other$contencioso)) {
            return false;
        }
        List this$historicoContencioso = this.getHistoricoContencioso();
        List other$historicoContencioso = other.getHistoricoContencioso();
        if (this$historicoContencioso == null ? other$historicoContencioso != null : !((Object)this$historicoContencioso).equals(other$historicoContencioso)) {
            return false;
        }
        List this$penalidades = this.getPenalidades();
        List other$penalidades = other.getPenalidades();
        if (this$penalidades == null ? other$penalidades != null : !((Object)this$penalidades).equals(other$penalidades)) {
            return false;
        }
        List this$historicos = this.getHistoricos();
        List other$historicos = other.getHistoricos();
        if (this$historicos == null ? other$historicos != null : !((Object)this$historicos).equals(other$historicos)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        DebitoIdDTO this$debito = this.getDebito();
        DebitoIdDTO other$debito = other.getDebito();
        if (this$debito == null ? other$debito != null : !this$debito.equals(other$debito)) {
            return false;
        }
        ProjetoPK this$idProjeto = this.getIdProjeto();
        ProjetoPK other$idProjeto = other.getIdProjeto();
        if (this$idProjeto == null ? other$idProjeto != null : !this$idProjeto.equals(other$idProjeto)) {
            return false;
        }
        BigDecimal this$valorCreditoImposto = this.getValorCreditoImposto();
        BigDecimal other$valorCreditoImposto = other.getValorCreditoImposto();
        if (this$valorCreditoImposto == null ? other$valorCreditoImposto != null : !((Object)this$valorCreditoImposto).equals(other$valorCreditoImposto)) {
            return false;
        }
        BigDecimal this$valorCreditoCorrecao = this.getValorCreditoCorrecao();
        BigDecimal other$valorCreditoCorrecao = other.getValorCreditoCorrecao();
        if (this$valorCreditoCorrecao == null ? other$valorCreditoCorrecao != null : !((Object)this$valorCreditoCorrecao).equals(other$valorCreditoCorrecao)) {
            return false;
        }
        BigDecimal this$valorAuto = this.getValorAuto();
        BigDecimal other$valorAuto = other.getValorAuto();
        if (this$valorAuto == null ? other$valorAuto != null : !((Object)this$valorAuto).equals(other$valorAuto)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        BigDecimal this$valorPenalidades = this.getValorPenalidades();
        BigDecimal other$valorPenalidades = other.getValorPenalidades();
        if (this$valorPenalidades == null ? other$valorPenalidades != null : !((Object)this$valorPenalidades).equals(other$valorPenalidades)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$processoProconFA = this.getProcessoProconFA();
        String other$processoProconFA = other.getProcessoProconFA();
        if (this$processoProconFA == null ? other$processoProconFA != null : !this$processoProconFA.equals(other$processoProconFA)) {
            return false;
        }
        String this$processoSei = this.getProcessoSei();
        String other$processoSei = other.getProcessoSei();
        if (this$processoSei == null ? other$processoSei != null : !this$processoSei.equals(other$processoSei)) {
            return false;
        }
        String this$processoSeiCancelamento = this.getProcessoSeiCancelamento();
        String other$processoSeiCancelamento = other.getProcessoSeiCancelamento();
        if (this$processoSeiCancelamento == null ? other$processoSeiCancelamento != null : !this$processoSeiCancelamento.equals(other$processoSeiCancelamento)) {
            return false;
        }
        MotivoDeducao this$motivoCancelamento = this.getMotivoCancelamento();
        MotivoDeducao other$motivoCancelamento = other.getMotivoCancelamento();
        if (this$motivoCancelamento == null ? other$motivoCancelamento != null : !this$motivoCancelamento.equals(other$motivoCancelamento)) {
            return false;
        }
        String this$observacaoCancelamento = this.getObservacaoCancelamento();
        String other$observacaoCancelamento = other.getObservacaoCancelamento();
        return !(this$observacaoCancelamento == null ? other$observacaoCancelamento != null : !this$observacaoCancelamento.equals(other$observacaoCancelamento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutoInfracaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $autoInfracaoFiscal = this.getAutoInfracaoFiscal();
        result = result * 59 + ($autoInfracaoFiscal == null ? 43 : ((Object)$autoInfracaoFiscal).hashCode());
        Boolean $cancelaIssHomologado = this.getCancelaIssHomologado();
        result = result * 59 + ($cancelaIssHomologado == null ? 43 : ((Object)$cancelaIssHomologado).hashCode());
        Long $processo = this.getProcesso();
        result = result * 59 + ($processo == null ? 43 : ((Object)$processo).hashCode());
        Long $exercicioProcesso = this.getExercicioProcesso();
        result = result * 59 + ($exercicioProcesso == null ? 43 : ((Object)$exercicioProcesso).hashCode());
        Long $exercicioProcessoProcon = this.getExercicioProcessoProcon();
        result = result * 59 + ($exercicioProcessoProcon == null ? 43 : ((Object)$exercicioProcessoProcon).hashCode());
        Long $processoProcon = this.getProcessoProcon();
        result = result * 59 + ($processoProcon == null ? 43 : ((Object)$processoProcon).hashCode());
        Long $exercicioProcesso156 = this.getExercicioProcesso156();
        result = result * 59 + ($exercicioProcesso156 == null ? 43 : ((Object)$exercicioProcesso156).hashCode());
        Long $processo156 = this.getProcesso156();
        result = result * 59 + ($processo156 == null ? 43 : ((Object)$processo156).hashCode());
        Long $numeroProcessoCancelamento = this.getNumeroProcessoCancelamento();
        result = result * 59 + ($numeroProcessoCancelamento == null ? 43 : ((Object)$numeroProcessoCancelamento).hashCode());
        Long $exercicioProcessoCancelamento = this.getExercicioProcessoCancelamento();
        result = result * 59 + ($exercicioProcessoCancelamento == null ? 43 : ((Object)$exercicioProcessoCancelamento).hashCode());
        Boolean $permiteGerarDebito = this.getPermiteGerarDebito();
        result = result * 59 + ($permiteGerarDebito == null ? 43 : ((Object)$permiteGerarDebito).hashCode());
        Long $motivoDeducaoAlteracaoDebito = this.getMotivoDeducaoAlteracaoDebito();
        result = result * 59 + ($motivoDeducaoAlteracaoDebito == null ? 43 : ((Object)$motivoDeducaoAlteracaoDebito).hashCode());
        TipoAutoInfracaoRowDTO $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        SituacaoAutoInfracao $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        LocalDateTime $dataSituacao = this.getDataSituacao();
        result = result * 59 + ($dataSituacao == null ? 43 : ((Object)$dataSituacao).hashCode());
        LocalDate $dataEntrega = this.getDataEntrega();
        result = result * 59 + ($dataEntrega == null ? 43 : ((Object)$dataEntrega).hashCode());
        NotificacaoDTO $notificacao = this.getNotificacao();
        result = result * 59 + ($notificacao == null ? 43 : $notificacao.hashCode());
        CadastroGeralResumidoDTO $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $proprietario = this.getProprietario();
        result = result * 59 + ($proprietario == null ? 43 : $proprietario.hashCode());
        LocalDate $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        LocalDate $dataFim = this.getDataFim();
        result = result * 59 + ($dataFim == null ? 43 : ((Object)$dataFim).hashCode());
        TipoFiscal $tipoFiscal = this.getTipoFiscal();
        result = result * 59 + ($tipoFiscal == null ? 43 : $tipoFiscal.hashCode());
        FiscalDTO $fiscal = this.getFiscal();
        result = result * 59 + ($fiscal == null ? 43 : $fiscal.hashCode());
        LocalDate $dataProcesso156 = this.getDataProcesso156();
        result = result * 59 + ($dataProcesso156 == null ? 43 : ((Object)$dataProcesso156).hashCode());
        ContenciosoIdDTO $contencioso = this.getContencioso();
        result = result * 59 + ($contencioso == null ? 43 : $contencioso.hashCode());
        List $historicoContencioso = this.getHistoricoContencioso();
        result = result * 59 + ($historicoContencioso == null ? 43 : ((Object)$historicoContencioso).hashCode());
        List $penalidades = this.getPenalidades();
        result = result * 59 + ($penalidades == null ? 43 : ((Object)$penalidades).hashCode());
        List $historicos = this.getHistoricos();
        result = result * 59 + ($historicos == null ? 43 : ((Object)$historicos).hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        DebitoIdDTO $debito = this.getDebito();
        result = result * 59 + ($debito == null ? 43 : $debito.hashCode());
        ProjetoPK $idProjeto = this.getIdProjeto();
        result = result * 59 + ($idProjeto == null ? 43 : $idProjeto.hashCode());
        BigDecimal $valorCreditoImposto = this.getValorCreditoImposto();
        result = result * 59 + ($valorCreditoImposto == null ? 43 : ((Object)$valorCreditoImposto).hashCode());
        BigDecimal $valorCreditoCorrecao = this.getValorCreditoCorrecao();
        result = result * 59 + ($valorCreditoCorrecao == null ? 43 : ((Object)$valorCreditoCorrecao).hashCode());
        BigDecimal $valorAuto = this.getValorAuto();
        result = result * 59 + ($valorAuto == null ? 43 : ((Object)$valorAuto).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        BigDecimal $valorPenalidades = this.getValorPenalidades();
        result = result * 59 + ($valorPenalidades == null ? 43 : ((Object)$valorPenalidades).hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $processoProconFA = this.getProcessoProconFA();
        result = result * 59 + ($processoProconFA == null ? 43 : $processoProconFA.hashCode());
        String $processoSei = this.getProcessoSei();
        result = result * 59 + ($processoSei == null ? 43 : $processoSei.hashCode());
        String $processoSeiCancelamento = this.getProcessoSeiCancelamento();
        result = result * 59 + ($processoSeiCancelamento == null ? 43 : $processoSeiCancelamento.hashCode());
        MotivoDeducao $motivoCancelamento = this.getMotivoCancelamento();
        result = result * 59 + ($motivoCancelamento == null ? 43 : $motivoCancelamento.hashCode());
        String $observacaoCancelamento = this.getObservacaoCancelamento();
        result = result * 59 + ($observacaoCancelamento == null ? 43 : $observacaoCancelamento.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AutoInfracaoDTO(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", autoInfracaoFiscal=" + this.getAutoInfracaoFiscal() + ", tipo=" + this.getTipo() + ", data=" + this.getData() + ", situacao=" + this.getSituacao() + ", dataSituacao=" + this.getDataSituacao() + ", dataEntrega=" + this.getDataEntrega() + ", notificacao=" + this.getNotificacao() + ", cadastroGeral=" + this.getCadastroGeral() + ", proprietario=" + this.getProprietario() + ", cancelaIssHomologado=" + this.getCancelaIssHomologado() + ", dataInicial=" + this.getDataInicial() + ", dataFim=" + this.getDataFim() + ", tipoFiscal=" + this.getTipoFiscal() + ", fiscal=" + this.getFiscal() + ", processo=" + this.getProcesso() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", exercicioProcessoProcon=" + this.getExercicioProcessoProcon() + ", processoProcon=" + this.getProcessoProcon() + ", exercicioProcesso156=" + this.getExercicioProcesso156() + ", processo156=" + this.getProcesso156() + ", dataProcesso156=" + this.getDataProcesso156() + ", contencioso=" + this.getContencioso() + ", historicoContencioso=" + this.getHistoricoContencioso() + ", penalidades=" + this.getPenalidades() + ", historicos=" + this.getHistoricos() + ", debitos=" + this.getDebitos() + ", debito=" + this.getDebito() + ", idProjeto=" + this.getIdProjeto() + ", valorCreditoImposto=" + this.getValorCreditoImposto() + ", valorCreditoCorrecao=" + this.getValorCreditoCorrecao() + ", valorAuto=" + this.getValorAuto() + ", valorMulta=" + this.getValorMulta() + ", valorJuros=" + this.getValorJuros() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorTotal=" + this.getValorTotal() + ", valorPenalidades=" + this.getValorPenalidades() + ", dataVencimento=" + this.getDataVencimento() + ", observacao=" + this.getObservacao() + ", processoProconFA=" + this.getProcessoProconFA() + ", processoSei=" + this.getProcessoSei() + ", processoSeiCancelamento=" + this.getProcessoSeiCancelamento() + ", numeroProcessoCancelamento=" + this.getNumeroProcessoCancelamento() + ", exercicioProcessoCancelamento=" + this.getExercicioProcessoCancelamento() + ", motivoCancelamento=" + this.getMotivoCancelamento() + ", observacaoCancelamento=" + this.getObservacaoCancelamento() + ", permiteGerarDebito=" + this.getPermiteGerarDebito() + ", motivoDeducaoAlteracaoDebito=" + this.getMotivoDeducaoAlteracaoDebito() + ")";
    }
}

