/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.acrescimo;

import br.com.elotech.tributos.domain.BaseCorrecaoMonetaria;
import br.com.elotech.tributos.domain.BaseJurosCorrecao;
import br.com.elotech.tributos.domain.BaseMultaCorrecao;
import br.com.elotech.tributos.domain.EntidadeCorrecao;
import br.com.elotech.tributos.domain.EntidadeCorrecaoDivida;
import br.com.elotech.tributos.domain.EntidadeCorrecaoIndiceCorrecao;
import br.com.elotech.tributos.domain.EntidadeCorrecaoIndiceJuros;
import br.com.elotech.tributos.domain.EntidadeCorrecaoIndiceMulta;
import br.com.elotech.tributos.domain.EntidadeCorrecaoMulta;
import br.com.elotech.tributos.domain.EntidadeCorrecaoMultaEspecial;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.MultaDiasCorrecao;
import br.com.elotech.tributos.domain.acrescimo.TipoJuros;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;
import org.springframework.util.Assert;

public class EntidadeCorrecaoDTO {
    private Long entidade;
    private Long exercicio;
    private Long sequencia;
    private String descricao;
    private Boolean multaEspecial = Boolean.FALSE;
    private Boolean principal = Boolean.FALSE;
    private Boolean sobreporMulta = Boolean.FALSE;
    private Boolean arredondaPorPartesNoCalculo = Boolean.FALSE;
    private Boolean utilizaCorrecaoEspecial = Boolean.FALSE;
    @IgnoreSizeOf
    private FormaCorrecao formaCorrecao;
    @IgnoreSizeOf
    private FormaCorrecao correcaoEspecial;
    private BigDecimal unidadeFiscal;
    private BigDecimal juroMora;
    @IgnoreSizeOf
    private MultaDiasCorrecao multaDias;
    private TipoJuros mesJuros;
    private BaseCorrecaoMonetaria baseCorrecaoMonetaria;
    private BaseJurosCorrecao baseJuros;
    private BaseMultaCorrecao baseMulta;
    @IgnoreSizeOf
    private List<EntidadeCorrecaoMulta> correcaoMulta = new ArrayList();
    @IgnoreSizeOf
    private List<EntidadeCorrecaoMultaEspecial> correcaoMultaEspecial = new ArrayList();
    @IgnoreSizeOf
    private List<EntidadeCorrecaoDivida> entidadeCorrecaoDivida = new ArrayList();
    @IgnoreSizeOf
    private EntidadeCorrecaoIndiceMulta entidadeCorrecaoIndiceMulta;
    @IgnoreSizeOf
    private EntidadeCorrecaoIndiceCorrecao entidadeCorrecaoIndiceCorrecao;
    @IgnoreSizeOf
    private EntidadeCorrecaoIndiceJuros entidadeCorrecaoIndiceJuros;

    public static final EntidadeCorrecaoDTO of(EntidadeCorrecao entidadeCorrecao) {
        EntidadeCorrecaoDTO dto = new EntidadeCorrecaoDTO();
        Optional.ofNullable(entidadeCorrecao.getId()).ifPresent(id -> {
            dto.setEntidade(id.getEntidade());
            dto.setExercicio(id.getExercicio());
            dto.setSequencia(id.getSequencia());
        });
        Optional.ofNullable(entidadeCorrecao.getDescricao()).ifPresent(arg_0 -> dto.setDescricao(arg_0));
        Optional.ofNullable(entidadeCorrecao.getMultaEspecial()).ifPresent(arg_0 -> dto.setMultaEspecial(arg_0));
        Optional.ofNullable(entidadeCorrecao.getPrincipal()).ifPresent(arg_0 -> dto.setPrincipal(arg_0));
        Optional.ofNullable(entidadeCorrecao.getSobreporMulta()).ifPresent(arg_0 -> dto.setSobreporMulta(arg_0));
        Optional.ofNullable(entidadeCorrecao.getArredondaPorPartesNoCalculo()).ifPresent(arg_0 -> dto.setArredondaPorPartesNoCalculo(arg_0));
        Optional.ofNullable(entidadeCorrecao.getUtilizaCorrecaoEspecial()).ifPresent(arg_0 -> dto.setUtilizaCorrecaoEspecial(arg_0));
        Optional.ofNullable(entidadeCorrecao.getFormaCorrecao()).ifPresent(arg_0 -> dto.setFormaCorrecao(arg_0));
        Optional.ofNullable(entidadeCorrecao.getCorrecaoEspecial()).ifPresent(arg_0 -> dto.setCorrecaoEspecial(arg_0));
        Optional.ofNullable(entidadeCorrecao.getUnidadeFiscal()).ifPresent(arg_0 -> dto.setUnidadeFiscal(arg_0));
        Optional.ofNullable(entidadeCorrecao.getJuroMora()).ifPresent(arg_0 -> dto.setJuroMora(arg_0));
        Optional.ofNullable(entidadeCorrecao.getMultaDias()).ifPresent(arg_0 -> dto.setMultaDias(arg_0));
        Optional.ofNullable(entidadeCorrecao.getMesJuros()).ifPresent(arg_0 -> dto.setMesJuros(arg_0));
        Assert.notNull((Object)entidadeCorrecao.getBaseCorrecaoMonetaria(), (String)String.format("Entidade corre\u00e7\u00e3o sem base corre\u00e7\u00e3o monet\u00e1ria %s", entidadeCorrecao.getId()));
        Assert.notNull((Object)entidadeCorrecao.getBaseJuros(), (String)String.format("Entidade corre\u00e7\u00e3o sem base juros %s", entidadeCorrecao.getId()));
        Assert.notNull((Object)entidadeCorrecao.getBaseMulta(), (String)String.format("Entidade corre\u00e7\u00e3o sem base multa %s ", entidadeCorrecao.getId()));
        Optional.ofNullable(entidadeCorrecao.getBaseCorrecaoMonetaria()).ifPresent(arg_0 -> dto.setBaseCorrecaoMonetaria(arg_0));
        Optional.ofNullable(entidadeCorrecao.getBaseJuros()).ifPresent(arg_0 -> dto.setBaseJuros(arg_0));
        Optional.ofNullable(entidadeCorrecao.getBaseMulta()).ifPresent(arg_0 -> dto.setBaseMulta(arg_0));
        dto.correcaoMulta.addAll(entidadeCorrecao.getCorrecaoMulta());
        dto.correcaoMultaEspecial.addAll(entidadeCorrecao.getCorrecaoMultaEspecial());
        dto.entidadeCorrecaoDivida.addAll(entidadeCorrecao.getEntidadeCorrecaoDivida());
        Assert.notNull((Object)entidadeCorrecao.getEntidadeCorrecaoIndiceCorrecao(), (String)String.format("Entidade corre\u00e7\u00e3o sem \u00edndice corre\u00e7\u00e3o %s", entidadeCorrecao.getId()));
        Assert.notNull((Object)entidadeCorrecao.getEntidadeCorrecaoIndiceJuros(), (String)String.format("Entidade corre\u00e7\u00e3o sem \u00edndice juros %s", entidadeCorrecao.getId()));
        Assert.notNull((Object)entidadeCorrecao.getEntidadeCorrecaoIndiceMulta(), (String)String.format("Entidade corre\u00e7\u00e3o sem \u00edndice multa %s ", entidadeCorrecao.getId()));
        Optional.ofNullable(entidadeCorrecao.getEntidadeCorrecaoIndiceCorrecao()).ifPresent(arg_0 -> dto.setEntidadeCorrecaoIndiceCorrecao(arg_0));
        Optional.ofNullable(entidadeCorrecao.getEntidadeCorrecaoIndiceJuros()).ifPresent(arg_0 -> dto.setEntidadeCorrecaoIndiceJuros(arg_0));
        Optional.ofNullable(entidadeCorrecao.getEntidadeCorrecaoIndiceMulta()).ifPresent(arg_0 -> dto.setEntidadeCorrecaoIndiceMulta(arg_0));
        return dto;
    }

    public boolean utilizaCorrecaoEspecial() {
        return Boolean.TRUE.equals(this.utilizaCorrecaoEspecial);
    }

    @Generated
    public EntidadeCorrecaoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Boolean getMultaEspecial() {
        return this.multaEspecial;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public Boolean getSobreporMulta() {
        return this.sobreporMulta;
    }

    @Generated
    public Boolean getArredondaPorPartesNoCalculo() {
        return this.arredondaPorPartesNoCalculo;
    }

    @Generated
    public Boolean getUtilizaCorrecaoEspecial() {
        return this.utilizaCorrecaoEspecial;
    }

    @Generated
    public FormaCorrecao getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public FormaCorrecao getCorrecaoEspecial() {
        return this.correcaoEspecial;
    }

    @Generated
    public BigDecimal getUnidadeFiscal() {
        return this.unidadeFiscal;
    }

    @Generated
    public BigDecimal getJuroMora() {
        return this.juroMora;
    }

    @Generated
    public MultaDiasCorrecao getMultaDias() {
        return this.multaDias;
    }

    @Generated
    public TipoJuros getMesJuros() {
        return this.mesJuros;
    }

    @Generated
    public BaseCorrecaoMonetaria getBaseCorrecaoMonetaria() {
        return this.baseCorrecaoMonetaria;
    }

    @Generated
    public BaseJurosCorrecao getBaseJuros() {
        return this.baseJuros;
    }

    @Generated
    public BaseMultaCorrecao getBaseMulta() {
        return this.baseMulta;
    }

    @Generated
    public List<EntidadeCorrecaoMulta> getCorrecaoMulta() {
        return this.correcaoMulta;
    }

    @Generated
    public List<EntidadeCorrecaoMultaEspecial> getCorrecaoMultaEspecial() {
        return this.correcaoMultaEspecial;
    }

    @Generated
    public List<EntidadeCorrecaoDivida> getEntidadeCorrecaoDivida() {
        return this.entidadeCorrecaoDivida;
    }

    @Generated
    public EntidadeCorrecaoIndiceMulta getEntidadeCorrecaoIndiceMulta() {
        return this.entidadeCorrecaoIndiceMulta;
    }

    @Generated
    public EntidadeCorrecaoIndiceCorrecao getEntidadeCorrecaoIndiceCorrecao() {
        return this.entidadeCorrecaoIndiceCorrecao;
    }

    @Generated
    public EntidadeCorrecaoIndiceJuros getEntidadeCorrecaoIndiceJuros() {
        return this.entidadeCorrecaoIndiceJuros;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setMultaEspecial(Boolean multaEspecial) {
        this.multaEspecial = multaEspecial;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setSobreporMulta(Boolean sobreporMulta) {
        this.sobreporMulta = sobreporMulta;
    }

    @Generated
    public void setArredondaPorPartesNoCalculo(Boolean arredondaPorPartesNoCalculo) {
        this.arredondaPorPartesNoCalculo = arredondaPorPartesNoCalculo;
    }

    @Generated
    public void setUtilizaCorrecaoEspecial(Boolean utilizaCorrecaoEspecial) {
        this.utilizaCorrecaoEspecial = utilizaCorrecaoEspecial;
    }

    @Generated
    public void setFormaCorrecao(FormaCorrecao formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setCorrecaoEspecial(FormaCorrecao correcaoEspecial) {
        this.correcaoEspecial = correcaoEspecial;
    }

    @Generated
    public void setUnidadeFiscal(BigDecimal unidadeFiscal) {
        this.unidadeFiscal = unidadeFiscal;
    }

    @Generated
    public void setJuroMora(BigDecimal juroMora) {
        this.juroMora = juroMora;
    }

    @Generated
    public void setMultaDias(MultaDiasCorrecao multaDias) {
        this.multaDias = multaDias;
    }

    @Generated
    public void setMesJuros(TipoJuros mesJuros) {
        this.mesJuros = mesJuros;
    }

    @Generated
    public void setBaseCorrecaoMonetaria(BaseCorrecaoMonetaria baseCorrecaoMonetaria) {
        this.baseCorrecaoMonetaria = baseCorrecaoMonetaria;
    }

    @Generated
    public void setBaseJuros(BaseJurosCorrecao baseJuros) {
        this.baseJuros = baseJuros;
    }

    @Generated
    public void setBaseMulta(BaseMultaCorrecao baseMulta) {
        this.baseMulta = baseMulta;
    }

    @Generated
    public void setCorrecaoMulta(List<EntidadeCorrecaoMulta> correcaoMulta) {
        this.correcaoMulta = correcaoMulta;
    }

    @Generated
    public void setCorrecaoMultaEspecial(List<EntidadeCorrecaoMultaEspecial> correcaoMultaEspecial) {
        this.correcaoMultaEspecial = correcaoMultaEspecial;
    }

    @Generated
    public void setEntidadeCorrecaoDivida(List<EntidadeCorrecaoDivida> entidadeCorrecaoDivida) {
        this.entidadeCorrecaoDivida = entidadeCorrecaoDivida;
    }

    @Generated
    public void setEntidadeCorrecaoIndiceMulta(EntidadeCorrecaoIndiceMulta entidadeCorrecaoIndiceMulta) {
        this.entidadeCorrecaoIndiceMulta = entidadeCorrecaoIndiceMulta;
    }

    @Generated
    public void setEntidadeCorrecaoIndiceCorrecao(EntidadeCorrecaoIndiceCorrecao entidadeCorrecaoIndiceCorrecao) {
        this.entidadeCorrecaoIndiceCorrecao = entidadeCorrecaoIndiceCorrecao;
    }

    @Generated
    public void setEntidadeCorrecaoIndiceJuros(EntidadeCorrecaoIndiceJuros entidadeCorrecaoIndiceJuros) {
        this.entidadeCorrecaoIndiceJuros = entidadeCorrecaoIndiceJuros;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntidadeCorrecaoDTO)) {
            return false;
        }
        EntidadeCorrecaoDTO other = (EntidadeCorrecaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$sequencia = this.getSequencia();
        Long other$sequencia = other.getSequencia();
        if (this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia)) {
            return false;
        }
        Boolean this$multaEspecial = this.getMultaEspecial();
        Boolean other$multaEspecial = other.getMultaEspecial();
        if (this$multaEspecial == null ? other$multaEspecial != null : !((Object)this$multaEspecial).equals(other$multaEspecial)) {
            return false;
        }
        Boolean this$principal = this.getPrincipal();
        Boolean other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !((Object)this$principal).equals(other$principal)) {
            return false;
        }
        Boolean this$sobreporMulta = this.getSobreporMulta();
        Boolean other$sobreporMulta = other.getSobreporMulta();
        if (this$sobreporMulta == null ? other$sobreporMulta != null : !((Object)this$sobreporMulta).equals(other$sobreporMulta)) {
            return false;
        }
        Boolean this$arredondaPorPartesNoCalculo = this.getArredondaPorPartesNoCalculo();
        Boolean other$arredondaPorPartesNoCalculo = other.getArredondaPorPartesNoCalculo();
        if (this$arredondaPorPartesNoCalculo == null ? other$arredondaPorPartesNoCalculo != null : !((Object)this$arredondaPorPartesNoCalculo).equals(other$arredondaPorPartesNoCalculo)) {
            return false;
        }
        Boolean this$utilizaCorrecaoEspecial = this.getUtilizaCorrecaoEspecial();
        Boolean other$utilizaCorrecaoEspecial = other.getUtilizaCorrecaoEspecial();
        if (this$utilizaCorrecaoEspecial == null ? other$utilizaCorrecaoEspecial != null : !((Object)this$utilizaCorrecaoEspecial).equals(other$utilizaCorrecaoEspecial)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        FormaCorrecao this$formaCorrecao = this.getFormaCorrecao();
        FormaCorrecao other$formaCorrecao = other.getFormaCorrecao();
        if (this$formaCorrecao == null ? other$formaCorrecao != null : !this$formaCorrecao.equals(other$formaCorrecao)) {
            return false;
        }
        FormaCorrecao this$correcaoEspecial = this.getCorrecaoEspecial();
        FormaCorrecao other$correcaoEspecial = other.getCorrecaoEspecial();
        if (this$correcaoEspecial == null ? other$correcaoEspecial != null : !this$correcaoEspecial.equals(other$correcaoEspecial)) {
            return false;
        }
        BigDecimal this$unidadeFiscal = this.getUnidadeFiscal();
        BigDecimal other$unidadeFiscal = other.getUnidadeFiscal();
        if (this$unidadeFiscal == null ? other$unidadeFiscal != null : !((Object)this$unidadeFiscal).equals(other$unidadeFiscal)) {
            return false;
        }
        BigDecimal this$juroMora = this.getJuroMora();
        BigDecimal other$juroMora = other.getJuroMora();
        if (this$juroMora == null ? other$juroMora != null : !((Object)this$juroMora).equals(other$juroMora)) {
            return false;
        }
        MultaDiasCorrecao this$multaDias = this.getMultaDias();
        MultaDiasCorrecao other$multaDias = other.getMultaDias();
        if (this$multaDias == null ? other$multaDias != null : !this$multaDias.equals(other$multaDias)) {
            return false;
        }
        TipoJuros this$mesJuros = this.getMesJuros();
        TipoJuros other$mesJuros = other.getMesJuros();
        if (this$mesJuros == null ? other$mesJuros != null : !this$mesJuros.equals(other$mesJuros)) {
            return false;
        }
        BaseCorrecaoMonetaria this$baseCorrecaoMonetaria = this.getBaseCorrecaoMonetaria();
        BaseCorrecaoMonetaria other$baseCorrecaoMonetaria = other.getBaseCorrecaoMonetaria();
        if (this$baseCorrecaoMonetaria == null ? other$baseCorrecaoMonetaria != null : !this$baseCorrecaoMonetaria.equals(other$baseCorrecaoMonetaria)) {
            return false;
        }
        BaseJurosCorrecao this$baseJuros = this.getBaseJuros();
        BaseJurosCorrecao other$baseJuros = other.getBaseJuros();
        if (this$baseJuros == null ? other$baseJuros != null : !this$baseJuros.equals(other$baseJuros)) {
            return false;
        }
        BaseMultaCorrecao this$baseMulta = this.getBaseMulta();
        BaseMultaCorrecao other$baseMulta = other.getBaseMulta();
        if (this$baseMulta == null ? other$baseMulta != null : !this$baseMulta.equals(other$baseMulta)) {
            return false;
        }
        List this$correcaoMulta = this.getCorrecaoMulta();
        List other$correcaoMulta = other.getCorrecaoMulta();
        if (this$correcaoMulta == null ? other$correcaoMulta != null : !((Object)this$correcaoMulta).equals(other$correcaoMulta)) {
            return false;
        }
        List this$correcaoMultaEspecial = this.getCorrecaoMultaEspecial();
        List other$correcaoMultaEspecial = other.getCorrecaoMultaEspecial();
        if (this$correcaoMultaEspecial == null ? other$correcaoMultaEspecial != null : !((Object)this$correcaoMultaEspecial).equals(other$correcaoMultaEspecial)) {
            return false;
        }
        List this$entidadeCorrecaoDivida = this.getEntidadeCorrecaoDivida();
        List other$entidadeCorrecaoDivida = other.getEntidadeCorrecaoDivida();
        if (this$entidadeCorrecaoDivida == null ? other$entidadeCorrecaoDivida != null : !((Object)this$entidadeCorrecaoDivida).equals(other$entidadeCorrecaoDivida)) {
            return false;
        }
        EntidadeCorrecaoIndiceMulta this$entidadeCorrecaoIndiceMulta = this.getEntidadeCorrecaoIndiceMulta();
        EntidadeCorrecaoIndiceMulta other$entidadeCorrecaoIndiceMulta = other.getEntidadeCorrecaoIndiceMulta();
        if (this$entidadeCorrecaoIndiceMulta == null ? other$entidadeCorrecaoIndiceMulta != null : !this$entidadeCorrecaoIndiceMulta.equals(other$entidadeCorrecaoIndiceMulta)) {
            return false;
        }
        EntidadeCorrecaoIndiceCorrecao this$entidadeCorrecaoIndiceCorrecao = this.getEntidadeCorrecaoIndiceCorrecao();
        EntidadeCorrecaoIndiceCorrecao other$entidadeCorrecaoIndiceCorrecao = other.getEntidadeCorrecaoIndiceCorrecao();
        if (this$entidadeCorrecaoIndiceCorrecao == null ? other$entidadeCorrecaoIndiceCorrecao != null : !this$entidadeCorrecaoIndiceCorrecao.equals(other$entidadeCorrecaoIndiceCorrecao)) {
            return false;
        }
        EntidadeCorrecaoIndiceJuros this$entidadeCorrecaoIndiceJuros = this.getEntidadeCorrecaoIndiceJuros();
        EntidadeCorrecaoIndiceJuros other$entidadeCorrecaoIndiceJuros = other.getEntidadeCorrecaoIndiceJuros();
        return !(this$entidadeCorrecaoIndiceJuros == null ? other$entidadeCorrecaoIndiceJuros != null : !this$entidadeCorrecaoIndiceJuros.equals(other$entidadeCorrecaoIndiceJuros));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntidadeCorrecaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        Boolean $multaEspecial = this.getMultaEspecial();
        result = result * 59 + ($multaEspecial == null ? 43 : ((Object)$multaEspecial).hashCode());
        Boolean $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : ((Object)$principal).hashCode());
        Boolean $sobreporMulta = this.getSobreporMulta();
        result = result * 59 + ($sobreporMulta == null ? 43 : ((Object)$sobreporMulta).hashCode());
        Boolean $arredondaPorPartesNoCalculo = this.getArredondaPorPartesNoCalculo();
        result = result * 59 + ($arredondaPorPartesNoCalculo == null ? 43 : ((Object)$arredondaPorPartesNoCalculo).hashCode());
        Boolean $utilizaCorrecaoEspecial = this.getUtilizaCorrecaoEspecial();
        result = result * 59 + ($utilizaCorrecaoEspecial == null ? 43 : ((Object)$utilizaCorrecaoEspecial).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        FormaCorrecao $formaCorrecao = this.getFormaCorrecao();
        result = result * 59 + ($formaCorrecao == null ? 43 : $formaCorrecao.hashCode());
        FormaCorrecao $correcaoEspecial = this.getCorrecaoEspecial();
        result = result * 59 + ($correcaoEspecial == null ? 43 : $correcaoEspecial.hashCode());
        BigDecimal $unidadeFiscal = this.getUnidadeFiscal();
        result = result * 59 + ($unidadeFiscal == null ? 43 : ((Object)$unidadeFiscal).hashCode());
        BigDecimal $juroMora = this.getJuroMora();
        result = result * 59 + ($juroMora == null ? 43 : ((Object)$juroMora).hashCode());
        MultaDiasCorrecao $multaDias = this.getMultaDias();
        result = result * 59 + ($multaDias == null ? 43 : $multaDias.hashCode());
        TipoJuros $mesJuros = this.getMesJuros();
        result = result * 59 + ($mesJuros == null ? 43 : $mesJuros.hashCode());
        BaseCorrecaoMonetaria $baseCorrecaoMonetaria = this.getBaseCorrecaoMonetaria();
        result = result * 59 + ($baseCorrecaoMonetaria == null ? 43 : $baseCorrecaoMonetaria.hashCode());
        BaseJurosCorrecao $baseJuros = this.getBaseJuros();
        result = result * 59 + ($baseJuros == null ? 43 : $baseJuros.hashCode());
        BaseMultaCorrecao $baseMulta = this.getBaseMulta();
        result = result * 59 + ($baseMulta == null ? 43 : $baseMulta.hashCode());
        List $correcaoMulta = this.getCorrecaoMulta();
        result = result * 59 + ($correcaoMulta == null ? 43 : ((Object)$correcaoMulta).hashCode());
        List $correcaoMultaEspecial = this.getCorrecaoMultaEspecial();
        result = result * 59 + ($correcaoMultaEspecial == null ? 43 : ((Object)$correcaoMultaEspecial).hashCode());
        List $entidadeCorrecaoDivida = this.getEntidadeCorrecaoDivida();
        result = result * 59 + ($entidadeCorrecaoDivida == null ? 43 : ((Object)$entidadeCorrecaoDivida).hashCode());
        EntidadeCorrecaoIndiceMulta $entidadeCorrecaoIndiceMulta = this.getEntidadeCorrecaoIndiceMulta();
        result = result * 59 + ($entidadeCorrecaoIndiceMulta == null ? 43 : $entidadeCorrecaoIndiceMulta.hashCode());
        EntidadeCorrecaoIndiceCorrecao $entidadeCorrecaoIndiceCorrecao = this.getEntidadeCorrecaoIndiceCorrecao();
        result = result * 59 + ($entidadeCorrecaoIndiceCorrecao == null ? 43 : $entidadeCorrecaoIndiceCorrecao.hashCode());
        EntidadeCorrecaoIndiceJuros $entidadeCorrecaoIndiceJuros = this.getEntidadeCorrecaoIndiceJuros();
        result = result * 59 + ($entidadeCorrecaoIndiceJuros == null ? 43 : $entidadeCorrecaoIndiceJuros.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntidadeCorrecaoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", sequencia=" + this.getSequencia() + ")";
    }
}

