/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.parcelamento;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.SituacaoParcelamento;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.parcelamento.FormaCobrancaJurosParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoDescontoDivida;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoDescontoParcela;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoEntrada;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoOutrasTaxas;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoParcelaPorValor;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoParcelaSituacao;
import br.com.elotech.tributos.domain.parcelamento.ParcelamentoTipoDesconto;
import br.com.elotech.tributos.domain.parcelamento.TipoParcelamento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.dto.ParamParcelamentoDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.validator.constraints.Length;
import org.springframework.util.CollectionUtils;

@Entity
@Table(name="TRIBPARAMPARCELAMENTO")
public class ParamParcelamento
implements EloEntity<Long>,
Serializable {
    private static final Long ACRESCIMO_DE_SEQUENCIA = 1L;
    @Id
    @EloSequence(sequenceName="S05IDPARAMETROPARCELAMENTO")
    @Column(name="idparametroparcelamento")
    private Long id;
    private TipoParcelamento tipo = TipoParcelamento.PARCELAMENTO;
    @Column(name="descricao")
    @Length(max=250)
    @NotNull
    private @Length(max=250) @NotNull String descricao;
    @ManyToOne
    @JoinColumn(name="motivodesconto", referencedColumnName="motivodesconto")
    private MotivoDeducao motivoDeducao;
    @ManyToOne
    @JoinColumn
    private FormaCorrecao formaCorrecao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="fundamentolegal", referencedColumnName="idato"))})
    private Ato ato;
    private Long numeroParcela;
    private Long numeroParcelaRequerimento;
    @Column(name="numeroparcelaporsituacao")
    private Boolean numeroParcelaSituacao;
    @Column(name="numeroparcelaporvalor")
    private Boolean numeroParcelaValor;
    private Boolean cobraExpediente;
    private Long entidade;
    private Long exercicio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaexpediente", referencedColumnName="receita"))})
    private Tributo taxaExpediente;
    private BigDecimal valorExpediente = BigDecimal.ZERO;
    private BigDecimal valorMinimoParcela = BigDecimal.ZERO;
    private ParcelamentoTipoDesconto tipoDesconto;
    private FormaCobrancaJurosParcelamento tipoJurosFinanciamento;
    @NotBlank
    @Length(max=4000)
    private @NotBlank @Length(max=4000) String filtroDebito;
    @Column(name="jurosFinanSobreCorrecao")
    private Boolean jurosFinanciamentoSobreCorrecao;
    @Column(name="jurosFinanSobreJuros")
    private Boolean jurosFinanciamentoSobreJuros;
    @Column(name="jurosFinanSobreMulta")
    private Boolean jurosFinanciamentoSobreMulta;
    @Column(name="jurosFinanSobrePrincipal")
    private Boolean jurosFinanciamentoSobrePrincipal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaJurosFinan", referencedColumnName="receita"))})
    private Tributo tributoJurosFinanciamento;
    @Column(name="taxaUnicaJurosFinan")
    private BigDecimal taxaUnicaJurosFinanciamento = BigDecimal.ZERO;
    private Boolean entradaValorIgual;
    @NotFound(action=NotFoundAction.IGNORE)
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="'05'", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="tiporelatorio", referencedColumnName="tiporelatorio")), @JoinColumnOrFormula(column=@JoinColumn(name="relatorio", referencedColumnName="relatorio"))})
    private Relatorio relatorio;
    @Column(name="sequenciaemissao")
    private Long sequenciaEmissaoRelatorio;
    private BigDecimal descontoPrincipal = BigDecimal.ZERO;
    private BigDecimal descontoJuros = BigDecimal.ZERO;
    private BigDecimal descontoMulta = BigDecimal.ZERO;
    private BigDecimal descontoCorrecao = BigDecimal.ZERO;
    private Boolean desativado = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaDesconto", referencedColumnName="receita"))})
    private Tributo tributoDesconto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaDescontoJuros", referencedColumnName="receita"))})
    private Tributo tributoDescontoJuros;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaDescontoMulta", referencedColumnName="receita"))})
    private Tributo tributoDescontoMulta;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="receitaDescontoCorrecao", referencedColumnName="receita"))})
    private Tributo tributoDescontoCorrecao;
    @NotFound(action=NotFoundAction.IGNORE)
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="'05'", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="tipoRelatorioBloqueto", referencedColumnName="tiporelatorio")), @JoinColumnOrFormula(column=@JoinColumn(name="relatorioBloqueto", referencedColumnName="relatorio"))})
    private Relatorio relatorioBoleto;
    private Boolean parcelamentoIndividual;
    @Column(name="descontopagtoavista")
    private BigDecimal descontoPagamVista = BigDecimal.ZERO;
    @ManyToOne
    @JoinColumn(name="motivodescontoquitacao", referencedColumnName="motivodesconto")
    private MotivoDeducao motivoDeducaoQuitacao;
    @NotFound(action=NotFoundAction.IGNORE)
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="'05'", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="tipoRelatorioBloquetoCarne", referencedColumnName="tiporelatorio")), @JoinColumnOrFormula(column=@JoinColumn(name="relatorioBloquetoCarne", referencedColumnName="relatorio"))})
    private Relatorio relatorioCarne;
    @NotFound(action=NotFoundAction.IGNORE)
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="'05'", referencedColumnName="modulo")), @JoinColumnOrFormula(column=@JoinColumn(name="tipoRelatorioSimulacao", referencedColumnName="tiporelatorio")), @JoinColumnOrFormula(column=@JoinColumn(name="relatorioSimulacao", referencedColumnName="relatorio"))})
    private Relatorio relatorioSimulacao;
    private Boolean utilizaSac;
    @ManyToOne
    @JoinColumn(name="motivoestorno", referencedColumnName="motivodesconto")
    private MotivoDeducao motivoEstorno;
    private Long numeroParcelasVencidas;
    @ManyToOne
    @JoinColumn
    private FormaPagamento formaPagamento;
    private Boolean utilizaExercicioLogado;
    @ManyToOne
    @JoinColumn(name="motivoDescontoFinan", referencedColumnName="motivodesconto")
    private MotivoDeducao motivoDeducaoFinanciamento;
    private Boolean bloqueioJudicial;
    @ManyToOne
    @JoinColumn
    private SituacaoParcelamento situacao;
    @ManyToOne
    @JoinColumn(name="modelobloqueto")
    private ModeloBoleto modeloBoleto;
    private Long dataVencimento;
    private Boolean disponivelCidadao;
    @Length(max=4000)
    private @Length(max=4000) String termoConfissaoDivida;
    @Column(name="inscrevedebitosda")
    private Boolean inscreveDebitosDa;
    @OneToMany(mappedBy="id.parametroParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoEntrada> entradas = new ArrayList();
    @OneToMany(mappedBy="id.parametroParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoParcelaSituacao> parcelasSituacao = new ArrayList();
    @OneToMany(mappedBy="id.parametroParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoParcelaPorValor> parcelasPorValor = new ArrayList();
    @OneToMany(mappedBy="id.parametroParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoDescontoParcela> descontosPorParcela = new ArrayList();
    @OneToMany(mappedBy="parametroParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoDescontoDivida> descontosPorDivida = new ArrayList();
    @OneToMany(mappedBy="paramParcelamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ParamParcelamentoOutrasTaxas> outrasTaxas = new ArrayList();
    @Column(name="valorMinimoParcelamento")
    private BigDecimal valorMinimoParcelamento = BigDecimal.ZERO;
    @Column(name="porcontribuinte")
    private Boolean porContribuinte;

    public Long getNumeroProximaEntrada() {
        return this.getEntradas().stream().map(entrada -> {
            if (entrada.getId() == null || entrada.getId() != null && entrada.getId().getEntrada() == null) {
                return 0L;
            }
            return entrada.getId().getEntrada();
        }).reduce(Long::max).orElse(0L) + ACRESCIMO_DE_SEQUENCIA;
    }

    public Long getSequenciaProximoDescontoPorParcela() {
        return this.getDescontosPorParcela().stream().map(desconto -> {
            if (desconto.getId() == null || desconto.getId() != null && desconto.getId().getSequencia() == null) {
                return 0L;
            }
            return desconto.getId().getSequencia();
        }).reduce(Long::max).orElse(0L) + ACRESCIMO_DE_SEQUENCIA;
    }

    public List<ParamParcelamentoParcelaSituacao> getParcelasSituacao() {
        if (!CollectionUtils.isEmpty((Collection)this.parcelasSituacao)) {
            Collections.sort(this.parcelasSituacao);
        }
        return this.parcelasSituacao;
    }

    public ParamParcelamentoDTO toDto() {
        ParamParcelamentoDTO dto = new ParamParcelamentoDTO();
        dto.setId(this.getId());
        dto.setDescricao(this.getDescricao());
        dto.setDisponivelCidadao(this.getDisponivelCidadao());
        dto.setTermoConfissaoDivida(this.getTermoConfissaoDivida());
        dto.setAtivo(this.getAtivo());
        return dto;
    }

    public Boolean getAtivo() {
        return this.getDesativado() == false;
    }

    public void setAtivo(Boolean ativo) {
        this.setDesativado(Boolean.valueOf(ativo == false));
    }

    @Generated
    public ParamParcelamento() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoParcelamento getTipo() {
        return this.tipo;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public MotivoDeducao getMotivoDeducao() {
        return this.motivoDeducao;
    }

    @Generated
    public FormaCorrecao getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public Ato getAto() {
        return this.ato;
    }

    @Generated
    public Long getNumeroParcela() {
        return this.numeroParcela;
    }

    @Generated
    public Long getNumeroParcelaRequerimento() {
        return this.numeroParcelaRequerimento;
    }

    @Generated
    public Boolean getNumeroParcelaSituacao() {
        return this.numeroParcelaSituacao;
    }

    @Generated
    public Boolean getNumeroParcelaValor() {
        return this.numeroParcelaValor;
    }

    @Generated
    public Boolean getCobraExpediente() {
        return this.cobraExpediente;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Tributo getTaxaExpediente() {
        return this.taxaExpediente;
    }

    @Generated
    public BigDecimal getValorExpediente() {
        return this.valorExpediente;
    }

    @Generated
    public BigDecimal getValorMinimoParcela() {
        return this.valorMinimoParcela;
    }

    @Generated
    public ParcelamentoTipoDesconto getTipoDesconto() {
        return this.tipoDesconto;
    }

    @Generated
    public FormaCobrancaJurosParcelamento getTipoJurosFinanciamento() {
        return this.tipoJurosFinanciamento;
    }

    @Generated
    public String getFiltroDebito() {
        return this.filtroDebito;
    }

    @Generated
    public Boolean getJurosFinanciamentoSobreCorrecao() {
        return this.jurosFinanciamentoSobreCorrecao;
    }

    @Generated
    public Boolean getJurosFinanciamentoSobreJuros() {
        return this.jurosFinanciamentoSobreJuros;
    }

    @Generated
    public Boolean getJurosFinanciamentoSobreMulta() {
        return this.jurosFinanciamentoSobreMulta;
    }

    @Generated
    public Boolean getJurosFinanciamentoSobrePrincipal() {
        return this.jurosFinanciamentoSobrePrincipal;
    }

    @Generated
    public Tributo getTributoJurosFinanciamento() {
        return this.tributoJurosFinanciamento;
    }

    @Generated
    public BigDecimal getTaxaUnicaJurosFinanciamento() {
        return this.taxaUnicaJurosFinanciamento;
    }

    @Generated
    public Boolean getEntradaValorIgual() {
        return this.entradaValorIgual;
    }

    @Generated
    public Relatorio getRelatorio() {
        return this.relatorio;
    }

    @Generated
    public Long getSequenciaEmissaoRelatorio() {
        return this.sequenciaEmissaoRelatorio;
    }

    @Generated
    public BigDecimal getDescontoPrincipal() {
        return this.descontoPrincipal;
    }

    @Generated
    public BigDecimal getDescontoJuros() {
        return this.descontoJuros;
    }

    @Generated
    public BigDecimal getDescontoMulta() {
        return this.descontoMulta;
    }

    @Generated
    public BigDecimal getDescontoCorrecao() {
        return this.descontoCorrecao;
    }

    @Generated
    public Boolean getDesativado() {
        return this.desativado;
    }

    @Generated
    public Tributo getTributoDesconto() {
        return this.tributoDesconto;
    }

    @Generated
    public Tributo getTributoDescontoJuros() {
        return this.tributoDescontoJuros;
    }

    @Generated
    public Tributo getTributoDescontoMulta() {
        return this.tributoDescontoMulta;
    }

    @Generated
    public Tributo getTributoDescontoCorrecao() {
        return this.tributoDescontoCorrecao;
    }

    @Generated
    public Relatorio getRelatorioBoleto() {
        return this.relatorioBoleto;
    }

    @Generated
    public Boolean getParcelamentoIndividual() {
        return this.parcelamentoIndividual;
    }

    @Generated
    public BigDecimal getDescontoPagamVista() {
        return this.descontoPagamVista;
    }

    @Generated
    public MotivoDeducao getMotivoDeducaoQuitacao() {
        return this.motivoDeducaoQuitacao;
    }

    @Generated
    public Relatorio getRelatorioCarne() {
        return this.relatorioCarne;
    }

    @Generated
    public Relatorio getRelatorioSimulacao() {
        return this.relatorioSimulacao;
    }

    @Generated
    public Boolean getUtilizaSac() {
        return this.utilizaSac;
    }

    @Generated
    public MotivoDeducao getMotivoEstorno() {
        return this.motivoEstorno;
    }

    @Generated
    public Long getNumeroParcelasVencidas() {
        return this.numeroParcelasVencidas;
    }

    @Generated
    public FormaPagamento getFormaPagamento() {
        return this.formaPagamento;
    }

    @Generated
    public Boolean getUtilizaExercicioLogado() {
        return this.utilizaExercicioLogado;
    }

    @Generated
    public MotivoDeducao getMotivoDeducaoFinanciamento() {
        return this.motivoDeducaoFinanciamento;
    }

    @Generated
    public Boolean getBloqueioJudicial() {
        return this.bloqueioJudicial;
    }

    @Generated
    public SituacaoParcelamento getSituacao() {
        return this.situacao;
    }

    @Generated
    public ModeloBoleto getModeloBoleto() {
        return this.modeloBoleto;
    }

    @Generated
    public Long getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public Boolean getDisponivelCidadao() {
        return this.disponivelCidadao;
    }

    @Generated
    public String getTermoConfissaoDivida() {
        return this.termoConfissaoDivida;
    }

    @Generated
    public Boolean getInscreveDebitosDa() {
        return this.inscreveDebitosDa;
    }

    @Generated
    public List<ParamParcelamentoEntrada> getEntradas() {
        return this.entradas;
    }

    @Generated
    public List<ParamParcelamentoParcelaPorValor> getParcelasPorValor() {
        return this.parcelasPorValor;
    }

    @Generated
    public List<ParamParcelamentoDescontoParcela> getDescontosPorParcela() {
        return this.descontosPorParcela;
    }

    @Generated
    public List<ParamParcelamentoDescontoDivida> getDescontosPorDivida() {
        return this.descontosPorDivida;
    }

    @Generated
    public List<ParamParcelamentoOutrasTaxas> getOutrasTaxas() {
        return this.outrasTaxas;
    }

    @Generated
    public BigDecimal getValorMinimoParcelamento() {
        return this.valorMinimoParcelamento;
    }

    @Generated
    public Boolean getPorContribuinte() {
        return this.porContribuinte;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipo(TipoParcelamento tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setMotivoDeducao(MotivoDeducao motivoDeducao) {
        this.motivoDeducao = motivoDeducao;
    }

    @Generated
    public void setFormaCorrecao(FormaCorrecao formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setAto(Ato ato) {
        this.ato = ato;
    }

    @Generated
    public void setNumeroParcela(Long numeroParcela) {
        this.numeroParcela = numeroParcela;
    }

    @Generated
    public void setNumeroParcelaRequerimento(Long numeroParcelaRequerimento) {
        this.numeroParcelaRequerimento = numeroParcelaRequerimento;
    }

    @Generated
    public void setNumeroParcelaSituacao(Boolean numeroParcelaSituacao) {
        this.numeroParcelaSituacao = numeroParcelaSituacao;
    }

    @Generated
    public void setNumeroParcelaValor(Boolean numeroParcelaValor) {
        this.numeroParcelaValor = numeroParcelaValor;
    }

    @Generated
    public void setCobraExpediente(Boolean cobraExpediente) {
        this.cobraExpediente = cobraExpediente;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTaxaExpediente(Tributo taxaExpediente) {
        this.taxaExpediente = taxaExpediente;
    }

    @Generated
    public void setValorExpediente(BigDecimal valorExpediente) {
        this.valorExpediente = valorExpediente;
    }

    @Generated
    public void setValorMinimoParcela(BigDecimal valorMinimoParcela) {
        this.valorMinimoParcela = valorMinimoParcela;
    }

    @Generated
    public void setTipoDesconto(ParcelamentoTipoDesconto tipoDesconto) {
        this.tipoDesconto = tipoDesconto;
    }

    @Generated
    public void setTipoJurosFinanciamento(FormaCobrancaJurosParcelamento tipoJurosFinanciamento) {
        this.tipoJurosFinanciamento = tipoJurosFinanciamento;
    }

    @Generated
    public void setFiltroDebito(String filtroDebito) {
        this.filtroDebito = filtroDebito;
    }

    @Generated
    public void setJurosFinanciamentoSobreCorrecao(Boolean jurosFinanciamentoSobreCorrecao) {
        this.jurosFinanciamentoSobreCorrecao = jurosFinanciamentoSobreCorrecao;
    }

    @Generated
    public void setJurosFinanciamentoSobreJuros(Boolean jurosFinanciamentoSobreJuros) {
        this.jurosFinanciamentoSobreJuros = jurosFinanciamentoSobreJuros;
    }

    @Generated
    public void setJurosFinanciamentoSobreMulta(Boolean jurosFinanciamentoSobreMulta) {
        this.jurosFinanciamentoSobreMulta = jurosFinanciamentoSobreMulta;
    }

    @Generated
    public void setJurosFinanciamentoSobrePrincipal(Boolean jurosFinanciamentoSobrePrincipal) {
        this.jurosFinanciamentoSobrePrincipal = jurosFinanciamentoSobrePrincipal;
    }

    @Generated
    public void setTributoJurosFinanciamento(Tributo tributoJurosFinanciamento) {
        this.tributoJurosFinanciamento = tributoJurosFinanciamento;
    }

    @Generated
    public void setTaxaUnicaJurosFinanciamento(BigDecimal taxaUnicaJurosFinanciamento) {
        this.taxaUnicaJurosFinanciamento = taxaUnicaJurosFinanciamento;
    }

    @Generated
    public void setEntradaValorIgual(Boolean entradaValorIgual) {
        this.entradaValorIgual = entradaValorIgual;
    }

    @Generated
    public void setRelatorio(Relatorio relatorio) {
        this.relatorio = relatorio;
    }

    @Generated
    public void setSequenciaEmissaoRelatorio(Long sequenciaEmissaoRelatorio) {
        this.sequenciaEmissaoRelatorio = sequenciaEmissaoRelatorio;
    }

    @Generated
    public void setDescontoPrincipal(BigDecimal descontoPrincipal) {
        this.descontoPrincipal = descontoPrincipal;
    }

    @Generated
    public void setDescontoJuros(BigDecimal descontoJuros) {
        this.descontoJuros = descontoJuros;
    }

    @Generated
    public void setDescontoMulta(BigDecimal descontoMulta) {
        this.descontoMulta = descontoMulta;
    }

    @Generated
    public void setDescontoCorrecao(BigDecimal descontoCorrecao) {
        this.descontoCorrecao = descontoCorrecao;
    }

    @Generated
    public void setDesativado(Boolean desativado) {
        this.desativado = desativado;
    }

    @Generated
    public void setTributoDesconto(Tributo tributoDesconto) {
        this.tributoDesconto = tributoDesconto;
    }

    @Generated
    public void setTributoDescontoJuros(Tributo tributoDescontoJuros) {
        this.tributoDescontoJuros = tributoDescontoJuros;
    }

    @Generated
    public void setTributoDescontoMulta(Tributo tributoDescontoMulta) {
        this.tributoDescontoMulta = tributoDescontoMulta;
    }

    @Generated
    public void setTributoDescontoCorrecao(Tributo tributoDescontoCorrecao) {
        this.tributoDescontoCorrecao = tributoDescontoCorrecao;
    }

    @Generated
    public void setRelatorioBoleto(Relatorio relatorioBoleto) {
        this.relatorioBoleto = relatorioBoleto;
    }

    @Generated
    public void setParcelamentoIndividual(Boolean parcelamentoIndividual) {
        this.parcelamentoIndividual = parcelamentoIndividual;
    }

    @Generated
    public void setDescontoPagamVista(BigDecimal descontoPagamVista) {
        this.descontoPagamVista = descontoPagamVista;
    }

    @Generated
    public void setMotivoDeducaoQuitacao(MotivoDeducao motivoDeducaoQuitacao) {
        this.motivoDeducaoQuitacao = motivoDeducaoQuitacao;
    }

    @Generated
    public void setRelatorioCarne(Relatorio relatorioCarne) {
        this.relatorioCarne = relatorioCarne;
    }

    @Generated
    public void setRelatorioSimulacao(Relatorio relatorioSimulacao) {
        this.relatorioSimulacao = relatorioSimulacao;
    }

    @Generated
    public void setUtilizaSac(Boolean utilizaSac) {
        this.utilizaSac = utilizaSac;
    }

    @Generated
    public void setMotivoEstorno(MotivoDeducao motivoEstorno) {
        this.motivoEstorno = motivoEstorno;
    }

    @Generated
    public void setNumeroParcelasVencidas(Long numeroParcelasVencidas) {
        this.numeroParcelasVencidas = numeroParcelasVencidas;
    }

    @Generated
    public void setFormaPagamento(FormaPagamento formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Generated
    public void setUtilizaExercicioLogado(Boolean utilizaExercicioLogado) {
        this.utilizaExercicioLogado = utilizaExercicioLogado;
    }

    @Generated
    public void setMotivoDeducaoFinanciamento(MotivoDeducao motivoDeducaoFinanciamento) {
        this.motivoDeducaoFinanciamento = motivoDeducaoFinanciamento;
    }

    @Generated
    public void setBloqueioJudicial(Boolean bloqueioJudicial) {
        this.bloqueioJudicial = bloqueioJudicial;
    }

    @Generated
    public void setSituacao(SituacaoParcelamento situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setModeloBoleto(ModeloBoleto modeloBoleto) {
        this.modeloBoleto = modeloBoleto;
    }

    @Generated
    public void setDataVencimento(Long dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setDisponivelCidadao(Boolean disponivelCidadao) {
        this.disponivelCidadao = disponivelCidadao;
    }

    @Generated
    public void setTermoConfissaoDivida(String termoConfissaoDivida) {
        this.termoConfissaoDivida = termoConfissaoDivida;
    }

    @Generated
    public void setInscreveDebitosDa(Boolean inscreveDebitosDa) {
        this.inscreveDebitosDa = inscreveDebitosDa;
    }

    @Generated
    public void setEntradas(List<ParamParcelamentoEntrada> entradas) {
        this.entradas = entradas;
    }

    @Generated
    public void setParcelasSituacao(List<ParamParcelamentoParcelaSituacao> parcelasSituacao) {
        this.parcelasSituacao = parcelasSituacao;
    }

    @Generated
    public void setParcelasPorValor(List<ParamParcelamentoParcelaPorValor> parcelasPorValor) {
        this.parcelasPorValor = parcelasPorValor;
    }

    @Generated
    public void setDescontosPorParcela(List<ParamParcelamentoDescontoParcela> descontosPorParcela) {
        this.descontosPorParcela = descontosPorParcela;
    }

    @Generated
    public void setDescontosPorDivida(List<ParamParcelamentoDescontoDivida> descontosPorDivida) {
        this.descontosPorDivida = descontosPorDivida;
    }

    @Generated
    public void setOutrasTaxas(List<ParamParcelamentoOutrasTaxas> outrasTaxas) {
        this.outrasTaxas = outrasTaxas;
    }

    @Generated
    public void setValorMinimoParcelamento(BigDecimal valorMinimoParcelamento) {
        this.valorMinimoParcelamento = valorMinimoParcelamento;
    }

    @Generated
    public void setPorContribuinte(Boolean porContribuinte) {
        this.porContribuinte = porContribuinte;
    }

    @Generated
    public String toString() {
        return "ParamParcelamento(id=" + this.getId() + ", tipo=" + this.getTipo() + ", descricao=" + this.getDescricao() + ", exercicio=" + this.getExercicio() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParamParcelamento)) {
            return false;
        }
        ParamParcelamento other = (ParamParcelamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParamParcelamento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

