/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.autoinfracao;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoDebito;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoHistorico;
import br.com.elotech.tributos.domain.autoinfracao.AutoInfracaoPenalidade;
import br.com.elotech.tributos.domain.autoinfracao.Fiscal;
import br.com.elotech.tributos.domain.autoinfracao.NotificacaoFiscalizacao;
import br.com.elotech.tributos.domain.autoinfracao.Penalidade;
import br.com.elotech.tributos.domain.autoinfracao.TipoAutoInfracao;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.enums.autoinfracao.SituacaoAutoInfracao;
import br.com.elotech.tributos.enums.autoinfracao.SituacaoRecursoAdministrativo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Table(name="TRIBAUTOINFRACAOFISCAL")
@Entity
@DynamicInsert
@DynamicUpdate
public class AutoInfracao
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="IdAutoInfracaoFiscal")
    @Column(name="idautoinfracaofiscal")
    private Long id;
    private Long entidade;
    private Long exercicio;
    private Long autoInfracaoFiscal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tipoautoinfracao")
    private TipoAutoInfracao tipoAutoInfracao;
    private BigDecimal valorAuto = BigDecimal.ZERO;
    private LocalDate data;
    @Column(name="dataentfisc")
    private LocalDate dataEntregaNotificacao;
    private LocalDate dataRetorno;
    private Long exercicioProcesso;
    private Long idProcesso;
    private LocalDate dataInicial;
    private LocalDate dataFim;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idnotificacaofiscalizacao")
    private NotificacaoFiscalizacao notificacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="tipocadastro", referencedColumnName="tipocadastro"), @JoinColumn(name="cadastrogeral", referencedColumnName="cadastrogeral")})
    private CadastroGeral cadastroGeral;
    private String usuario;
    private String mesesNaoRecolhido;
    private String servicosExecutados;
    private String itensListaServico;
    private String documentosExaminados;
    @Column(name="situacaoautoinfracao")
    private SituacaoAutoInfracao situacao;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorMultaFiscal = BigDecimal.ZERO;
    private LocalDateTime dataSituacao;
    @Column(name="datara1")
    private LocalDate dataRecursoAdministrativo1;
    @Column(name="situacaora1")
    private SituacaoRecursoAdministrativo situacaoRecursoAdministrativo1;
    @Column(name="exercicioprocra1")
    private Long exercicioProcessoRecursoAdministrativo1;
    @Column(name="idprocessora1")
    private Long idProcessoRecursoAdministrativo1;
    @Column(name="datara2")
    private LocalDate dataRecursoAdministrativo2;
    @Column(name="situacaora2")
    private SituacaoRecursoAdministrativo situacaoRecursoAdministrativo2;
    @Column(name="exercicioprocra2")
    private Long exercicioProcessoRecursoAdministrativo2;
    @Column(name="idprocessora2")
    private Long idProcessoRecursoAdministrativo2;
    private LocalDate dataCarta;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="exercicioDebito", referencedColumnName="exercicio")), @JoinColumnOrFormula(formula=@JoinFormula(value="tipoCadastro", referencedColumnName="tipoCadastro")), @JoinColumnOrFormula(formula=@JoinFormula(value="cadastroGeral", referencedColumnName="cadastroGeral")), @JoinColumnOrFormula(column=@JoinColumn(name="guiaRecolhimento", referencedColumnName="guiaRecolhimento")), @JoinColumnOrFormula(column=@JoinColumn(name="subdivida", referencedColumnName="subdivida"))})
    private Debito debito;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="fiscal", referencedColumnName="fiscal"), @JoinColumn(name="tipofiscal", referencedColumnName="tipofiscal")})
    private Fiscal fiscal;
    private String observacao;
    private Long pessoaFiscal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pessoa", referencedColumnName="pessoa")
    private Pessoa pessoa;
    private LocalDate dataVencimento;
    private Long numeroParcela;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="penalidade", referencedColumnName="penalidade"))})
    private Penalidade penalidade;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idcontencioso", referencedColumnName="idcontencioso")
    private Contencioso contencioso;
    @Column(name="exercicioprocdesconto")
    private Long exercicioProcessoDesconto;
    private Long idProcessoDesconto;
    private BigDecimal descontoAuto = BigDecimal.ZERO;
    private Boolean denunciaExpontanea = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="motivodesconto", referencedColumnName="motivodesconto")
    private MotivoDeducao motivoDesconto;
    private Long exercicioCancelamento;
    private Long idProcessoCancelamento;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="motivocancelamento", referencedColumnName="motivodesconto")
    @NotFound(action=NotFoundAction.IGNORE)
    private MotivoDeducao motivoCancelamento;
    private String observacaoCancelamento;
    private String usuarioExterno;
    private Long exercicioProcessoProcon;
    private Long processoProcon;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="exercicioprojeto", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="projeto", referencedColumnName="projeto"))})
    private Projeto projeto;
    private Long exercicioProcessoAutorDesconto;
    private Long processoAutorDesconto;
    @Column(name="datalimetenotificacao")
    private LocalDate dataLimiteNotificacao;
    private Boolean gerarDebito;
    private Long idDebito;
    private Long tipoTipoAutoInfracao;
    @Column(name="tipotipoautoinfracao_descr")
    private String tipoTipoAutoInfracaoDecricao;
    private Long exercicioProcesso156;
    private Long processo156;
    private LocalDate dataProcesso156;
    private BigDecimal valorCreditoImposto = BigDecimal.ZERO;
    private BigDecimal valorCreditoCorrecao = BigDecimal.ZERO;
    private BigDecimal valorAutoAux = BigDecimal.ZERO;
    private String processoProconFA;
    private Long tipoProcesso;
    private String processoSei;
    private String processoSeiCancelamento;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="autoInfracao")
    private List<AutoInfracaoDebito> debitos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="autoInfracao")
    private List<AutoInfracaoPenalidade> penalidades = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="autoInfracao")
    @OrderBy(value="sequencia desc")
    private List<AutoInfracaoHistorico> historicos = new ArrayList();

    public BigDecimal getValorTotal() {
        return this.getValorAuto().add(this.getValorJuros()).add(this.getValorMulta()).add(this.getValorCorrecao()).subtract(this.getValorCreditoImposto()).subtract(this.getValorCreditoCorrecao()).add(this.getValorPenalidades());
    }

    public BigDecimal getValorPenalidades() {
        return this.penalidades.stream().map(AutoInfracaoPenalidade::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public Long getProximaSequenciaHistorico() {
        return this.historicos.stream().map(historico -> historico.getId().getSequencia()).max(Long::compareTo).orElse(0L) + 1L;
    }

    @Generated
    public AutoInfracao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getAutoInfracaoFiscal() {
        return this.autoInfracaoFiscal;
    }

    @Generated
    public TipoAutoInfracao getTipoAutoInfracao() {
        return this.tipoAutoInfracao;
    }

    @Generated
    public BigDecimal getValorAuto() {
        return this.valorAuto;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public LocalDate getDataEntregaNotificacao() {
        return this.dataEntregaNotificacao;
    }

    @Generated
    public LocalDate getDataRetorno() {
        return this.dataRetorno;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    @Generated
    public LocalDate getDataFim() {
        return this.dataFim;
    }

    @Generated
    public NotificacaoFiscalizacao getNotificacao() {
        return this.notificacao;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getMesesNaoRecolhido() {
        return this.mesesNaoRecolhido;
    }

    @Generated
    public String getServicosExecutados() {
        return this.servicosExecutados;
    }

    @Generated
    public String getItensListaServico() {
        return this.itensListaServico;
    }

    @Generated
    public String getDocumentosExaminados() {
        return this.documentosExaminados;
    }

    @Generated
    public SituacaoAutoInfracao getSituacao() {
        return this.situacao;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorMultaFiscal() {
        return this.valorMultaFiscal;
    }

    @Generated
    public LocalDateTime getDataSituacao() {
        return this.dataSituacao;
    }

    @Generated
    public LocalDate getDataRecursoAdministrativo1() {
        return this.dataRecursoAdministrativo1;
    }

    @Generated
    public SituacaoRecursoAdministrativo getSituacaoRecursoAdministrativo1() {
        return this.situacaoRecursoAdministrativo1;
    }

    @Generated
    public Long getExercicioProcessoRecursoAdministrativo1() {
        return this.exercicioProcessoRecursoAdministrativo1;
    }

    @Generated
    public Long getIdProcessoRecursoAdministrativo1() {
        return this.idProcessoRecursoAdministrativo1;
    }

    @Generated
    public LocalDate getDataRecursoAdministrativo2() {
        return this.dataRecursoAdministrativo2;
    }

    @Generated
    public SituacaoRecursoAdministrativo getSituacaoRecursoAdministrativo2() {
        return this.situacaoRecursoAdministrativo2;
    }

    @Generated
    public Long getExercicioProcessoRecursoAdministrativo2() {
        return this.exercicioProcessoRecursoAdministrativo2;
    }

    @Generated
    public Long getIdProcessoRecursoAdministrativo2() {
        return this.idProcessoRecursoAdministrativo2;
    }

    @Generated
    public LocalDate getDataCarta() {
        return this.dataCarta;
    }

    @Generated
    public Debito getDebito() {
        return this.debito;
    }

    @Generated
    public Fiscal getFiscal() {
        return this.fiscal;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Long getPessoaFiscal() {
        return this.pessoaFiscal;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public Long getNumeroParcela() {
        return this.numeroParcela;
    }

    @Generated
    public Penalidade getPenalidade() {
        return this.penalidade;
    }

    @Generated
    public Contencioso getContencioso() {
        return this.contencioso;
    }

    @Generated
    public Long getExercicioProcessoDesconto() {
        return this.exercicioProcessoDesconto;
    }

    @Generated
    public Long getIdProcessoDesconto() {
        return this.idProcessoDesconto;
    }

    @Generated
    public BigDecimal getDescontoAuto() {
        return this.descontoAuto;
    }

    @Generated
    public Boolean getDenunciaExpontanea() {
        return this.denunciaExpontanea;
    }

    @Generated
    public MotivoDeducao getMotivoDesconto() {
        return this.motivoDesconto;
    }

    @Generated
    public Long getExercicioCancelamento() {
        return this.exercicioCancelamento;
    }

    @Generated
    public Long getIdProcessoCancelamento() {
        return this.idProcessoCancelamento;
    }

    @Generated
    public MotivoDeducao getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    @Generated
    public String getObservacaoCancelamento() {
        return this.observacaoCancelamento;
    }

    @Generated
    public String getUsuarioExterno() {
        return this.usuarioExterno;
    }

    @Generated
    public Long getExercicioProcessoProcon() {
        return this.exercicioProcessoProcon;
    }

    @Generated
    public Long getProcessoProcon() {
        return this.processoProcon;
    }

    @Generated
    public Projeto getProjeto() {
        return this.projeto;
    }

    @Generated
    public Long getExercicioProcessoAutorDesconto() {
        return this.exercicioProcessoAutorDesconto;
    }

    @Generated
    public Long getProcessoAutorDesconto() {
        return this.processoAutorDesconto;
    }

    @Generated
    public LocalDate getDataLimiteNotificacao() {
        return this.dataLimiteNotificacao;
    }

    @Generated
    public Boolean getGerarDebito() {
        return this.gerarDebito;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public Long getTipoTipoAutoInfracao() {
        return this.tipoTipoAutoInfracao;
    }

    @Generated
    public String getTipoTipoAutoInfracaoDecricao() {
        return this.tipoTipoAutoInfracaoDecricao;
    }

    @Generated
    public Long getExercicioProcesso156() {
        return this.exercicioProcesso156;
    }

    @Generated
    public Long getProcesso156() {
        return this.processo156;
    }

    @Generated
    public LocalDate getDataProcesso156() {
        return this.dataProcesso156;
    }

    @Generated
    public BigDecimal getValorCreditoImposto() {
        return this.valorCreditoImposto;
    }

    @Generated
    public BigDecimal getValorCreditoCorrecao() {
        return this.valorCreditoCorrecao;
    }

    @Generated
    public BigDecimal getValorAutoAux() {
        return this.valorAutoAux;
    }

    @Generated
    public String getProcessoProconFA() {
        return this.processoProconFA;
    }

    @Generated
    public Long getTipoProcesso() {
        return this.tipoProcesso;
    }

    @Generated
    public String getProcessoSei() {
        return this.processoSei;
    }

    @Generated
    public String getProcessoSeiCancelamento() {
        return this.processoSeiCancelamento;
    }

    @Generated
    public List<AutoInfracaoDebito> getDebitos() {
        return this.debitos;
    }

    @Generated
    public List<AutoInfracaoPenalidade> getPenalidades() {
        return this.penalidades;
    }

    @Generated
    public List<AutoInfracaoHistorico> getHistoricos() {
        return this.historicos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setAutoInfracaoFiscal(Long autoInfracaoFiscal) {
        this.autoInfracaoFiscal = autoInfracaoFiscal;
    }

    @Generated
    public void setTipoAutoInfracao(TipoAutoInfracao tipoAutoInfracao) {
        this.tipoAutoInfracao = tipoAutoInfracao;
    }

    @Generated
    public void setValorAuto(BigDecimal valorAuto) {
        this.valorAuto = valorAuto;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setDataEntregaNotificacao(LocalDate dataEntregaNotificacao) {
        this.dataEntregaNotificacao = dataEntregaNotificacao;
    }

    @Generated
    public void setDataRetorno(LocalDate dataRetorno) {
        this.dataRetorno = dataRetorno;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFim(LocalDate dataFim) {
        this.dataFim = dataFim;
    }

    @Generated
    public void setNotificacao(NotificacaoFiscalizacao notificacao) {
        this.notificacao = notificacao;
    }

    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setMesesNaoRecolhido(String mesesNaoRecolhido) {
        this.mesesNaoRecolhido = mesesNaoRecolhido;
    }

    @Generated
    public void setServicosExecutados(String servicosExecutados) {
        this.servicosExecutados = servicosExecutados;
    }

    @Generated
    public void setItensListaServico(String itensListaServico) {
        this.itensListaServico = itensListaServico;
    }

    @Generated
    public void setDocumentosExaminados(String documentosExaminados) {
        this.documentosExaminados = documentosExaminados;
    }

    @Generated
    public void setSituacao(SituacaoAutoInfracao situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorMultaFiscal(BigDecimal valorMultaFiscal) {
        this.valorMultaFiscal = valorMultaFiscal;
    }

    @Generated
    public void setDataSituacao(LocalDateTime dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    @Generated
    public void setDataRecursoAdministrativo1(LocalDate dataRecursoAdministrativo1) {
        this.dataRecursoAdministrativo1 = dataRecursoAdministrativo1;
    }

    @Generated
    public void setSituacaoRecursoAdministrativo1(SituacaoRecursoAdministrativo situacaoRecursoAdministrativo1) {
        this.situacaoRecursoAdministrativo1 = situacaoRecursoAdministrativo1;
    }

    @Generated
    public void setExercicioProcessoRecursoAdministrativo1(Long exercicioProcessoRecursoAdministrativo1) {
        this.exercicioProcessoRecursoAdministrativo1 = exercicioProcessoRecursoAdministrativo1;
    }

    @Generated
    public void setIdProcessoRecursoAdministrativo1(Long idProcessoRecursoAdministrativo1) {
        this.idProcessoRecursoAdministrativo1 = idProcessoRecursoAdministrativo1;
    }

    @Generated
    public void setDataRecursoAdministrativo2(LocalDate dataRecursoAdministrativo2) {
        this.dataRecursoAdministrativo2 = dataRecursoAdministrativo2;
    }

    @Generated
    public void setSituacaoRecursoAdministrativo2(SituacaoRecursoAdministrativo situacaoRecursoAdministrativo2) {
        this.situacaoRecursoAdministrativo2 = situacaoRecursoAdministrativo2;
    }

    @Generated
    public void setExercicioProcessoRecursoAdministrativo2(Long exercicioProcessoRecursoAdministrativo2) {
        this.exercicioProcessoRecursoAdministrativo2 = exercicioProcessoRecursoAdministrativo2;
    }

    @Generated
    public void setIdProcessoRecursoAdministrativo2(Long idProcessoRecursoAdministrativo2) {
        this.idProcessoRecursoAdministrativo2 = idProcessoRecursoAdministrativo2;
    }

    @Generated
    public void setDataCarta(LocalDate dataCarta) {
        this.dataCarta = dataCarta;
    }

    @Generated
    public void setDebito(Debito debito) {
        this.debito = debito;
    }

    @Generated
    public void setFiscal(Fiscal fiscal) {
        this.fiscal = fiscal;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setPessoaFiscal(Long pessoaFiscal) {
        this.pessoaFiscal = pessoaFiscal;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setNumeroParcela(Long numeroParcela) {
        this.numeroParcela = numeroParcela;
    }

    @Generated
    public void setPenalidade(Penalidade penalidade) {
        this.penalidade = penalidade;
    }

    @Generated
    public void setContencioso(Contencioso contencioso) {
        this.contencioso = contencioso;
    }

    @Generated
    public void setExercicioProcessoDesconto(Long exercicioProcessoDesconto) {
        this.exercicioProcessoDesconto = exercicioProcessoDesconto;
    }

    @Generated
    public void setIdProcessoDesconto(Long idProcessoDesconto) {
        this.idProcessoDesconto = idProcessoDesconto;
    }

    @Generated
    public void setDescontoAuto(BigDecimal descontoAuto) {
        this.descontoAuto = descontoAuto;
    }

    @Generated
    public void setDenunciaExpontanea(Boolean denunciaExpontanea) {
        this.denunciaExpontanea = denunciaExpontanea;
    }

    @Generated
    public void setMotivoDesconto(MotivoDeducao motivoDesconto) {
        this.motivoDesconto = motivoDesconto;
    }

    @Generated
    public void setExercicioCancelamento(Long exercicioCancelamento) {
        this.exercicioCancelamento = exercicioCancelamento;
    }

    @Generated
    public void setIdProcessoCancelamento(Long idProcessoCancelamento) {
        this.idProcessoCancelamento = idProcessoCancelamento;
    }

    @Generated
    public void setMotivoCancelamento(MotivoDeducao motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Generated
    public void setObservacaoCancelamento(String observacaoCancelamento) {
        this.observacaoCancelamento = observacaoCancelamento;
    }

    @Generated
    public void setUsuarioExterno(String usuarioExterno) {
        this.usuarioExterno = usuarioExterno;
    }

    @Generated
    public void setExercicioProcessoProcon(Long exercicioProcessoProcon) {
        this.exercicioProcessoProcon = exercicioProcessoProcon;
    }

    @Generated
    public void setProcessoProcon(Long processoProcon) {
        this.processoProcon = processoProcon;
    }

    @Generated
    public void setProjeto(Projeto projeto) {
        this.projeto = projeto;
    }

    @Generated
    public void setExercicioProcessoAutorDesconto(Long exercicioProcessoAutorDesconto) {
        this.exercicioProcessoAutorDesconto = exercicioProcessoAutorDesconto;
    }

    @Generated
    public void setProcessoAutorDesconto(Long processoAutorDesconto) {
        this.processoAutorDesconto = processoAutorDesconto;
    }

    @Generated
    public void setDataLimiteNotificacao(LocalDate dataLimiteNotificacao) {
        this.dataLimiteNotificacao = dataLimiteNotificacao;
    }

    @Generated
    public void setGerarDebito(Boolean gerarDebito) {
        this.gerarDebito = gerarDebito;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setTipoTipoAutoInfracao(Long tipoTipoAutoInfracao) {
        this.tipoTipoAutoInfracao = tipoTipoAutoInfracao;
    }

    @Generated
    public void setTipoTipoAutoInfracaoDecricao(String tipoTipoAutoInfracaoDecricao) {
        this.tipoTipoAutoInfracaoDecricao = tipoTipoAutoInfracaoDecricao;
    }

    @Generated
    public void setExercicioProcesso156(Long exercicioProcesso156) {
        this.exercicioProcesso156 = exercicioProcesso156;
    }

    @Generated
    public void setProcesso156(Long processo156) {
        this.processo156 = processo156;
    }

    @Generated
    public void setDataProcesso156(LocalDate dataProcesso156) {
        this.dataProcesso156 = dataProcesso156;
    }

    @Generated
    public void setValorCreditoImposto(BigDecimal valorCreditoImposto) {
        this.valorCreditoImposto = valorCreditoImposto;
    }

    @Generated
    public void setValorCreditoCorrecao(BigDecimal valorCreditoCorrecao) {
        this.valorCreditoCorrecao = valorCreditoCorrecao;
    }

    @Generated
    public void setValorAutoAux(BigDecimal valorAutoAux) {
        this.valorAutoAux = valorAutoAux;
    }

    @Generated
    public void setProcessoProconFA(String processoProconFA) {
        this.processoProconFA = processoProconFA;
    }

    @Generated
    public void setTipoProcesso(Long tipoProcesso) {
        this.tipoProcesso = tipoProcesso;
    }

    @Generated
    public void setProcessoSei(String processoSei) {
        this.processoSei = processoSei;
    }

    @Generated
    public void setProcessoSeiCancelamento(String processoSeiCancelamento) {
        this.processoSeiCancelamento = processoSeiCancelamento;
    }

    @Generated
    public void setDebitos(List<AutoInfracaoDebito> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public void setPenalidades(List<AutoInfracaoPenalidade> penalidades) {
        this.penalidades = penalidades;
    }

    @Generated
    public void setHistoricos(List<AutoInfracaoHistorico> historicos) {
        this.historicos = historicos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoInfracao)) {
            return false;
        }
        AutoInfracao other = (AutoInfracao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$autoInfracaoFiscal = this.getAutoInfracaoFiscal();
        Long other$autoInfracaoFiscal = other.getAutoInfracaoFiscal();
        if (this$autoInfracaoFiscal == null ? other$autoInfracaoFiscal != null : !((Object)this$autoInfracaoFiscal).equals(other$autoInfracaoFiscal)) {
            return false;
        }
        Long this$exercicioProcesso = this.getExercicioProcesso();
        Long other$exercicioProcesso = other.getExercicioProcesso();
        if (this$exercicioProcesso == null ? other$exercicioProcesso != null : !((Object)this$exercicioProcesso).equals(other$exercicioProcesso)) {
            return false;
        }
        Long this$idProcesso = this.getIdProcesso();
        Long other$idProcesso = other.getIdProcesso();
        if (this$idProcesso == null ? other$idProcesso != null : !((Object)this$idProcesso).equals(other$idProcesso)) {
            return false;
        }
        Long this$exercicioProcessoRecursoAdministrativo1 = this.getExercicioProcessoRecursoAdministrativo1();
        Long other$exercicioProcessoRecursoAdministrativo1 = other.getExercicioProcessoRecursoAdministrativo1();
        if (this$exercicioProcessoRecursoAdministrativo1 == null ? other$exercicioProcessoRecursoAdministrativo1 != null : !((Object)this$exercicioProcessoRecursoAdministrativo1).equals(other$exercicioProcessoRecursoAdministrativo1)) {
            return false;
        }
        Long this$idProcessoRecursoAdministrativo1 = this.getIdProcessoRecursoAdministrativo1();
        Long other$idProcessoRecursoAdministrativo1 = other.getIdProcessoRecursoAdministrativo1();
        if (this$idProcessoRecursoAdministrativo1 == null ? other$idProcessoRecursoAdministrativo1 != null : !((Object)this$idProcessoRecursoAdministrativo1).equals(other$idProcessoRecursoAdministrativo1)) {
            return false;
        }
        Long this$exercicioProcessoRecursoAdministrativo2 = this.getExercicioProcessoRecursoAdministrativo2();
        Long other$exercicioProcessoRecursoAdministrativo2 = other.getExercicioProcessoRecursoAdministrativo2();
        if (this$exercicioProcessoRecursoAdministrativo2 == null ? other$exercicioProcessoRecursoAdministrativo2 != null : !((Object)this$exercicioProcessoRecursoAdministrativo2).equals(other$exercicioProcessoRecursoAdministrativo2)) {
            return false;
        }
        Long this$idProcessoRecursoAdministrativo2 = this.getIdProcessoRecursoAdministrativo2();
        Long other$idProcessoRecursoAdministrativo2 = other.getIdProcessoRecursoAdministrativo2();
        if (this$idProcessoRecursoAdministrativo2 == null ? other$idProcessoRecursoAdministrativo2 != null : !((Object)this$idProcessoRecursoAdministrativo2).equals(other$idProcessoRecursoAdministrativo2)) {
            return false;
        }
        Long this$pessoaFiscal = this.getPessoaFiscal();
        Long other$pessoaFiscal = other.getPessoaFiscal();
        if (this$pessoaFiscal == null ? other$pessoaFiscal != null : !((Object)this$pessoaFiscal).equals(other$pessoaFiscal)) {
            return false;
        }
        Long this$numeroParcela = this.getNumeroParcela();
        Long other$numeroParcela = other.getNumeroParcela();
        if (this$numeroParcela == null ? other$numeroParcela != null : !((Object)this$numeroParcela).equals(other$numeroParcela)) {
            return false;
        }
        Long this$exercicioProcessoDesconto = this.getExercicioProcessoDesconto();
        Long other$exercicioProcessoDesconto = other.getExercicioProcessoDesconto();
        if (this$exercicioProcessoDesconto == null ? other$exercicioProcessoDesconto != null : !((Object)this$exercicioProcessoDesconto).equals(other$exercicioProcessoDesconto)) {
            return false;
        }
        Long this$idProcessoDesconto = this.getIdProcessoDesconto();
        Long other$idProcessoDesconto = other.getIdProcessoDesconto();
        if (this$idProcessoDesconto == null ? other$idProcessoDesconto != null : !((Object)this$idProcessoDesconto).equals(other$idProcessoDesconto)) {
            return false;
        }
        Boolean this$denunciaExpontanea = this.getDenunciaExpontanea();
        Boolean other$denunciaExpontanea = other.getDenunciaExpontanea();
        if (this$denunciaExpontanea == null ? other$denunciaExpontanea != null : !((Object)this$denunciaExpontanea).equals(other$denunciaExpontanea)) {
            return false;
        }
        Long this$exercicioCancelamento = this.getExercicioCancelamento();
        Long other$exercicioCancelamento = other.getExercicioCancelamento();
        if (this$exercicioCancelamento == null ? other$exercicioCancelamento != null : !((Object)this$exercicioCancelamento).equals(other$exercicioCancelamento)) {
            return false;
        }
        Long this$idProcessoCancelamento = this.getIdProcessoCancelamento();
        Long other$idProcessoCancelamento = other.getIdProcessoCancelamento();
        if (this$idProcessoCancelamento == null ? other$idProcessoCancelamento != null : !((Object)this$idProcessoCancelamento).equals(other$idProcessoCancelamento)) {
            return false;
        }
        Long this$exercicioProcessoProcon = this.getExercicioProcessoProcon();
        Long other$exercicioProcessoProcon = other.getExercicioProcessoProcon();
        if (this$exercicioProcessoProcon == null ? other$exercicioProcessoProcon != null : !((Object)this$exercicioProcessoProcon).equals(other$exercicioProcessoProcon)) {
            return false;
        }
        Long this$processoProcon = this.getProcessoProcon();
        Long other$processoProcon = other.getProcessoProcon();
        if (this$processoProcon == null ? other$processoProcon != null : !((Object)this$processoProcon).equals(other$processoProcon)) {
            return false;
        }
        Long this$exercicioProcessoAutorDesconto = this.getExercicioProcessoAutorDesconto();
        Long other$exercicioProcessoAutorDesconto = other.getExercicioProcessoAutorDesconto();
        if (this$exercicioProcessoAutorDesconto == null ? other$exercicioProcessoAutorDesconto != null : !((Object)this$exercicioProcessoAutorDesconto).equals(other$exercicioProcessoAutorDesconto)) {
            return false;
        }
        Long this$processoAutorDesconto = this.getProcessoAutorDesconto();
        Long other$processoAutorDesconto = other.getProcessoAutorDesconto();
        if (this$processoAutorDesconto == null ? other$processoAutorDesconto != null : !((Object)this$processoAutorDesconto).equals(other$processoAutorDesconto)) {
            return false;
        }
        Boolean this$gerarDebito = this.getGerarDebito();
        Boolean other$gerarDebito = other.getGerarDebito();
        if (this$gerarDebito == null ? other$gerarDebito != null : !((Object)this$gerarDebito).equals(other$gerarDebito)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$tipoTipoAutoInfracao = this.getTipoTipoAutoInfracao();
        Long other$tipoTipoAutoInfracao = other.getTipoTipoAutoInfracao();
        if (this$tipoTipoAutoInfracao == null ? other$tipoTipoAutoInfracao != null : !((Object)this$tipoTipoAutoInfracao).equals(other$tipoTipoAutoInfracao)) {
            return false;
        }
        Long this$exercicioProcesso156 = this.getExercicioProcesso156();
        Long other$exercicioProcesso156 = other.getExercicioProcesso156();
        if (this$exercicioProcesso156 == null ? other$exercicioProcesso156 != null : !((Object)this$exercicioProcesso156).equals(other$exercicioProcesso156)) {
            return false;
        }
        Long this$processo156 = this.getProcesso156();
        Long other$processo156 = other.getProcesso156();
        if (this$processo156 == null ? other$processo156 != null : !((Object)this$processo156).equals(other$processo156)) {
            return false;
        }
        Long this$tipoProcesso = this.getTipoProcesso();
        Long other$tipoProcesso = other.getTipoProcesso();
        if (this$tipoProcesso == null ? other$tipoProcesso != null : !((Object)this$tipoProcesso).equals(other$tipoProcesso)) {
            return false;
        }
        TipoAutoInfracao this$tipoAutoInfracao = this.getTipoAutoInfracao();
        TipoAutoInfracao other$tipoAutoInfracao = other.getTipoAutoInfracao();
        if (this$tipoAutoInfracao == null ? other$tipoAutoInfracao != null : !this$tipoAutoInfracao.equals(other$tipoAutoInfracao)) {
            return false;
        }
        BigDecimal this$valorAuto = this.getValorAuto();
        BigDecimal other$valorAuto = other.getValorAuto();
        if (this$valorAuto == null ? other$valorAuto != null : !((Object)this$valorAuto).equals(other$valorAuto)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        LocalDate this$dataEntregaNotificacao = this.getDataEntregaNotificacao();
        LocalDate other$dataEntregaNotificacao = other.getDataEntregaNotificacao();
        if (this$dataEntregaNotificacao == null ? other$dataEntregaNotificacao != null : !((Object)this$dataEntregaNotificacao).equals(other$dataEntregaNotificacao)) {
            return false;
        }
        LocalDate this$dataRetorno = this.getDataRetorno();
        LocalDate other$dataRetorno = other.getDataRetorno();
        if (this$dataRetorno == null ? other$dataRetorno != null : !((Object)this$dataRetorno).equals(other$dataRetorno)) {
            return false;
        }
        LocalDate this$dataInicial = this.getDataInicial();
        LocalDate other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        LocalDate this$dataFim = this.getDataFim();
        LocalDate other$dataFim = other.getDataFim();
        if (this$dataFim == null ? other$dataFim != null : !((Object)this$dataFim).equals(other$dataFim)) {
            return false;
        }
        NotificacaoFiscalizacao this$notificacao = this.getNotificacao();
        NotificacaoFiscalizacao other$notificacao = other.getNotificacao();
        if (this$notificacao == null ? other$notificacao != null : !this$notificacao.equals(other$notificacao)) {
            return false;
        }
        CadastroGeral this$cadastroGeral = this.getCadastroGeral();
        CadastroGeral other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        String this$mesesNaoRecolhido = this.getMesesNaoRecolhido();
        String other$mesesNaoRecolhido = other.getMesesNaoRecolhido();
        if (this$mesesNaoRecolhido == null ? other$mesesNaoRecolhido != null : !this$mesesNaoRecolhido.equals(other$mesesNaoRecolhido)) {
            return false;
        }
        String this$servicosExecutados = this.getServicosExecutados();
        String other$servicosExecutados = other.getServicosExecutados();
        if (this$servicosExecutados == null ? other$servicosExecutados != null : !this$servicosExecutados.equals(other$servicosExecutados)) {
            return false;
        }
        String this$itensListaServico = this.getItensListaServico();
        String other$itensListaServico = other.getItensListaServico();
        if (this$itensListaServico == null ? other$itensListaServico != null : !this$itensListaServico.equals(other$itensListaServico)) {
            return false;
        }
        String this$documentosExaminados = this.getDocumentosExaminados();
        String other$documentosExaminados = other.getDocumentosExaminados();
        if (this$documentosExaminados == null ? other$documentosExaminados != null : !this$documentosExaminados.equals(other$documentosExaminados)) {
            return false;
        }
        SituacaoAutoInfracao this$situacao = this.getSituacao();
        SituacaoAutoInfracao other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorMultaFiscal = this.getValorMultaFiscal();
        BigDecimal other$valorMultaFiscal = other.getValorMultaFiscal();
        if (this$valorMultaFiscal == null ? other$valorMultaFiscal != null : !((Object)this$valorMultaFiscal).equals(other$valorMultaFiscal)) {
            return false;
        }
        LocalDateTime this$dataSituacao = this.getDataSituacao();
        LocalDateTime other$dataSituacao = other.getDataSituacao();
        if (this$dataSituacao == null ? other$dataSituacao != null : !((Object)this$dataSituacao).equals(other$dataSituacao)) {
            return false;
        }
        LocalDate this$dataRecursoAdministrativo1 = this.getDataRecursoAdministrativo1();
        LocalDate other$dataRecursoAdministrativo1 = other.getDataRecursoAdministrativo1();
        if (this$dataRecursoAdministrativo1 == null ? other$dataRecursoAdministrativo1 != null : !((Object)this$dataRecursoAdministrativo1).equals(other$dataRecursoAdministrativo1)) {
            return false;
        }
        SituacaoRecursoAdministrativo this$situacaoRecursoAdministrativo1 = this.getSituacaoRecursoAdministrativo1();
        SituacaoRecursoAdministrativo other$situacaoRecursoAdministrativo1 = other.getSituacaoRecursoAdministrativo1();
        if (this$situacaoRecursoAdministrativo1 == null ? other$situacaoRecursoAdministrativo1 != null : !this$situacaoRecursoAdministrativo1.equals(other$situacaoRecursoAdministrativo1)) {
            return false;
        }
        LocalDate this$dataRecursoAdministrativo2 = this.getDataRecursoAdministrativo2();
        LocalDate other$dataRecursoAdministrativo2 = other.getDataRecursoAdministrativo2();
        if (this$dataRecursoAdministrativo2 == null ? other$dataRecursoAdministrativo2 != null : !((Object)this$dataRecursoAdministrativo2).equals(other$dataRecursoAdministrativo2)) {
            return false;
        }
        SituacaoRecursoAdministrativo this$situacaoRecursoAdministrativo2 = this.getSituacaoRecursoAdministrativo2();
        SituacaoRecursoAdministrativo other$situacaoRecursoAdministrativo2 = other.getSituacaoRecursoAdministrativo2();
        if (this$situacaoRecursoAdministrativo2 == null ? other$situacaoRecursoAdministrativo2 != null : !this$situacaoRecursoAdministrativo2.equals(other$situacaoRecursoAdministrativo2)) {
            return false;
        }
        LocalDate this$dataCarta = this.getDataCarta();
        LocalDate other$dataCarta = other.getDataCarta();
        if (this$dataCarta == null ? other$dataCarta != null : !((Object)this$dataCarta).equals(other$dataCarta)) {
            return false;
        }
        Debito this$debito = this.getDebito();
        Debito other$debito = other.getDebito();
        if (this$debito == null ? other$debito != null : !this$debito.equals(other$debito)) {
            return false;
        }
        Fiscal this$fiscal = this.getFiscal();
        Fiscal other$fiscal = other.getFiscal();
        if (this$fiscal == null ? other$fiscal != null : !this$fiscal.equals(other$fiscal)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        Pessoa this$pessoa = this.getPessoa();
        Pessoa other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        if (this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento)) {
            return false;
        }
        Penalidade this$penalidade = this.getPenalidade();
        Penalidade other$penalidade = other.getPenalidade();
        if (this$penalidade == null ? other$penalidade != null : !this$penalidade.equals(other$penalidade)) {
            return false;
        }
        Contencioso this$contencioso = this.getContencioso();
        Contencioso other$contencioso = other.getContencioso();
        if (this$contencioso == null ? other$contencioso != null : !this$contencioso.equals(other$contencioso)) {
            return false;
        }
        BigDecimal this$descontoAuto = this.getDescontoAuto();
        BigDecimal other$descontoAuto = other.getDescontoAuto();
        if (this$descontoAuto == null ? other$descontoAuto != null : !((Object)this$descontoAuto).equals(other$descontoAuto)) {
            return false;
        }
        MotivoDeducao this$motivoDesconto = this.getMotivoDesconto();
        MotivoDeducao other$motivoDesconto = other.getMotivoDesconto();
        if (this$motivoDesconto == null ? other$motivoDesconto != null : !this$motivoDesconto.equals(other$motivoDesconto)) {
            return false;
        }
        MotivoDeducao this$motivoCancelamento = this.getMotivoCancelamento();
        MotivoDeducao other$motivoCancelamento = other.getMotivoCancelamento();
        if (this$motivoCancelamento == null ? other$motivoCancelamento != null : !this$motivoCancelamento.equals(other$motivoCancelamento)) {
            return false;
        }
        String this$observacaoCancelamento = this.getObservacaoCancelamento();
        String other$observacaoCancelamento = other.getObservacaoCancelamento();
        if (this$observacaoCancelamento == null ? other$observacaoCancelamento != null : !this$observacaoCancelamento.equals(other$observacaoCancelamento)) {
            return false;
        }
        String this$usuarioExterno = this.getUsuarioExterno();
        String other$usuarioExterno = other.getUsuarioExterno();
        if (this$usuarioExterno == null ? other$usuarioExterno != null : !this$usuarioExterno.equals(other$usuarioExterno)) {
            return false;
        }
        Projeto this$projeto = this.getProjeto();
        Projeto other$projeto = other.getProjeto();
        if (this$projeto == null ? other$projeto != null : !this$projeto.equals(other$projeto)) {
            return false;
        }
        LocalDate this$dataLimiteNotificacao = this.getDataLimiteNotificacao();
        LocalDate other$dataLimiteNotificacao = other.getDataLimiteNotificacao();
        if (this$dataLimiteNotificacao == null ? other$dataLimiteNotificacao != null : !((Object)this$dataLimiteNotificacao).equals(other$dataLimiteNotificacao)) {
            return false;
        }
        String this$tipoTipoAutoInfracaoDecricao = this.getTipoTipoAutoInfracaoDecricao();
        String other$tipoTipoAutoInfracaoDecricao = other.getTipoTipoAutoInfracaoDecricao();
        if (this$tipoTipoAutoInfracaoDecricao == null ? other$tipoTipoAutoInfracaoDecricao != null : !this$tipoTipoAutoInfracaoDecricao.equals(other$tipoTipoAutoInfracaoDecricao)) {
            return false;
        }
        LocalDate this$dataProcesso156 = this.getDataProcesso156();
        LocalDate other$dataProcesso156 = other.getDataProcesso156();
        if (this$dataProcesso156 == null ? other$dataProcesso156 != null : !((Object)this$dataProcesso156).equals(other$dataProcesso156)) {
            return false;
        }
        BigDecimal this$valorCreditoImposto = this.getValorCreditoImposto();
        BigDecimal other$valorCreditoImposto = other.getValorCreditoImposto();
        if (this$valorCreditoImposto == null ? other$valorCreditoImposto != null : !((Object)this$valorCreditoImposto).equals(other$valorCreditoImposto)) {
            return false;
        }
        BigDecimal this$valorCreditoCorrecao = this.getValorCreditoCorrecao();
        BigDecimal other$valorCreditoCorrecao = other.getValorCreditoCorrecao();
        if (this$valorCreditoCorrecao == null ? other$valorCreditoCorrecao != null : !((Object)this$valorCreditoCorrecao).equals(other$valorCreditoCorrecao)) {
            return false;
        }
        BigDecimal this$valorAutoAux = this.getValorAutoAux();
        BigDecimal other$valorAutoAux = other.getValorAutoAux();
        if (this$valorAutoAux == null ? other$valorAutoAux != null : !((Object)this$valorAutoAux).equals(other$valorAutoAux)) {
            return false;
        }
        String this$processoProconFA = this.getProcessoProconFA();
        String other$processoProconFA = other.getProcessoProconFA();
        if (this$processoProconFA == null ? other$processoProconFA != null : !this$processoProconFA.equals(other$processoProconFA)) {
            return false;
        }
        String this$processoSei = this.getProcessoSei();
        String other$processoSei = other.getProcessoSei();
        if (this$processoSei == null ? other$processoSei != null : !this$processoSei.equals(other$processoSei)) {
            return false;
        }
        String this$processoSeiCancelamento = this.getProcessoSeiCancelamento();
        String other$processoSeiCancelamento = other.getProcessoSeiCancelamento();
        if (this$processoSeiCancelamento == null ? other$processoSeiCancelamento != null : !this$processoSeiCancelamento.equals(other$processoSeiCancelamento)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        List this$penalidades = this.getPenalidades();
        List other$penalidades = other.getPenalidades();
        if (this$penalidades == null ? other$penalidades != null : !((Object)this$penalidades).equals(other$penalidades)) {
            return false;
        }
        List this$historicos = this.getHistoricos();
        List other$historicos = other.getHistoricos();
        return !(this$historicos == null ? other$historicos != null : !((Object)this$historicos).equals(other$historicos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutoInfracao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $autoInfracaoFiscal = this.getAutoInfracaoFiscal();
        result = result * 59 + ($autoInfracaoFiscal == null ? 43 : ((Object)$autoInfracaoFiscal).hashCode());
        Long $exercicioProcesso = this.getExercicioProcesso();
        result = result * 59 + ($exercicioProcesso == null ? 43 : ((Object)$exercicioProcesso).hashCode());
        Long $idProcesso = this.getIdProcesso();
        result = result * 59 + ($idProcesso == null ? 43 : ((Object)$idProcesso).hashCode());
        Long $exercicioProcessoRecursoAdministrativo1 = this.getExercicioProcessoRecursoAdministrativo1();
        result = result * 59 + ($exercicioProcessoRecursoAdministrativo1 == null ? 43 : ((Object)$exercicioProcessoRecursoAdministrativo1).hashCode());
        Long $idProcessoRecursoAdministrativo1 = this.getIdProcessoRecursoAdministrativo1();
        result = result * 59 + ($idProcessoRecursoAdministrativo1 == null ? 43 : ((Object)$idProcessoRecursoAdministrativo1).hashCode());
        Long $exercicioProcessoRecursoAdministrativo2 = this.getExercicioProcessoRecursoAdministrativo2();
        result = result * 59 + ($exercicioProcessoRecursoAdministrativo2 == null ? 43 : ((Object)$exercicioProcessoRecursoAdministrativo2).hashCode());
        Long $idProcessoRecursoAdministrativo2 = this.getIdProcessoRecursoAdministrativo2();
        result = result * 59 + ($idProcessoRecursoAdministrativo2 == null ? 43 : ((Object)$idProcessoRecursoAdministrativo2).hashCode());
        Long $pessoaFiscal = this.getPessoaFiscal();
        result = result * 59 + ($pessoaFiscal == null ? 43 : ((Object)$pessoaFiscal).hashCode());
        Long $numeroParcela = this.getNumeroParcela();
        result = result * 59 + ($numeroParcela == null ? 43 : ((Object)$numeroParcela).hashCode());
        Long $exercicioProcessoDesconto = this.getExercicioProcessoDesconto();
        result = result * 59 + ($exercicioProcessoDesconto == null ? 43 : ((Object)$exercicioProcessoDesconto).hashCode());
        Long $idProcessoDesconto = this.getIdProcessoDesconto();
        result = result * 59 + ($idProcessoDesconto == null ? 43 : ((Object)$idProcessoDesconto).hashCode());
        Boolean $denunciaExpontanea = this.getDenunciaExpontanea();
        result = result * 59 + ($denunciaExpontanea == null ? 43 : ((Object)$denunciaExpontanea).hashCode());
        Long $exercicioCancelamento = this.getExercicioCancelamento();
        result = result * 59 + ($exercicioCancelamento == null ? 43 : ((Object)$exercicioCancelamento).hashCode());
        Long $idProcessoCancelamento = this.getIdProcessoCancelamento();
        result = result * 59 + ($idProcessoCancelamento == null ? 43 : ((Object)$idProcessoCancelamento).hashCode());
        Long $exercicioProcessoProcon = this.getExercicioProcessoProcon();
        result = result * 59 + ($exercicioProcessoProcon == null ? 43 : ((Object)$exercicioProcessoProcon).hashCode());
        Long $processoProcon = this.getProcessoProcon();
        result = result * 59 + ($processoProcon == null ? 43 : ((Object)$processoProcon).hashCode());
        Long $exercicioProcessoAutorDesconto = this.getExercicioProcessoAutorDesconto();
        result = result * 59 + ($exercicioProcessoAutorDesconto == null ? 43 : ((Object)$exercicioProcessoAutorDesconto).hashCode());
        Long $processoAutorDesconto = this.getProcessoAutorDesconto();
        result = result * 59 + ($processoAutorDesconto == null ? 43 : ((Object)$processoAutorDesconto).hashCode());
        Boolean $gerarDebito = this.getGerarDebito();
        result = result * 59 + ($gerarDebito == null ? 43 : ((Object)$gerarDebito).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $tipoTipoAutoInfracao = this.getTipoTipoAutoInfracao();
        result = result * 59 + ($tipoTipoAutoInfracao == null ? 43 : ((Object)$tipoTipoAutoInfracao).hashCode());
        Long $exercicioProcesso156 = this.getExercicioProcesso156();
        result = result * 59 + ($exercicioProcesso156 == null ? 43 : ((Object)$exercicioProcesso156).hashCode());
        Long $processo156 = this.getProcesso156();
        result = result * 59 + ($processo156 == null ? 43 : ((Object)$processo156).hashCode());
        Long $tipoProcesso = this.getTipoProcesso();
        result = result * 59 + ($tipoProcesso == null ? 43 : ((Object)$tipoProcesso).hashCode());
        TipoAutoInfracao $tipoAutoInfracao = this.getTipoAutoInfracao();
        result = result * 59 + ($tipoAutoInfracao == null ? 43 : $tipoAutoInfracao.hashCode());
        BigDecimal $valorAuto = this.getValorAuto();
        result = result * 59 + ($valorAuto == null ? 43 : ((Object)$valorAuto).hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        LocalDate $dataEntregaNotificacao = this.getDataEntregaNotificacao();
        result = result * 59 + ($dataEntregaNotificacao == null ? 43 : ((Object)$dataEntregaNotificacao).hashCode());
        LocalDate $dataRetorno = this.getDataRetorno();
        result = result * 59 + ($dataRetorno == null ? 43 : ((Object)$dataRetorno).hashCode());
        LocalDate $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        LocalDate $dataFim = this.getDataFim();
        result = result * 59 + ($dataFim == null ? 43 : ((Object)$dataFim).hashCode());
        NotificacaoFiscalizacao $notificacao = this.getNotificacao();
        result = result * 59 + ($notificacao == null ? 43 : $notificacao.hashCode());
        CadastroGeral $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        String $mesesNaoRecolhido = this.getMesesNaoRecolhido();
        result = result * 59 + ($mesesNaoRecolhido == null ? 43 : $mesesNaoRecolhido.hashCode());
        String $servicosExecutados = this.getServicosExecutados();
        result = result * 59 + ($servicosExecutados == null ? 43 : $servicosExecutados.hashCode());
        String $itensListaServico = this.getItensListaServico();
        result = result * 59 + ($itensListaServico == null ? 43 : $itensListaServico.hashCode());
        String $documentosExaminados = this.getDocumentosExaminados();
        result = result * 59 + ($documentosExaminados == null ? 43 : $documentosExaminados.hashCode());
        SituacaoAutoInfracao $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorMultaFiscal = this.getValorMultaFiscal();
        result = result * 59 + ($valorMultaFiscal == null ? 43 : ((Object)$valorMultaFiscal).hashCode());
        LocalDateTime $dataSituacao = this.getDataSituacao();
        result = result * 59 + ($dataSituacao == null ? 43 : ((Object)$dataSituacao).hashCode());
        LocalDate $dataRecursoAdministrativo1 = this.getDataRecursoAdministrativo1();
        result = result * 59 + ($dataRecursoAdministrativo1 == null ? 43 : ((Object)$dataRecursoAdministrativo1).hashCode());
        SituacaoRecursoAdministrativo $situacaoRecursoAdministrativo1 = this.getSituacaoRecursoAdministrativo1();
        result = result * 59 + ($situacaoRecursoAdministrativo1 == null ? 43 : $situacaoRecursoAdministrativo1.hashCode());
        LocalDate $dataRecursoAdministrativo2 = this.getDataRecursoAdministrativo2();
        result = result * 59 + ($dataRecursoAdministrativo2 == null ? 43 : ((Object)$dataRecursoAdministrativo2).hashCode());
        SituacaoRecursoAdministrativo $situacaoRecursoAdministrativo2 = this.getSituacaoRecursoAdministrativo2();
        result = result * 59 + ($situacaoRecursoAdministrativo2 == null ? 43 : $situacaoRecursoAdministrativo2.hashCode());
        LocalDate $dataCarta = this.getDataCarta();
        result = result * 59 + ($dataCarta == null ? 43 : ((Object)$dataCarta).hashCode());
        Debito $debito = this.getDebito();
        result = result * 59 + ($debito == null ? 43 : $debito.hashCode());
        Fiscal $fiscal = this.getFiscal();
        result = result * 59 + ($fiscal == null ? 43 : $fiscal.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        Pessoa $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        Penalidade $penalidade = this.getPenalidade();
        result = result * 59 + ($penalidade == null ? 43 : $penalidade.hashCode());
        Contencioso $contencioso = this.getContencioso();
        result = result * 59 + ($contencioso == null ? 43 : $contencioso.hashCode());
        BigDecimal $descontoAuto = this.getDescontoAuto();
        result = result * 59 + ($descontoAuto == null ? 43 : ((Object)$descontoAuto).hashCode());
        MotivoDeducao $motivoDesconto = this.getMotivoDesconto();
        result = result * 59 + ($motivoDesconto == null ? 43 : $motivoDesconto.hashCode());
        MotivoDeducao $motivoCancelamento = this.getMotivoCancelamento();
        result = result * 59 + ($motivoCancelamento == null ? 43 : $motivoCancelamento.hashCode());
        String $observacaoCancelamento = this.getObservacaoCancelamento();
        result = result * 59 + ($observacaoCancelamento == null ? 43 : $observacaoCancelamento.hashCode());
        String $usuarioExterno = this.getUsuarioExterno();
        result = result * 59 + ($usuarioExterno == null ? 43 : $usuarioExterno.hashCode());
        Projeto $projeto = this.getProjeto();
        result = result * 59 + ($projeto == null ? 43 : $projeto.hashCode());
        LocalDate $dataLimiteNotificacao = this.getDataLimiteNotificacao();
        result = result * 59 + ($dataLimiteNotificacao == null ? 43 : ((Object)$dataLimiteNotificacao).hashCode());
        String $tipoTipoAutoInfracaoDecricao = this.getTipoTipoAutoInfracaoDecricao();
        result = result * 59 + ($tipoTipoAutoInfracaoDecricao == null ? 43 : $tipoTipoAutoInfracaoDecricao.hashCode());
        LocalDate $dataProcesso156 = this.getDataProcesso156();
        result = result * 59 + ($dataProcesso156 == null ? 43 : ((Object)$dataProcesso156).hashCode());
        BigDecimal $valorCreditoImposto = this.getValorCreditoImposto();
        result = result * 59 + ($valorCreditoImposto == null ? 43 : ((Object)$valorCreditoImposto).hashCode());
        BigDecimal $valorCreditoCorrecao = this.getValorCreditoCorrecao();
        result = result * 59 + ($valorCreditoCorrecao == null ? 43 : ((Object)$valorCreditoCorrecao).hashCode());
        BigDecimal $valorAutoAux = this.getValorAutoAux();
        result = result * 59 + ($valorAutoAux == null ? 43 : ((Object)$valorAutoAux).hashCode());
        String $processoProconFA = this.getProcessoProconFA();
        result = result * 59 + ($processoProconFA == null ? 43 : $processoProconFA.hashCode());
        String $processoSei = this.getProcessoSei();
        result = result * 59 + ($processoSei == null ? 43 : $processoSei.hashCode());
        String $processoSeiCancelamento = this.getProcessoSeiCancelamento();
        result = result * 59 + ($processoSeiCancelamento == null ? 43 : $processoSeiCancelamento.hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        List $penalidades = this.getPenalidades();
        result = result * 59 + ($penalidades == null ? 43 : ((Object)$penalidades).hashCode());
        List $historicos = this.getHistoricos();
        result = result * 59 + ($historicos == null ? 43 : ((Object)$historicos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AutoInfracao(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", autoInfracaoFiscal=" + this.getAutoInfracaoFiscal() + ", tipoAutoInfracao=" + this.getTipoAutoInfracao() + ", valorAuto=" + this.getValorAuto() + ", data=" + this.getData() + ", dataEntregaNotificacao=" + this.getDataEntregaNotificacao() + ", dataRetorno=" + this.getDataRetorno() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", idProcesso=" + this.getIdProcesso() + ", dataInicial=" + this.getDataInicial() + ", dataFim=" + this.getDataFim() + ", notificacao=" + this.getNotificacao() + ", cadastroGeral=" + this.getCadastroGeral() + ", usuario=" + this.getUsuario() + ", mesesNaoRecolhido=" + this.getMesesNaoRecolhido() + ", servicosExecutados=" + this.getServicosExecutados() + ", itensListaServico=" + this.getItensListaServico() + ", documentosExaminados=" + this.getDocumentosExaminados() + ", situacao=" + this.getSituacao() + ", valorMulta=" + this.getValorMulta() + ", valorJuros=" + this.getValorJuros() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorMultaFiscal=" + this.getValorMultaFiscal() + ", dataSituacao=" + this.getDataSituacao() + ", dataRecursoAdministrativo1=" + this.getDataRecursoAdministrativo1() + ", situacaoRecursoAdministrativo1=" + this.getSituacaoRecursoAdministrativo1() + ", exercicioProcessoRecursoAdministrativo1=" + this.getExercicioProcessoRecursoAdministrativo1() + ", idProcessoRecursoAdministrativo1=" + this.getIdProcessoRecursoAdministrativo1() + ", dataRecursoAdministrativo2=" + this.getDataRecursoAdministrativo2() + ", situacaoRecursoAdministrativo2=" + this.getSituacaoRecursoAdministrativo2() + ", exercicioProcessoRecursoAdministrativo2=" + this.getExercicioProcessoRecursoAdministrativo2() + ", idProcessoRecursoAdministrativo2=" + this.getIdProcessoRecursoAdministrativo2() + ", dataCarta=" + this.getDataCarta() + ", debito=" + this.getDebito() + ", fiscal=" + this.getFiscal() + ", observacao=" + this.getObservacao() + ", pessoaFiscal=" + this.getPessoaFiscal() + ", pessoa=" + this.getPessoa() + ", dataVencimento=" + this.getDataVencimento() + ", numeroParcela=" + this.getNumeroParcela() + ", penalidade=" + this.getPenalidade() + ", contencioso=" + this.getContencioso() + ", exercicioProcessoDesconto=" + this.getExercicioProcessoDesconto() + ", idProcessoDesconto=" + this.getIdProcessoDesconto() + ", descontoAuto=" + this.getDescontoAuto() + ", denunciaExpontanea=" + this.getDenunciaExpontanea() + ", motivoDesconto=" + this.getMotivoDesconto() + ", exercicioCancelamento=" + this.getExercicioCancelamento() + ", idProcessoCancelamento=" + this.getIdProcessoCancelamento() + ", motivoCancelamento=" + this.getMotivoCancelamento() + ", observacaoCancelamento=" + this.getObservacaoCancelamento() + ", usuarioExterno=" + this.getUsuarioExterno() + ", exercicioProcessoProcon=" + this.getExercicioProcessoProcon() + ", processoProcon=" + this.getProcessoProcon() + ", projeto=" + this.getProjeto() + ", exercicioProcessoAutorDesconto=" + this.getExercicioProcessoAutorDesconto() + ", processoAutorDesconto=" + this.getProcessoAutorDesconto() + ", dataLimiteNotificacao=" + this.getDataLimiteNotificacao() + ", gerarDebito=" + this.getGerarDebito() + ", idDebito=" + this.getIdDebito() + ", tipoTipoAutoInfracao=" + this.getTipoTipoAutoInfracao() + ", tipoTipoAutoInfracaoDecricao=" + this.getTipoTipoAutoInfracaoDecricao() + ", exercicioProcesso156=" + this.getExercicioProcesso156() + ", processo156=" + this.getProcesso156() + ", dataProcesso156=" + this.getDataProcesso156() + ", valorCreditoImposto=" + this.getValorCreditoImposto() + ", valorCreditoCorrecao=" + this.getValorCreditoCorrecao() + ", valorAutoAux=" + this.getValorAutoAux() + ", processoProconFA=" + this.getProcessoProconFA() + ", tipoProcesso=" + this.getTipoProcesso() + ", processoSei=" + this.getProcessoSei() + ", processoSeiCancelamento=" + this.getProcessoSeiCancelamento() + ", debitos=" + this.getDebitos() + ", penalidades=" + this.getPenalidades() + ", historicos=" + this.getHistoricos() + ")";
    }
}

