/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Contencioso;
import br.com.elotech.tributos.domain.DebitoObservacao;
import br.com.elotech.tributos.domain.DebitoObservacaoId;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DebitoProcesso;
import br.com.elotech.tributos.domain.DebitoProcessoId;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.DebitoTributoId;
import br.com.elotech.tributos.domain.DebitoTributoIsencao;
import br.com.elotech.tributos.domain.DebitoTributoIsencaoId;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.Isencao;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.GerarDebitoResponseDTO;
import br.com.elotech.tributos.exception.ParametroEntidadeExercicioNotFoundException;
import br.com.elotech.tributos.service.exception.GeracaoDebitoManualException;
import br.com.elotech.tributos.util.CalculoUtils;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="TRIBDEBITO")
public class Debito
implements Serializable,
EloEntity<Long> {
    private static final long serialVersionUID = 1L;
    @Id
    @EloSequence(sequenceName="S05IDDEBITO")
    @Column(name="iddebito")
    private Long id;
    @NotNull(message="Entidade \u00e9 obrigat\u00f3ria")
    private @NotNull(message="Entidade \u00e9 obrigat\u00f3ria") Long entidade;
    @NotNull(message="Exerc\u00edcio \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Exerc\u00edcio \u00e9 obrigat\u00f3rio") Long exercicio;
    @NotNull(message="Tipo Cadastro \u00e9 obrigat\u00f3rio")
    private @NotNull(message="Tipo Cadastro \u00e9 obrigat\u00f3rio") Long tipoCadastro;
    @NotNull(message="Cadastro Geral \u00e9 obrigat\u00f3rio")
    @Column(name="cadastroGeral")
    private @NotNull(message="Cadastro Geral \u00e9 obrigat\u00f3rio") Long cadastroGeralId;
    @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3ria")
    private @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3ria") Long guiaRecolhimento;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="tipoCadastro", referencedColumnName="tipoCadastro")), @JoinColumnOrFormula(formula=@JoinFormula(value="cadastroGeral", referencedColumnName="cadastroGeral"))})
    @JsonIgnore
    @MetaModelIgnore
    private CadastroGeral cadastroGeral;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(formula=@JoinFormula(value="exercicio", referencedColumnName="exercicio")), @JoinColumnOrFormula(formula=@JoinFormula(value="guiarecolhimento", referencedColumnName="guiarecolhimento"))})
    @JsonIgnore
    private Divida divida;
    @NotNull(message="Subdivida \u00e9 obrigat\u00f3ria")
    private @NotNull(message="Subdivida \u00e9 obrigat\u00f3ria") Long subDivida;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean reparcelado = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean parcelado = Boolean.FALSE;
    @NotNull(message="Forma de corre\u00e7\u00e3o \u00e9 obrigat\u00f3ria")
    @ManyToOne
    private @NotNull(message="Forma de corre\u00e7\u00e3o \u00e9 obrigat\u00f3ria") FormaCorrecao formaCorrecao;
    private LocalDate dataLancamento;
    @Length(max=4000, message="Tamanho m\u00e1ximo da observa\u00e7\u00e3o \u00e9 4000 caracteres")
    private @Length(max=4000, message="Tamanho m\u00e1ximo da observa\u00e7\u00e3o \u00e9 4000 caracteres") String observacao;
    @Length(max=1000, message="Tamanho m\u00e1ximo da observa\u00e7\u00e3o de revis\u00e3o \u00e9 1000 caracteres")
    private @Length(max=1000, message="Tamanho m\u00e1ximo da observa\u00e7\u00e3o de revis\u00e3o \u00e9 1000 caracteres") String observacaoRevisao;
    @Length(max=250, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 250 caracteres")
    private @Length(max=250, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 250 caracteres") String usuario;
    private LocalDate dataInclusao;
    private LocalDate dataPrimeiraParcela;
    private BigDecimal descontoImposto = BigDecimal.ZERO;
    private BigDecimal descontoLei2004 = BigDecimal.ZERO;
    @OneToMany(mappedBy="debito", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DebitoParcela> parcelas = new ArrayList();
    @OneToMany(mappedBy="debito", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DebitoTributo> tributos = new ArrayList();
    @OneToMany(mappedBy="debito", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DebitoObservacao> observacoes = new ArrayList();
    @OneToMany(mappedBy="debito", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DebitoProcesso> processos = new ArrayList();
    @ManyToOne
    @JoinColumn(name="isencaoIptu", referencedColumnName="isencao")
    private Isencao isencao;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="idcontencioso", referencedColumnName="idcontencioso")
    private Contencioso contencioso;
    private Long idContenciosoOrigem;
    private Long numeroParcela;
    private Boolean constituido = Boolean.FALSE;
    private String programa;
    private Long idParcelamento;
    private LocalDate dataContabilizacao;

    public CadastroGeralResumidoDTO getCadastroGeralResumido() {
        if (Objects.isNull(this.cadastroGeral)) {
            return null;
        }
        return CadastroGeralResumidoDTO.from((CadastroGeral)this.cadastroGeral);
    }

    public void setNumeroParcela() {
        this.numeroParcela = this.parcelas.size();
    }

    private void setParcelasId() {
        for (DebitoParcela parcela : this.parcelas) {
            if (Objects.isNull(parcela.getId())) {
                DebitoParcelaId debitoParcelaId = new DebitoParcelaId();
                parcela.setId(debitoParcelaId);
            }
            parcela.getId().setEntidade(this.getEntidade());
            parcela.getId().setExercicio(this.getExercicio());
            parcela.getId().setTipoCadastro(this.getTipoCadastro());
            parcela.getId().setCadastroGeral(this.getCadastroGeralId());
            parcela.getId().setDivida(this.getGuiaRecolhimento());
            parcela.getId().setSubDivida(this.getSubDivida());
            parcela.setObservacoesId();
        }
    }

    private void setTributosId() {
        for (DebitoTributo tributo : this.tributos) {
            if (Objects.isNull(tributo.getId())) {
                DebitoTributoId debitoTributoId = new DebitoTributoId();
                tributo.setId(debitoTributoId);
            }
            tributo.getId().setEntidade(this.getEntidade());
            tributo.getId().setExercicio(this.getExercicio());
            tributo.getId().setTipoCadastro(this.getTipoCadastro());
            tributo.getId().setCadastroGeral(this.getCadastroGeralId());
            tributo.getId().setDivida(this.getGuiaRecolhimento());
            tributo.getId().setSubDivida(this.getSubDivida());
            tributo.setIsencaoId();
        }
    }

    public void setObservacoesId() {
        for (int sequencia = 0; sequencia < this.observacoes.size(); ++sequencia) {
            DebitoObservacao debitoObservacao = (DebitoObservacao)this.observacoes.get(sequencia);
            if (Objects.isNull(debitoObservacao.getId())) {
                DebitoObservacaoId debitoObservacaoId = new DebitoObservacaoId();
                debitoObservacao.setId(debitoObservacaoId);
            }
            debitoObservacao.getId().setEntidade(this.getEntidade());
            debitoObservacao.getId().setExercicio(this.getExercicio());
            debitoObservacao.getId().setTipoCadastro(this.getTipoCadastro());
            debitoObservacao.getId().setCadastroGeral(this.getCadastroGeralId());
            debitoObservacao.getId().setDivida(this.getGuiaRecolhimento());
            debitoObservacao.getId().setSubDivida(this.getSubDivida());
            debitoObservacao.getId().setSequencia(Long.valueOf((long)sequencia + 1L));
        }
    }

    private void setProcessosId() {
        for (DebitoProcesso processo : this.processos) {
            if (Objects.isNull(processo.getId())) {
                DebitoProcessoId debitoProcessoId = new DebitoProcessoId();
                debitoProcessoId.setEntidade(this.getEntidade());
                processo.setId(debitoProcessoId);
            }
            processo.setExercicioDebito(this.getExercicio());
            processo.setTipoCadastro(this.getTipoCadastro());
            processo.setCadastroGeral(this.getCadastroGeralId());
            processo.setDivida(this.getGuiaRecolhimento());
            processo.setSubDivida(this.getSubDivida());
            processo.setDebito(this);
        }
    }

    public void setChildrenId() {
        this.setParcelasId();
        this.setTributosId();
        this.setObservacoesId();
        this.setProcessosId();
    }

    public void generateDebitoParcelaTributo(Boolean permiteValorZero) {
        DebitoParcela primeiraParcela = this.getPrimeiraParcela();
        for (DebitoParcela parcela : this.parcelas) {
            List debitoParcelaTributos = this.tributos.stream().filter(tributo -> tributo.isZerado() == false || tributo.isZerado() != false && permiteValorZero != false).map(tributo -> {
                DebitoParcelaTributo parcelaTributo = new DebitoParcelaTributo();
                parcelaTributo.setDebitoParcela(parcela);
                parcelaTributo.setTributo(tributo.getId().getTributo());
                parcelaTributo.setValorDesconto(tributo.getValorDesconto());
                if (primeiraParcela.getId().getParcela().equals(parcela.getId().getParcela())) {
                    parcelaTributo.setValor(CalculoUtils.divideESomaValorDiferenca((BigDecimal)tributo.getValorTotal(), (Integer)this.parcelas.size(), (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS));
                    parcelaTributo.setValorOriginal(CalculoUtils.divideESomaValorDiferenca((BigDecimal)tributo.getValorTributo(), (Integer)this.parcelas.size(), (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS));
                } else {
                    parcelaTributo.setValor(CalculoUtils.divideETruncaValor((BigDecimal)tributo.getValorTotal(), (Integer)this.parcelas.size(), (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS));
                    parcelaTributo.setValorOriginal(CalculoUtils.divideETruncaValor((BigDecimal)tributo.getValorTributo(), (Integer)this.parcelas.size(), (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS));
                }
                return parcelaTributo;
            }).collect(Collectors.toList());
            parcela.getTributos().addAll(debitoParcelaTributos);
        }
    }

    public void generateDebitoParcelaTributoComPercentualDeEntrada(Boolean permiteValorZero, BigDecimal percentualEntrada) {
        DebitoParcela primeiraParcela = this.getPrimeiraParcela();
        BigDecimal percentualEntradaFinal = percentualEntrada.divide(BigDecimal.valueOf(100L));
        for (DebitoParcela parcela : this.parcelas) {
            List debitoParcelaTributos = this.tributos.stream().filter(tributo -> tributo.isZerado() == false || tributo.isZerado() != false && permiteValorZero != false).map(tributo -> {
                DebitoParcelaTributo parcelaTributo = new DebitoParcelaTributo();
                parcelaTributo.setDebitoParcela(parcela);
                parcelaTributo.setTributo(tributo.getId().getTributo());
                parcelaTributo.setValorDesconto(tributo.getValorDesconto());
                int quantidadeParcelas = this.parcelas.size() - 1;
                if (primeiraParcela.getId().getParcela().equals(parcela.getId().getParcela())) {
                    parcelaTributo.setValor(CalculoUtils.divideESomaValorDiferencaComEntrada((BigDecimal)tributo.getValorTotal(), (BigDecimal)percentualEntradaFinal, (Integer)quantidadeParcelas, (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS));
                    parcelaTributo.setValorOriginal(CalculoUtils.divideESomaValorDiferencaComEntrada((BigDecimal)tributo.getValorTributo(), (BigDecimal)percentualEntradaFinal, (Integer)quantidadeParcelas, (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS));
                } else {
                    parcelaTributo.setValor(CalculoUtils.divideETruncaValor((BigDecimal)tributo.getValorTotal().subtract(primeiraParcela.getValorTotal()), (Integer)quantidadeParcelas, (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS));
                    parcelaTributo.setValorOriginal(CalculoUtils.divideETruncaValor((BigDecimal)tributo.getValorTributo().subtract(primeiraParcela.getValorTotal()), (Integer)quantidadeParcelas, (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS));
                }
                return parcelaTributo;
            }).collect(Collectors.toList());
            parcela.getTributos().addAll(debitoParcelaTributos);
        }
    }

    @JsonIgnore
    public List<DebitoParcelaTributo> getAllDebitoParcelaTributo() {
        return this.getParcelas().stream().map(DebitoParcela::getTributos).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void validaTributoDuplicado() {
        List listaTributos = this.tributos.stream().map(DebitoTributo::getId).map(DebitoTributoId::getTributo).collect(Collectors.toList());
        Optional<String> tributoDuplicado = listaTributos.stream().filter(tributo -> Collections.frequency(listaTributos, tributo) > 1).findFirst();
        if (tributoDuplicado.isPresent()) {
            throw GeracaoDebitoManualException.tributoDuplicado((String)tributoDuplicado.get());
        }
    }

    private void validaValoresDebito(Divida divida) {
        BigDecimal valorTotalTributo;
        BigDecimal valorTotalParcelaTributo = this.getParcelas().stream().map(DebitoParcela::getValorTotal).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (valorTotalParcelaTributo.compareTo(valorTotalTributo = this.getTributos().stream().map(DebitoTributo::getValorTotal).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)) != 0) {
            throw GeracaoDebitoManualException.valorParcelaDifereTributo((BigDecimal)valorTotalTributo, (BigDecimal)valorTotalParcelaTributo);
        }
        if (valorTotalTributo.compareTo(BigDecimal.ZERO) == 0 && !divida.getPermiteLancarValorZero().booleanValue()) {
            throw GeracaoDebitoManualException.tributoSemValor();
        }
    }

    @JsonIgnore
    public DebitoParcela getPrimeiraParcela() {
        return this.getParcelas().stream().min(Comparator.comparingLong(p -> p.getId().getParcela())).orElseThrow(() -> new EloValidationException("H\u00e1 uma inconsist\u00eancia na quantidade de parcelas do d\u00e9bito."));
    }

    public void setDataPrimeiraParcela() {
        this.dataPrimeiraParcela = this.getPrimeiraParcela().getDataVencimento();
    }

    private void validaDebitoTributo(Divida divida) {
        for (DebitoTributo debitoTributo : this.tributos) {
            if (divida.hasTributo(debitoTributo.getId().getTributo()).booleanValue()) continue;
            throw GeracaoDebitoManualException.tributoSemRelacaoDivida((String)debitoTributo.getId().getTributo(), (Long)divida.getDivida());
        }
    }

    public void validaGeracaoDebitoManual(Divida divida) {
        this.validaTributoDuplicado();
        this.validaValoresDebito(divida);
        this.validaDebitoTributo(divida);
    }

    @JsonIgnore
    public Long getNextNumeroParcela() {
        return this.getParcelas().stream().map(DebitoParcela::getId).map(DebitoParcelaId::getParcela).reduce(0L, Long::max) + 1L;
    }

    @JsonIgnore
    public Long getNextSequenciaObservacao() {
        return this.getObservacoes().stream().map(DebitoObservacao::getId).map(DebitoObservacaoId::getNextSequencia).reduce(1L, Long::max);
    }

    @JsonIgnore
    public Optional<DebitoTributo> getDebitoTributoByTributo(String tributo) {
        return this.getTributos().stream().filter(debitoTributo -> debitoTributo.getId().getTributo().equals(tributo)).findFirst();
    }

    @JsonIgnore
    public BigDecimal getValorTotalDebito() {
        return this.getTributos().stream().map(debitoTributo -> Optional.ofNullable(debitoTributo.getValorTributo()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(debitoTributo.getValorRenuncia()).orElse(BigDecimal.ZERO))).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public DebitoParcela getParcela(Long parcela) {
        return this.parcelas.stream().filter(debitoParcela -> parcela.equals(debitoParcela.getId().getParcela())).findFirst().orElse(null);
    }

    public Boolean hasParcelaMenorValorMinimo(BigDecimal valorMinimo) {
        return this.getParcelas().stream().anyMatch(parcela -> parcela.getValorTotal().compareTo(valorMinimo) < 0 && parcela.getValorTotal().compareTo(BigDecimal.ZERO) > 0);
    }

    public void removeUltimaParcela() {
        if (this.getParcelas().size() > 0) {
            this.getParcelas().sort(Comparator.comparing(debitoParcela -> debitoParcela.getId().getParcela()));
            this.getParcelas().remove(this.getParcelas().size() - 1);
        }
    }

    public void verifyAndApplyValorMinimoDebito(ParametroEntidadeExercicio parametroIsencaoValorMinimoDebito) {
        if (this.getDivida().getValorMinimoDebito().compareTo(this.getValorTotalDebito()) > 0 && this.getValorTotalDebito().compareTo(BigDecimal.ZERO) > 0) {
            if (Objects.isNull(parametroIsencaoValorMinimoDebito) || StringUtils.isBlank((String)parametroIsencaoValorMinimoDebito.getValor())) {
                throw new ParametroEntidadeExercicioNotFoundException(String.format("N\u00e3o h\u00e1 configura\u00e7\u00e3o de isen\u00e7\u00e3o para o valor m\u00ednimo do d\u00e9bito. Par\u00e2metro %s n\u00e3o encontrado para o exerc\u00edcio %d.", ParametroEntidadeExercicioEnum.ISENCAO_VALORMINIMO_DEBITO.getValue(), this.getExercicio()));
            }
            this.getTributos().stream().filter(debitoTributo -> debitoTributo.getValorTotal().compareTo(BigDecimal.ZERO) > 0).forEach(debitoTributo -> {
                DebitoTributoIsencaoId debitoTributoIsencaoId = new DebitoTributoIsencaoId();
                debitoTributoIsencaoId.setIsencao(Long.valueOf(parametroIsencaoValorMinimoDebito.getValor()));
                DebitoTributoIsencao debitoTributoIsencao = new DebitoTributoIsencao();
                debitoTributoIsencao.setId(debitoTributoIsencaoId);
                debitoTributoIsencao.setValorIsencao(debitoTributo.getValorTotal());
                debitoTributoIsencao.setTributo(debitoTributo);
                debitoTributo.setValorRenuncia(Optional.ofNullable(debitoTributo.getValorRenuncia()).orElse(BigDecimal.ZERO).add(debitoTributo.getValorTotal()));
                debitoTributo.getIsencoes().add(debitoTributoIsencao);
            });
        }
    }

    public void verifyAndApplyValorMinimoParcela() {
        while (Boolean.TRUE.equals(this.hasParcelaMenorValorMinimo(this.getDivida().getValorMinimoParcela()))) {
            if (this.getParcelas().size() == 1) {
                throw new EloValidationException(String.format("Valor total do d\u00e9bito %.2f n\u00e3o atende a restri\u00e7\u00e3o de valor m\u00ednimo da parcela %.2f para cadastro %d/%d e d\u00edvida %d - %s.", this.getValorTotalDebito(), this.getDivida().getValorMinimoParcela(), this.getTipoCadastro(), this.getCadastroGeralId(), this.getDivida().getDivida(), this.getDivida().getDescricao()));
            }
            this.removeUltimaParcela();
            this.getParcelas().forEach(parcela -> parcela.getTributos().clear());
            this.generateDebitoParcelaTributo(Boolean.TRUE);
        }
    }

    public void verifyNumeroMinimoParcela() {
        if (this.getDivida().getNumeroMinimoParcela() > (long)this.parcelas.size()) {
            throw new EloValidationException(String.format("Quantidade de parcelas %d n\u00e3o atende a restri\u00e7\u00e3o de quantidade m\u00ednima %d para cadastro %d/%d e d\u00edvida %d - %s.", this.parcelas.size(), this.getDivida().getNumeroMinimoParcela(), this.getTipoCadastro(), this.getCadastroGeralId(), this.getDivida().getDivida(), this.getDivida().getDescricao()));
        }
    }

    public GerarDebitoResponseDTO toGerarDebitoResponseDTO() {
        GerarDebitoResponseDTO gerarDebitoResponseDTO = new GerarDebitoResponseDTO();
        gerarDebitoResponseDTO.setIdDebito(this.getId());
        gerarDebitoResponseDTO.setCadastroGeral(this.getCadastroGeralId());
        gerarDebitoResponseDTO.setEntidade(this.getEntidade());
        gerarDebitoResponseDTO.setExercicio(this.getExercicio());
        gerarDebitoResponseDTO.setParcela(this.getNumeroParcela());
        gerarDebitoResponseDTO.setSubDivida(this.getSubDivida());
        gerarDebitoResponseDTO.setGuiaRecolhimento(this.getGuiaRecolhimento());
        gerarDebitoResponseDTO.setTipoCadastro(this.getTipoCadastro());
        return gerarDebitoResponseDTO;
    }

    public boolean isParceladoOrReparcelado() {
        return Boolean.TRUE.equals(this.parcelado) || Boolean.TRUE.equals(this.reparcelado);
    }

    public Debito copy(CadastroGeral newCadastro, Long newSubDivida, String newObservacao) {
        Debito debito = new Debito();
        BeanUtils.copyProperties((Object)this, (Object)debito, (String[])new String[]{"id", "cadastroGeral", "tipoCadastro", "cadastroGeralId", "subDivida", "parcelas", "numeroParcela", "tributos", "observacoes", "processos", "programa"});
        debito.setCadastroGeral(newCadastro);
        debito.setCadastroGeralId(newCadastro.getCadastroGeral());
        debito.setTipoCadastro(newCadastro.getTipoCadastro().getValue());
        debito.setSubDivida(newSubDivida);
        debito.setObservacoes(new ArrayList<DebitoObservacao>(List.of(DebitoObservacao.from((Debito)debito, (String)newObservacao))));
        debito.setPrograma("TransferenciaDebito");
        return debito;
    }

    @Generated
    public Debito() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeralId() {
        return this.cadastroGeralId;
    }

    @Generated
    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Divida getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Boolean getReparcelado() {
        return this.reparcelado;
    }

    @Generated
    public Boolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public FormaCorrecao getFormaCorrecao() {
        return this.formaCorrecao;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getObservacaoRevisao() {
        return this.observacaoRevisao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataPrimeiraParcela() {
        return this.dataPrimeiraParcela;
    }

    @Generated
    public BigDecimal getDescontoImposto() {
        return this.descontoImposto;
    }

    @Generated
    public BigDecimal getDescontoLei2004() {
        return this.descontoLei2004;
    }

    @Generated
    public List<DebitoParcela> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public List<DebitoTributo> getTributos() {
        return this.tributos;
    }

    @Generated
    public List<DebitoObservacao> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public List<DebitoProcesso> getProcessos() {
        return this.processos;
    }

    @Generated
    public Isencao getIsencao() {
        return this.isencao;
    }

    @Generated
    public Contencioso getContencioso() {
        return this.contencioso;
    }

    @Generated
    public Long getIdContenciosoOrigem() {
        return this.idContenciosoOrigem;
    }

    @Generated
    public Long getNumeroParcela() {
        return this.numeroParcela;
    }

    @Generated
    public Boolean getConstituido() {
        return this.constituido;
    }

    @Generated
    public String getPrograma() {
        return this.programa;
    }

    @Generated
    public Long getIdParcelamento() {
        return this.idParcelamento;
    }

    @Generated
    public LocalDate getDataContabilizacao() {
        return this.dataContabilizacao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeralId(Long cadastroGeralId) {
        this.cadastroGeralId = cadastroGeralId;
    }

    @Generated
    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @JsonIgnore
    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @JsonIgnore
    @Generated
    public void setDivida(Divida divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setReparcelado(Boolean reparcelado) {
        this.reparcelado = reparcelado;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setFormaCorrecao(FormaCorrecao formaCorrecao) {
        this.formaCorrecao = formaCorrecao;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setObservacaoRevisao(String observacaoRevisao) {
        this.observacaoRevisao = observacaoRevisao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataPrimeiraParcela(LocalDate dataPrimeiraParcela) {
        this.dataPrimeiraParcela = dataPrimeiraParcela;
    }

    @Generated
    public void setDescontoImposto(BigDecimal descontoImposto) {
        this.descontoImposto = descontoImposto;
    }

    @Generated
    public void setDescontoLei2004(BigDecimal descontoLei2004) {
        this.descontoLei2004 = descontoLei2004;
    }

    @Generated
    public void setParcelas(List<DebitoParcela> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setTributos(List<DebitoTributo> tributos) {
        this.tributos = tributos;
    }

    @Generated
    public void setObservacoes(List<DebitoObservacao> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setProcessos(List<DebitoProcesso> processos) {
        this.processos = processos;
    }

    @Generated
    public void setIsencao(Isencao isencao) {
        this.isencao = isencao;
    }

    @JsonIgnore
    @Generated
    public void setContencioso(Contencioso contencioso) {
        this.contencioso = contencioso;
    }

    @Generated
    public void setIdContenciosoOrigem(Long idContenciosoOrigem) {
        this.idContenciosoOrigem = idContenciosoOrigem;
    }

    @Generated
    public void setNumeroParcela(Long numeroParcela) {
        this.numeroParcela = numeroParcela;
    }

    @Generated
    public void setConstituido(Boolean constituido) {
        this.constituido = constituido;
    }

    @Generated
    public void setPrograma(String programa) {
        this.programa = programa;
    }

    @Generated
    public void setIdParcelamento(Long idParcelamento) {
        this.idParcelamento = idParcelamento;
    }

    @Generated
    public void setDataContabilizacao(LocalDate dataContabilizacao) {
        this.dataContabilizacao = dataContabilizacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Debito)) {
            return false;
        }
        Debito other = (Debito)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Debito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Debito(id=" + this.getId() + ")";
    }
}

