/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.dto.ParametroTesteScriptDTO;
import br.com.elotech.tributos.calculo.repository.ProjetoCalculoRepository;
import br.com.elotech.tributos.calculo.service.CalculoBuild;
import br.com.elotech.tributos.calculo.service.CalculoExecucaoBaseService;
import br.com.elotech.tributos.calculo.service.CalculoParser;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.calculo.CalculoProjeto;
import br.com.elotech.tributos.domain.calculo.OrigemDadosCalculo;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.params.CalculoProjetoParams;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Service;

@Service
public class CalculoProjetoExecucaoService
extends CalculoExecucaoBaseService<CalculoProjeto, ProjetoPK> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculoProjetoExecucaoService.class);
    private final ProjetoCalculoRepository projetoCalculoRepository;

    public CalculoProjetoExecucaoService(ConversionService conversionService, TabelaValorService tabelaValorService, ProjetoCalculoRepository projetoCalculoRepository) {
        super(conversionService, tabelaValorService);
        this.projetoCalculoRepository = projetoCalculoRepository;
    }

    public CalculoCadastro testarScript(ParametroTesteScriptDTO parametroTestScriptDTO) {
        CalculoProjeto calculoProjeto = parametroTestScriptDTO.getCalculoProjeto();
        Long entidade = parametroTestScriptDTO.getEntidade();
        Long projeto = parametroTestScriptDTO.getProjeto();
        Long exercicio = parametroTestScriptDTO.getExercicioProjeto();
        Long projetoItem = parametroTestScriptDTO.getProjetoItem();
        calculoProjeto.setIdentificadorResultado(parametroTestScriptDTO.getIdentificador());
        calculoProjeto.setIdentificadorBaseCalculo(null);
        CalculoBuild.buildCalculoDebugMode((List)calculoProjeto.getScript(), CalculoParser::parseLinhaDebugMode, (OrigemDadosCalculo)OrigemDadosCalculo.PROJETO);
        List resultados = this.calcular(Collections.singletonList(calculoProjeto), calculoProjeto.getExercicio(), this.buildFiltro(entidade, exercicio, projeto, projetoItem), null, Boolean.TRUE, LocalDate.now());
        return resultados.stream().findFirst().map(CalculoCadastro::fromCalculoProjeto).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel fazer o teste do script de avalia\u00e7\u00e3o."));
    }

    public List<CadastroCalculoRoot<ProjetoPK>> calcular(List<CalculoProjeto> calculoProjetos, CalculoProjetoParams params, Long exercicio) {
        String filtro = this.buildFiltro(params.getEntidade(), params.getExercicio(), params.getProjeto(), params.getProjetoItem());
        return super.calcular(calculoProjetos, exercicio, filtro, params.getProjetoItem(), Boolean.valueOf(false), null, null);
    }

    public String buildFiltro(Long entidade, Long exercicio, Long projeto, Long projetoItem) {
        String filtroProjeto = String.format(" projeto.entidade = %s and projeto.exercicio = %s and projeto.projeto = %s ", entidade, exercicio, projeto);
        String filtroProjetoItem = Objects.nonNull(projetoItem) ? String.format(" and projetoitem.projetoitem = %s ", projetoItem) : "";
        return filtroProjeto.concat(filtroProjetoItem);
    }

    protected List<CadastroCalculoRoot<ProjetoPK>> loadCadastros(List<CalculoProjeto> configs, String filtro, Long segmento, Long exercicio, Set<CampoDinamicoScriptDTO> camposDinamicos, LocalDate dataReferencia) {
        super.beforeLoadCadastros(configs);
        return this.projetoCalculoRepository.loadCadastros(filtro, exercicio.longValue());
    }
}

