/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.movimentacaomensal;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.batch.simam.movimentacaomensal.MovimentacaoMensalAtualizaSaldo;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class MovimentacaoMensalJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MovimentacaoMensalJobListener.class);
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final MovimentacaoMensalAtualizaSaldo movimentacaoMensalAtualizaSaldo;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Optional notificacaoId = this.notificacaoService.send("SIM-AM - Movimenta\u00e7\u00e3o Mensal iniciada", String.format("Foi iniciada a gera\u00e7\u00e3o de dados de Movimenta\u00e7\u00e3o Mensal - %s -> %s", dataInicial, dataFinal), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        this.movimentacaoMensalAtualizaSaldo.atualizarValoresEmArquivos(dataInicial, dataFinal);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("SIM-AM - Movimenta\u00e7\u00e3o Mensal finalizada com sucesso", String.format("Os dados referentes a Movimenta\u00e7\u00e3o Mensal no per\u00edodo %s -> %s foram gerados com sucesso.", dataInicial, dataFinal), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("SIM-AM - Erro na gera\u00e7\u00e3o de dados - Movimenta\u00e7\u00e3o Mensal", "N\u00e3o foi poss\u00edvel gerar os dados.", jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public MovimentacaoMensalJobListener(NotificacaoService notificacaoService, MovimentacaoMensalAtualizaSaldo movimentacaoMensalAtualizaSaldo) {
        this.notificacaoService = notificacaoService;
        this.movimentacaoMensalAtualizaSaldo = movimentacaoMensalAtualizaSaldo;
    }
}

