/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.relatoriogerencialarrecadacao.lancamentoarrecadacao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.ArrecadacaoAnual;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.ArrecadacaoAnualId;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.relatoriogerencial.lancamentoarrecadacao.ArrecadacaoAnualService;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class LancamentoArrecadacaoJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LancamentoArrecadacaoJobListener.class);
    private final NotificacaoService notificacaoService;
    private final ArrecadacaoAnualService arrecadacaoAnualService;
    private static final String ID_NOTIFICACAO = "idNotificacao";

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long exercicio = jobExecution.getJobParameters().getLong("exercicio");
        Long mes = jobExecution.getJobParameters().getLong("mesAnalise");
        String notificacao = String.format("Iniciada a atualiza\u00e7\u00e3o do lan\u00e7amento x arrecada\u00e7\u00e3o referente ao m\u00eas/ano %d/%d.", mes, exercicio);
        Optional notificacaoId = this.notificacaoService.send(notificacao, null, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        NotificationStatus status;
        super.afterJob(jobExecution);
        Long entidade = jobExecution.getJobParameters().getLong("entidade");
        Long exercicio = jobExecution.getJobParameters().getLong("exercicio");
        Long mes = jobExecution.getJobParameters().getLong("mesAnalise");
        ArrecadacaoAnualId id = ArrecadacaoAnualId.of((Long)entidade, (Long)exercicio);
        ArrecadacaoAnual arrecadacaoAnual = (ArrecadacaoAnual)this.arrecadacaoAnualService.findOne((Serializable)id);
        arrecadacaoAnual.setBatchJobExecution(BatchJobExecution.of((JobExecution)jobExecution));
        this.arrecadacaoAnualService.save((EloEntity)arrecadacaoAnual, null);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        String notificacao = "";
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao = String.format("Finalizada a atualiza\u00e7\u00e3o do lan\u00e7amento x arrecada\u00e7\u00e3o referente ao m\u00eas/ano %d/%d", mes, exercicio);
            status = NotificationStatus.COMPLETED;
        } else {
            notificacao = String.format("Ocorreu um erro na atualiza\u00e7\u00e3o do lan\u00e7amento x arrecada\u00e7\u00e3o referente ao m\u00eas/ano %d/%d", mes, exercicio);
            status = NotificationStatus.FAILED;
        }
        this.notificacaoService.send(notificacao, null, jobExecution, Optional.of(notificacaoId), status);
    }

    @Generated
    public LancamentoArrecadacaoJobListener(NotificacaoService notificacaoService, ArrecadacaoAnualService arrecadacaoAnualService) {
        this.notificacaoService = notificacaoService;
        this.arrecadacaoAnualService = arrecadacaoAnualService;
    }
}

