/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto.importacaoretornoremessa;

import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.enums.SituacaoProtesto;
import br.com.elotech.tributos.repository.ProtestoRemessaItemRepository;
import br.com.elotech.tributos.service.ProtestoService;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ImportacaoRetornoRemessaBatchWriter
implements ItemWriter<ProtestoRemessaItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoRetornoRemessaBatchWriter.class);
    private final ProtestoRemessaItemRepository protestoRemessaItemRepository;
    private final ProtestoService protestoService;
    private final EntityManager entityManager;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends ProtestoRemessaItem> items) throws Exception {
        items.forEach(item -> {
            if (item.getIrregularidade0() != null && !SituacaoProtesto.CANCELADO.equals((Object)item.getProtesto().getSituacao())) {
                this.protestoService.cancelarProtesto(item.getProtesto().getId());
            }
        });
        this.protestoRemessaItemRepository.saveAll(items);
        this.entityManager.flush();
    }

    @AfterWrite
    public void afterWrite(List<? extends ProtestoRemessaItem> items) {
        Long idProtestoRemessa = this.stepExecution.getJobExecution().getJobParameters().getLong("idProtestoRemessa");
        int quantidadeProcessada = this.stepExecution.getReadCount() + items.size();
        log.info("Finalizado chunk da importa\u00e7\u00e3o do arquivo retorno do protesto remessa {}. Itens processados at\u00e9 o momento {}", (Object)idProtestoRemessa, (Object)quantidadeProcessada);
    }

    @Generated
    public ImportacaoRetornoRemessaBatchWriter(ProtestoRemessaItemRepository protestoRemessaItemRepository, ProtestoService protestoService, EntityManager entityManager) {
        this.protestoRemessaItemRepository = protestoRemessaItemRepository;
        this.protestoService = protestoService;
        this.entityManager = entityManager;
    }
}

