/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.estornoatualizacaomonetaria;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.AtualizacaoMonetariaService;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class EstornoAtualizacaoMonetariaParcelamentoBatchListener
extends JobExecutionListenerSupport {
    private final NotificacaoService notificacaoService;
    private final AtualizacaoMonetariaService atualizacaoMonetariaService;
    private static final String ID_NOTIFICACAO = "idNotificacao";

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idEstornoAtualizacaoMonetaria = jobExecution.getJobParameters().getLong("idEstornoAtualizacaoMonetaria");
        Optional notificacaoId = this.notificacaoService.send("Estorno de Atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento iniciada.", String.format("O estorno da atualiza\u00e7\u00e3o monet\u00e1ria com c\u00f3digo %d foi iniciada.", idEstornoAtualizacaoMonetaria), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idEstornoAtualizacaoMonetaria = jobExecution.getJobParameters().getLong("idEstornoAtualizacaoMonetaria");
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("O estorno da atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento finalizada.", String.format("O estorno da atualiza\u00e7\u00e3o monet\u00e1ria com c\u00f3digo %d foi finalizada com sucesso.", idEstornoAtualizacaoMonetaria), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
            this.atualizacaoMonetariaService.marcarComoEstornado(idEstornoAtualizacaoMonetaria);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento falhou.", String.format("A atualiza\u00e7\u00e3o monet\u00e1ria com c\u00f3digo %d foi finalizada com erro", idEstornoAtualizacaoMonetaria), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public EstornoAtualizacaoMonetariaParcelamentoBatchListener(NotificacaoService notificacaoService, AtualizacaoMonetariaService atualizacaoMonetariaService) {
        this.notificacaoService = notificacaoService;
        this.atualizacaoMonetariaService = atualizacaoMonetariaService;
    }
}

