/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.debitoautomatico.remessa;

import br.com.elotech.tributos.domain.DebitoAutomaticoRemessa;
import br.com.elotech.tributos.domain.DebitoAutomaticoRemessaDetalhe;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.GeraBoletoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.debitoautomatico.DebitoAutomaticoRemessaItemDTO;
import br.com.elotech.tributos.repository.DebitoAutomaticoRemessaRepository;
import br.com.elotech.tributos.service.AiseBloquetoService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class RemessaArquivoDebitoAutomaticoProcessor
implements ItemProcessor<DebitoAutomaticoRemessaItemDTO, DebitoAutomaticoRemessaDetalhe> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemessaArquivoDebitoAutomaticoProcessor.class);
    private final AiseBloquetoService aiseBloquetoService;
    private final DebitoAutomaticoRemessaRepository debitoAutomaticoRemessaRepository;
    private DebitoAutomaticoRemessa remessa;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        Long idRemessa = stepExecution.getJobExecution().getJobParameters().getLong("idRemessa");
        this.remessa = (DebitoAutomaticoRemessa)this.debitoAutomaticoRemessaRepository.findOne((Object)idRemessa);
    }

    public DebitoAutomaticoRemessaDetalhe process(DebitoAutomaticoRemessaItemDTO item) {
        GeraBoletoPorFormaPagamentoDTO params = new GeraBoletoPorFormaPagamentoDTO();
        params.setIdDebito(item.getIdDebito());
        params.setFormaPagamento(item.getFormaPagamento());
        BloquetoDTO bloquetoDTO = this.aiseBloquetoService.geraBoletoPorFormaPagamento(params);
        DebitoAutomaticoRemessaDetalhe detalhe = new DebitoAutomaticoRemessaDetalhe();
        detalhe.setDebitoAutomaticoRemessa(this.remessa);
        detalhe.setEntidade(item.getEntidade());
        detalhe.setExercicio(item.getExercicio());
        detalhe.setTipoCadastro(item.getTipoCadastro());
        detalhe.setCadastroGeral(item.getCadastroGeral());
        detalhe.setDivida(item.getGuiaRecolhimento());
        detalhe.setSubDivida(item.getSubDivida());
        detalhe.setExercicioBloqueto(bloquetoDTO.getExercicioBloqueto());
        detalhe.setNumeroBloqueto(bloquetoDTO.getBloqueto());
        return detalhe;
    }

    @Generated
    public RemessaArquivoDebitoAutomaticoProcessor(AiseBloquetoService aiseBloquetoService, DebitoAutomaticoRemessaRepository debitoAutomaticoRemessaRepository) {
        this.aiseBloquetoService = aiseBloquetoService;
        this.debitoAutomaticoRemessaRepository = debitoAutomaticoRemessaRepository;
    }
}

