/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.contenciosorecalculo;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ContenciosoDebito;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.contencioso.ContenciosoRecalculoGerarBoletoBatchDTO;
import br.com.elotech.tributos.service.DebitoCarneService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.util.AgrupaDebitos;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ContenciosoRecalculoBoletoProcessor
implements ItemProcessor<ContenciosoDebito, ContenciosoRecalculoGerarBoletoBatchDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContenciosoRecalculoBoletoProcessor.class);
    private final DebitoCarneService debitoCarneService;
    private final GeraBoletoService geraBoletoService;
    private final ModeloBoletoService modeloBoletoService;
    private List<Long> formasDePagamento = new ArrayList();
    private StepExecution stepExecution;
    private ObjectMapper objectMapper;
    private Boolean gerarCarne = Boolean.FALSE;

    public ContenciosoRecalculoBoletoProcessor(DebitoCarneService debitoCarneService, GeraBoletoService geraBoletoService, ModeloBoletoService modeloBoletoService, ObjectMapper objectMapper) {
        this.debitoCarneService = debitoCarneService;
        this.geraBoletoService = geraBoletoService;
        this.modeloBoletoService = modeloBoletoService;
        this.objectMapper = objectMapper;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) throws JsonProcessingException {
        this.stepExecution = stepExecution;
        CollectionType type = this.objectMapper.getTypeFactory().constructCollectionType(List.class, Long.class);
        this.formasDePagamento = Objects.requireNonNull((List)this.objectMapper.readValue(this.stepExecution.getJobExecution().getJobParameters().getString("formasDePagamento"), (JavaType)type));
        this.gerarCarne = Boolean.parseBoolean(Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getString("gerarCarne")));
    }

    private List<Bloqueto> createBoletos(Debito debito, LocalDate dataReferencia) {
        List parcelas = debito.getParcelas().stream().map(dp -> DebitoParcelaDTO.from((Long)debito.getId(), (Long)dp.getId().getParcela())).distinct().collect(Collectors.toList());
        ModeloBoleto modeloBoleto = this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setDataReferencia(dataReferencia);
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE_WEB);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.PARCELADO);
        geraBoletoDTO.setSomenteConstituidos(Boolean.TRUE);
        geraBoletoDTO.setDebitos(parcelas);
        geraBoletoDTO.setModeloBoleto(modeloBoleto);
        return this.geraBoletoService.geraBoleto(geraBoletoDTO);
    }

    private DebitoCarneDTO createCarne(Debito debito) {
        DebitoCarneDTO debitoCarneDTO = DebitoCarneDTO.from((Debito)debito);
        List formasPagamento = this.debitoCarneService.findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(debitoCarneDTO.getIdDebito(), Boolean.FALSE);
        AgrupaDebitos.agrupaDebitosPorDebitoEFormaPagamento((List)formasPagamento).stream().filter(fp -> this.formasDePagamento.contains(fp.getFormaPagamento())).forEach(arg_0 -> ((DebitoCarneDTO)debitoCarneDTO).addFormaPagamento(arg_0));
        return debitoCarneDTO;
    }

    public ContenciosoRecalculoGerarBoletoBatchDTO process(ContenciosoDebito contenciosoDebito) throws JsonProcessingException {
        ContenciosoRecalculoGerarBoletoBatchDTO dto = new ContenciosoRecalculoGerarBoletoBatchDTO();
        if (Boolean.TRUE.equals(this.gerarCarne)) {
            DebitoCarneDTO debitoCarneDTO = this.createCarne(contenciosoDebito.getDebitoRecalculo());
            debitoCarneDTO.setRecalculo(Boolean.TRUE);
            dto.setDebitoCarneDTO(debitoCarneDTO);
        } else {
            List bloquetos = this.createBoletos(contenciosoDebito.getDebitoRecalculo(), LocalDate.now());
            dto.setBloquetos(bloquetos);
        }
        return dto;
    }
}

