/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.geracaocda;

import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.dto.BooleanSimNao;
import br.com.elotech.tributos.dto.ComunicadoLoteGeracaoCdaDTO;
import java.time.LocalDate;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JpaPagingItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoGeracaoCdaBatchReader
extends JpaPagingItemReader<ComunicadoLoteGeracaoCdaDTO> {
    private static final String ID_LOTE_SIMULACAO = "idLoteSimulacao";
    private static final String SELECT = " select new br.com.elotech.tributos.dto.ComunicadoLoteGeracaoCdaDTO(   tli.id as idLoteItem,   lote.situacao as situacaoLote,   ps.id as idPessoa,   ps.nome as nomepessoa,   tcg.tipoCadastro,   tcg.cadastroGeral,   tcg.id,   SUM(tlid.valor) as valor,   SUM(tlid.valorJuros) as valorJuros,   SUM(tlid.valorMulta) as valorMulta,   SUM(tlid.valorCorrecao) as valorCorrecao) from LoteCdaItem tli   join tli.lote lote   join tli.itemDetalhes tlid   join tli.cadastroGeral tcg   join tcg.pessoa ps where lote.id = :idLoteSimulacao and lote.situacao = :situacaoLote";
    private static final String ANDVALIDACAODUPLICADO = " and not exists ( select 1 from Comunicado tc join tc.cadastros tcc join tcc.cadastroGeral tcg2 where tcg.id = tcg2.id and tc.dataValidade >= :dataReferencia)";
    private static final String SQLGROUPBY = " group by tli.id, lote.situacao, tcg.tipoCadastro, tcg.cadastroGeral, tcg.id, ps.id, ps.nome";

    public ComunicadoGeracaoCdaBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, EntityManagerFactory entityManagerFactory) {
        Map<String, Object> params;
        Long idLoteSimulacao = (Long)jobParameters.get(ID_LOTE_SIMULACAO);
        this.setPageSize(500);
        this.setName(ID_LOTE_SIMULACAO);
        this.setEntityManagerFactory(entityManagerFactory);
        BooleanSimNao validacaoComunicadoDuplicado = BooleanSimNao.fromValue((String)((String)jobParameters.get("VALIDACOMUNICADODUPLICADO")));
        StringBuilder sql = new StringBuilder(SELECT);
        if (BooleanSimNao.SIM.equals((Object)validacaoComunicadoDuplicado)) {
            sql.append(ANDVALIDACAODUPLICADO);
            params = Map.of(ID_LOTE_SIMULACAO, idLoteSimulacao, "situacaoLote", SituacaoLoteCda.CERTIDAO_GERADA, "dataReferencia", LocalDate.now());
        } else {
            params = Map.of(ID_LOTE_SIMULACAO, idLoteSimulacao, "situacaoLote", SituacaoLoteCda.CERTIDAO_GERADA);
        }
        sql.append(SQLGROUPBY);
        this.setQueryString(sql.toString());
        this.setParameterValues(params);
    }
}

