/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.atualizacaomonetaria;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.repository.parcelamento.AtualizacaoMonetariaItemRepository;
import br.com.elotech.tributos.service.AtualizacaoMonetariaService;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class AtualizacaoMonetariaParcelamentoBatchListener
extends JobExecutionListenerSupport {
    private final NotificacaoService notificacaoService;
    private final AtualizacaoMonetariaItemRepository atualizacaoMonetariaItemRepository;
    private final AtualizacaoMonetariaService atualizacaoMonetariaService;
    private static final String ID_NOTIFICACAO = "idNotificacao";

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idAtualizacaoMonetaria = jobExecution.getJobParameters().getLong("idAtualizacaoMonetaria");
        Optional notificacaoId = this.notificacaoService.send("Atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento iniciada.", String.format("A atualiza\u00e7\u00e3o monet\u00e1ria com c\u00f3digo %d foi iniciada.", idAtualizacaoMonetaria), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idAtualizacaoMonetaria = jobExecution.getJobParameters().getLong("idAtualizacaoMonetaria");
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento finalizada.", String.format("A atualiza\u00e7\u00e3o monet\u00e1ria com c\u00f3digo %d foi finalizada com sucesso.", idAtualizacaoMonetaria), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento falhou.", String.format("A atualiza\u00e7\u00e3o monet\u00e1ria com c\u00f3digo %d foi finalizada com erro", idAtualizacaoMonetaria), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
            if (!this.atualizacaoMonetariaItemRepository.existsByAtualizacaoMonetariaId(idAtualizacaoMonetaria).booleanValue()) {
                this.atualizacaoMonetariaService.delete(idAtualizacaoMonetaria);
            }
        }
    }

    @Generated
    public AtualizacaoMonetariaParcelamentoBatchListener(NotificacaoService notificacaoService, AtualizacaoMonetariaItemRepository atualizacaoMonetariaItemRepository, AtualizacaoMonetariaService atualizacaoMonetariaService) {
        this.notificacaoService = notificacaoService;
        this.atualizacaoMonetariaItemRepository = atualizacaoMonetariaItemRepository;
        this.atualizacaoMonetariaService = atualizacaoMonetariaService;
    }
}

