/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.alteracaocadastroemmassa;

import br.com.elotech.tributos.batch.alteracaocadastroemmassa.EdicaoEmMassaBatchWriter;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CadastroGeralIsencao;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.edicaoemmassa.IEdicaoEmMassa;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioProfissional;
import br.com.elotech.tributos.enums.TipoEdicaoEmMassa;
import br.com.elotech.tributos.repository.CadastroGeralIsencaoRepository;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.ProprietarioRepository;
import br.com.elotech.tributos.repository.mobiliario.MobiliarioProfissionalRepository;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EdicaoEmMassaBatchWriter
implements ItemWriter<IEdicaoEmMassa> {
    private StepExecution stepExecution;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final ProprietarioRepository proprietarioRepository;
    private final CadastroGeralIsencaoRepository cadastroGeralIsencaoRepository;
    private final MobiliarioProfissionalRepository mobiliarioProfissionalRepository;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(@NotNull List<? extends IEdicaoEmMassa> items) throws Exception {
        String tipoEdicaoEmMassa = this.stepExecution.getJobExecution().getJobParameters().getString("tipo");
        TipoEdicaoEmMassa tipo = TipoEdicaoEmMassa.valueOf((String)tipoEdicaoEmMassa);
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$TipoEdicaoEmMassa[tipo.ordinal()]) {
            case 1: {
                this.writeImobiliario(items);
                break;
            }
            case 2: {
                this.writeMobiliario(items);
            }
        }
    }

    public void writeImobiliario(List<? extends IEdicaoEmMassa> items) {
        List cadastros = items.stream().filter(CadastroGeral.class::isInstance).map(CadastroGeral.class::cast).collect(Collectors.toList());
        List proprietarios = cadastros.stream().map(CadastroGeral::getProprietarios).flatMap(Collection::stream).filter(Proprietario::wasChanged).collect(Collectors.toList());
        this.proprietarioRepository.saveAll(proprietarios);
        List isencoes = cadastros.stream().map(CadastroGeral::getCadastroGeralIsencoes).flatMap(Collection::stream).filter(CadastroGeralIsencao::wasChanged).collect(Collectors.toList());
        this.cadastroGeralIsencaoRepository.saveAll(isencoes);
        this.cadastroGeralRepository.saveAll(cadastros);
    }

    public void writeMobiliario(List<? extends IEdicaoEmMassa> items) {
        List mobiliarios = items.stream().filter(CadastroMobiliario.class::isInstance).map(CadastroMobiliario.class::cast).collect(Collectors.toList());
        List profissionaisToRemove = mobiliarios.stream().map(CadastroMobiliario::getCadastroMobiliarioProfissionais).flatMap(Collection::stream).filter(CadastroMobiliarioProfissional::toRemove).collect(Collectors.toList());
        this.mobiliarioProfissionalRepository.deleteAll(profissionaisToRemove);
        List profissionaisToSave = mobiliarios.stream().map(CadastroMobiliario::getCadastroMobiliarioProfissionais).flatMap(Collection::stream).filter(CadastroMobiliarioProfissional::toSave).collect(Collectors.toList());
        this.mobiliarioProfissionalRepository.saveAll(profissionaisToSave);
        this.cadastroGeralRepository.saveAll(mobiliarios);
    }

    @Generated
    public EdicaoEmMassaBatchWriter(CadastroGeralRepository cadastroGeralRepository, ProprietarioRepository proprietarioRepository, CadastroGeralIsencaoRepository cadastroGeralIsencaoRepository, MobiliarioProfissionalRepository mobiliarioProfissionalRepository) {
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.proprietarioRepository = proprietarioRepository;
        this.cadastroGeralIsencaoRepository = cadastroGeralIsencaoRepository;
        this.mobiliarioProfissionalRepository = mobiliarioProfissionalRepository;
    }
}

