/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.BooleanSimNao;
import br.com.elotech.tributos.dto.ComunicadoDebitoConsultaDTO;
import java.time.LocalDate;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoByConsultaDebitoBatchReader
extends JdbcCursorItemReader<ComunicadoDebitoConsultaDTO> {
    private String SQLPATH = "sql/batch/comunicado/comunicadoByConsultaDebito.sql";
    private final String SQLGROUPBY = " group by                                      consultadebito.id,                                      consultadebitoitem.tipocadastro,                                      consultadebitoitem.cadastrogeral,                                      consultadebitoitem.pessoa,                                      tcg.idkey,                                 td.iddebito,                                 pessoa.nome; ";
    private final String ANDVALIDACAODUPLICADO = " and not exists (                            select t.cadastrogeral  from tribcomunicadocadastro t  join tribcomunicado tc on t.exercicio = tc.exercicio and t.entidade = tc.entidade and t.idcomunicado = tc.idcomunicado  where t.tipocadastro = tcg.tipocadastro  and t.cadastrogeral = tcg.cadastrogeral  and tc.datavalidade >= :dataReferencia ) ";

    public ComunicadoByConsultaDebitoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        Long idConsultaDebito = (Long)jobParameters.get("idConsultaDebito");
        BooleanSimNao validacaoComunicadoDuplicado = BooleanSimNao.fromValue((String)((String)jobParameters.get("VALIDACOMUNICADODUPLICADO")));
        this.setFetchSize(1000);
        this.setName("comunicadoDebitoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(ComunicadoDebitoConsultaDTO.class));
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)this.SQLPATH));
        if (BooleanSimNao.SIM.equals((Object)validacaoComunicadoDuplicado)) {
            sql.append(" and not exists (                            select t.cadastrogeral  from tribcomunicadocadastro t  join tribcomunicado tc on t.exercicio = tc.exercicio and t.entidade = tc.entidade and t.idcomunicado = tc.idcomunicado  where t.tipocadastro = tcg.tipocadastro  and t.cadastrogeral = tcg.cadastrogeral  and tc.datavalidade >= :dataReferencia ) ".replace(":dataReferencia", StringUtils.wrap((String)LocalDate.now().toString(), (String)"'")));
        }
        sql.append(" group by                                      consultadebito.id,                                      consultadebitoitem.tipocadastro,                                      consultadebitoitem.cadastrogeral,                                      consultadebitoitem.pessoa,                                      tcg.idkey,                                 td.iddebito,                                 pessoa.nome; ");
        this.setSql(String.format(sql.toString(), idConsultaDebito));
    }
}

