SELECT
  TCSP.TIPOCADASTRO,
  TCSP.CADASTROGERAL,
  TCSP.PESSOA,
  P.NOME NOME,
  P.CNPJ_CPF,
  P.RG,
  P.TIPOPESSOA,
  CT.TELEFONERESIDENCIAL,
  CT.TELEFONECOMERCIAL,
  CT.TELEFONECELULAR,
  CT.EMAIL,  
  LOG.LOGRADOURO,
  LOG.DESCRICAO || ' ' || TLOG.DESCRICAO || ',' || PE.NUMERO DESCLOGRADOURO,
  BR.DESCRICAO BAIRRO,
  CID.DESCRICAO CIDADE,
  CID.UNIDADEFEDERACAO UF  
FROM  TRIBPROPRIETARIO TCSP 
LEFT OUTER JOIN PESSOA P 
     ON P.PESSOA = TCSP.PESSOA 
LEFT OUTER JOIN CONTATOPESSOA CT
     ON CT.PESSOA = P.PESSOA
   AND CT.SEQUENCIA = P.SEQUENCIACONTATO
LEFT OUTER JOIN ENDERECOPESSOA PE 
    ON P.PESSOA = PE.PESSOA 
    AND P.SEQUENCIAENDERECO = PE.SEQUENCIA   
LEFT OUTER JOIN LOGRADOURO LOG 
    ON PE.LOGRADOURO = LOG.LOGRADOURO 
    AND PE.CIDADE = LOG.CIDADE 
LEFT OUTER JOIN TIPOLOGRADOURO TLOG 
    ON LOG.TIPOLOGRADOURO = TLOG.TIPOLOGRADOURO 
LEFT OUTER JOIN CIDADE CID 
    ON LOG.CIDADE = CID.CIDADE 
LEFT OUTER JOIN BAIRRO BR 
    ON PE.CIDADE = BR.CIDADE 
    AND PE.BAIRRO = BR.BAIRRO 
LEFT OUTER JOIN TRIBCADASTROGERAL TCG 
    ON TCSP.TIPOCADASTRO = TCG.TIPOCADASTRO 
    AND TCSP.CADASTROGERAL = TCG.CADASTROGERAL 
LEFT OUTER JOIN TRIBCADASTROMOBILIARIO TCM 
    ON TCM.TIPOCADASTRO = TCG.TIPOCADASTRO 
    AND TCM.CADASTROGERAL = TCG.CADASTROGERAL 
LEFT OUTER JOIN TRIBMOBILIARIOSITUACAO TMSIT 
    ON TMSIT.TIPOCADASTRO = TCM.TIPOCADASTRO 
    AND TMSIT.CADASTROGERAL = TCM.CADASTROGERAL 
    AND TMSIT.ATUAL = 'S'
WHERE TCSP.TIPOCADASTRO = :tipoCadastro
  AND TCSP.CADASTROGERAL = :cadastroGeral