select
    tab.idTipoNaturezaCredito,
    tab.idTipoCredito,
    tab.idTipoOperacaoCredito,
    tab.dtlancamento,
    tab.vlLancamento,
    tab.iddebitoparcelareceita,
    tab.entidade,
    tab.exercicio,
    tab.idDivida,
    tab.idRetencaoContabil,
    tab.divida,
    tab.formacorrecao,
    tab.cdControleLeiAto,
    tab.idDevolucaoCredito
from
    (
        SELECT CASE WHEN (tcrt.tributavel = 'S') THEN 1 ELSE 2 END AS idTipoNaturezaCredito,
               trt.classificacaoreceitatipo                        AS idTipoCredito,
               1                                                   AS idTipoOperacaoCredito,
               CASE
                   WHEN td.datacontabilizacao >= tdp.datalancamento THEN td.datacontabilizacao
                   WHEN td.datainclusao > tdp.datalancamento THEN td.datainclusao
                   ELSE tdp.datalancamento
                   END                                                 AS dtlancamento,
               tdpr.valororiginal                                  AS vlLancamento,
               tdpr.iddebitoparcelareceita,
               td.entidade,
               tdpr.exercicio,
               tgr.idkey                                           AS idDivida,
               0 as idRetencaoContabil,
               tdpr.guiarecolhimento                               AS divida,
               td.formacorrecao,
               tgr.fundamentolegal                                 AS cdControleLeiAto,
               0 as idDevolucaoCredito
        FROM tribdebitoparcelareceita tdpr
                 JOIN tribdebitoparcela tdp ON tdp.entidade = tdpr.entidade AND tdp.exercicio = tdpr.exercicio
            AND tdp.tipocadastro = tdpr.tipocadastro AND tdp.cadastrogeral = tdpr.cadastrogeral
            AND tdp.guiarecolhimento = tdpr.guiarecolhimento AND tdp.subdivida = tdpr.subdivida
            AND tdp.parcela = tdpr.parcela
                 JOIN tribdebito td ON td.entidade = tdp.entidade AND td.exercicio = tdp.exercicio
            AND td.tipocadastro = tdp.tipocadastro AND td.cadastrogeral = tdp.cadastrogeral
            AND td.guiarecolhimento = tdp.guiarecolhimento AND td.subdivida = tdp.subdivida
                 JOIN tribguiarecolhimento tgr ON td.entidade = tgr.entidade AND td.exercicio = tgr.exercicio
            AND td.guiarecolhimento = tgr.guiarecolhimento
                 JOIN tribreceita tr ON tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
            AND tr.entidade = tdpr.entidade
                 JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                 JOIN tribclassificacaoreceitatipo tcrt ON tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                 LEFT JOIN cgato cg ON tgr.entidade = cg.entidade AND tgr.fundamentolegal = cg.idato
        WHERE trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
          AND ((tdp.situacaolegal = 0) OR (tdp.situacaolegal IN (1, 2) AND tdp.datadividaativa >= tdp.datalancamento))
          AND td.entidade = :entidade
          AND td.constituido = 'S'
          AND ((tdpr.valororiginal IS NOT NULL AND tdpr.valororiginal > 0) OR
               (tdpr.valororiginal IS NULL AND tdpr.valor IS NOT NULL AND tdpr.valor > 0))
          AND ((td.datacontabilizacao >= tdp.datalancamento AND td.datacontabilizacao BETWEEN :dataInicial AND :dataFinal)
            OR (((td.datacontabilizacao IS NULL) OR (td.datacontabilizacao < tdp.datalancamento))
                AND ((td.datainclusao >= tdp.datalancamento AND td.datainclusao BETWEEN :dataInicial AND :dataFinal)
                    OR (((td.datainclusao IS NULL) OR (td.datainclusao < tdp.datalancamento))
                        AND tdp.datalancamento BETWEEN :dataInicial AND :dataFinal))
                   )
            OR (td.datacontabilizacao IS NULL AND tgr.tipoguiarecolhimento = 'H'
                AND tdp.datalancamento BETWEEN :dataInicial AND :dataFinal)
            )
          AND NOT EXISTS(
            SELECT 1
            FROM tribparcelamentodebitoorigem tpdo
            WHERE tpdo.iddebitonovo = td.iddebito
        )
          and not exists (select 1 from tribestornoparcelamentodebito tepd
                                            join tribestornoparcelamento tep on tep.idestornoparcelamento = tepd.idestornoparcelamento
                                            join tribparcelamentodebitoorigem tpdo on tpdo.idparcelamento = tep.idparcelamento
                          where tepd.iddebitodestino = td.iddebito
                            and tpdo.iddebito != tepd.iddebitodestino and tep.dataestorno = td.datainclusao)
          AND NOT EXISTS(SELECT 1
                         FROM tcedebitolanccredito tdlc
                         WHERE tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita)
          and not exists(SELECT 1
                         FROM triblivroparcelareceita tlpr
                                  INNER JOIN tribdebitoparcelareceita tdpro
                                             ON tlpr.iddebitoparcelareceita = tdpro.iddebitoparcelareceita
                                  INNER JOIN tribdebitoparcelareceita tdprd ON tdprd.entidade = tdpro.entidade
                             AND tdprd.exercicio = tdpro.exercicio
                             AND tdprd.tipocadastro = tdpro.tipocadastro
                             AND tdprd.cadastrogeral = tdpro.cadastrogeral
                             AND tdprd.guiarecolhimento = tdpro.guiarecolhimento
                             AND tdprd.subdivida = tlpr.novasubdivida
                             AND tdprd.receita = tdpro.receita
                         WHERE tdprd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                           AND tdprd.subdivida != tdpro.subdivida)
          and not exists(select 1
                         from tribpgtonegociadodebitonovo tpndn
                         where tdpr.entidade = tpndn.entidadedestino and tdpr.exercicio = tpndn.exerciciodestino
                            and tdpr.tipocadastro = tpndn.tipocadastrodestino and tdpr.cadastrogeral = tpndn.cadastrogeraldestino
                            and tdpr.guiarecolhimento = tpndn.guiarecolhimentodestino and tdpr.subdivida = tpndn.subdividadestino
                            and tdpr.parcela = tpndn.parceladestino)
        UNION ALL
        select case when (trc.idTipoCredito = 7) then 2 else 1 end as idTipoNaturezaCredito,
               trc.idTipoCredito as idTipoCredito,
               1 as idTipoOperacaoCredito,
               trc.dtlancamento as dtlancamento,
               trc.valor as vlLancamento,
               0 as iddebitoparcelareceita,
               null as entidade,
               null as exercicio,
               null as idDivida,
               trc.idRetencaoContabil,
               null as divida,
               null as formacorrecao,
               (select coalesce(valor,'0')::integer from parametrogeral where parametro = 'LEIATORETENCAOLANCCRED') AS cdControleLeiAto,
               0 as idDevolucaoCredito
        from tceRetencaoContabil trc
        where trc.dtlancamento between :dataInicial and :dataFinal
          and coalesce(trc.devolucao, 'N') = 'N'
          and not exists (
            select 1 from tceRetencaoLancCredito trlc
            where trlc.idRetencaoContabil = trc.idRetencaoContabil
        )
        UNION ALL
        select
                         tcelanccredito.idTipoNaturezaCredito,
                         tcelanccredito.idTipoCredito,
                         tcelanccredito.idTipoOperacaoCredito,
                         tcelanccredito.dtlancamento,
                         tcelanccredito.vlLancamento,
                         tcelanccredito.iddebitoparcelareceita,
                         tcelanccredito.entidade,
               			     tcelanccredito.exercicio,
               			     tcelanccredito.idDivida,
                         tcelanccredito.IdRetencaoContabil,
               			     tcelanccredito.divida,
               			     tcelanccredito.formacorrecao,
               			     tcelanccredito.cdControleLeiAto,
               			     tcelanccredito.idDevolucaoCredito
                    from (
                      select case when (tcrt.tributavel = 'S') then 1 else 2 end as idTipoNaturezaCredito,
                           trt.classificacaoreceitatipo as idTipoCredito,
                           4 as idTipoOperacaoCredito,
                           d.data as dtlancamento,
                           dd.valordevolvido as vlLancamento,
                           tdpr.iddebitoparcelareceita,
                           tmd.idato as cdControleLeiAto,
                           0 as idRetencaoContabil,
                           tgr.idkey AS idDivida,
                           td.entidade,
              			   tdpr.exercicio,
                 		   tdpr.guiarecolhimento AS divida,
               			   td.formacorrecao,
               			   d.iddevolucaocredito as idDevolucaoCredito
                      from tribDevolucaoCredito            d
                         join tribDevolucaoCreditoItem     di   on di.iddevolucaocredito = d.iddevolucaocredito
                         join tribDevolucaoCreditoDebito   dd   on dd.iddevolucaocredito = di.iddevolucaocredito and dd.sequenciaitem = di.sequenciaitem
                         join tribDebitoParcelaReceita     tdpr on dd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                         join tribdebitoparcela            tdp  on tdp.entidade  = tdpr.entidade and tdp.exercicio = tdpr.exercicio
                                                               and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral  = tdpr.cadastrogeral
                                                               and tdp.guiarecolhimento  = tdpr.guiarecolhimento and tdp.subdivida  = tdpr.subdivida
                                                               and tdp.parcela = tdpr.parcela
                         join tribreceita                  tr   on tr.entidade = :entidade
                                                               and tr.exercicio = :exercicio
                                                               and tr.receita = tdpr.receita
                         join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita
                         join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                         join contabancaria                cb   on cb.entidade = d.entidade and cb.contabancaria = d.contabancaria
                         join tribdebito td ON td.entidade = tdp.entidade and td.exercicio = tdp.exercicio
                            and td.tipocadastro = tdp.tipocadastro and td.cadastrogeral = tdp.cadastrogeral
                            and td.guiarecolhimento = tdp.guiarecolhimento and td.subdivida = tdp.subdivida
                         join tribguiarecolhimento tgr ON td.entidade = tgr.entidade and td.exercicio = tgr.exercicio
                            and td.guiarecolhimento = tgr.guiarecolhimento
                         join tribmotivodesconto tmd on tmd.motivodesconto = d.motivodesconto
                         join tribpagamentodebito tpd on tpd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                      where d.entidade = :entidade
                        and d.data between :dataInicial and :dataFinal
                        and d.tipo = 'N'
                        and d.situacao = 'D'
                        and tpd.situacaoLegal = 0
                        and trt.classificacaoreceitatipo in (1,2,3,4,5,7)
                        and coalesce(cb.integraarrecadacao, 'S') = 'S'
                        and not exists (
                            select 1
                            from tcerestituicaolanccredito trlc
                            where trlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                        )
                    ) tcelanccredito
    ) tab
order by tab.dtlancamento, tab.idTipoNaturezaCredito, tab.idTipoCredito