select case when (tcrt.tributavel = 'S') then 1 else 2 end as idTipoNaturezaCredito,
       tcii.classificacaoreceita                           as idTipoCredito,
       2                                                   as idTipoOperacaoCredito,
       tcii.datadividaativa                                as dtInscricao,
       tcii.valor                                          as vlInscricao,
       tcii.iddebitoparcelareceita                         as idDebitoParcelaTributoOrigem,
       tcii.iddebitoparcelareceita                         as idDebitoParcelaTributoDestino,
       null                                                as formaCorrecao,
       tdpr.exercicio                                      as nrAnoBase,
       tcii.fundamentolegal                                as cdControleLeiAto,
       null                                                as nrCredito,
       null                                                as nrAnoCredito
FROM tcecontroleimplantacao tci
JOIN tcecontroleimplantacaoitem tcii ON tci.id = tcii.idcontrole
    left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcii.iddebitoparcelareceita
join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = tcii.classificacaoreceita
left join tcedebitoinsccreditoda tdicd on tcii.iddebitoparcelareceita = tdicd.iddebitoparcelareceita
where tcii.situacaolegal in (1, 2)
  and tcii.IDCONTROLE = :idControle
  and tcii.classificacaoreceita in (1,2,3,4,5,7)
  and tdicd.iddebitoparcelareceita is null
order by tcii.datadividaativa,
         idTipoNaturezaCredito,
         tcii.classificacaoreceita,
         tcii.iddebitoparcelareceita,
         tdpr.exercicio,
         tcii.fundamentolegal;