select iddebito                                as iddebito,
       exercicio                               as exercicio,
       tipocadastro                            as tipocadastro,
       cadastrogeral                           as cadastrogeral,
       tipodivida                              as tipodivida,
       subdivida                               as subdivida,
       sum(valorArquivo)                       as valorArquivo,
       sum(valorIntegrado)                     as valorIntegrado,
       sum(valorArquivo) - sum(valorIntegrado) as valorDiferenca
from (
  select td.exercicio                          AS exercicio,
         tc.descricao                          AS tipocadastro,
         td.cadastrogeral                      AS cadastrogeral,
         tgr.descricao                         AS tipodivida,
         td.subdivida                          AS subdivida,
         sum(coalesce(iip.valor, 0))           AS valorIntegrado,
         0                                     AS valorArquivo,
         td.iddebito                           AS iddebito
  from integracaopatrimonial ip
       join itemintegracaopatrimonial iip on iip.idintegracaopatrimonial  = ip.id
       join tribreceita                tr on tr.receita = iip.tributo and tr.exercicio = ip.exercicio and tr.entidade = ip.entidade
       join tribreceitatipo           trt on trt.tiporeceita = tr.tiporeceita
       join tribdebito                 td on td.iddebito = iip.iddebito
       join tribtipocadastro           tc on tc.tipocadastro = td.tipocadastro
       join tribguiarecolhimento      tgr on tgr.entidade = td.entidade and tgr.exercicio = td.exercicio
                                                and tgr.guiarecolhimento = td.guiarecolhimento
  where ip.datamovimento  between :dataInicial and :dataFinal
        and ip.situacaointegracaopatrimonial <> 'ESTORNADO_CONTABILIDADE'
        and iip.tipomovimento = 'ESTORNO_INSCRICAO'
        and iip.situacaolegal = 0
        and iip.valor > 0
        and trt.classificacaoreceitatipo in (1,2,3,4,5,7)
  group by td.exercicio, tc.descricao, td.cadastrogeral, tgr.descricao, td.subdivida, td.iddebito
  union ALL
  select tdpr.exercicio                                      as exercicio,
         tc.descricao                                       as tipocadastro,
         tdpr.cadastrogeral                                  as cadastrogeral,
         tgr.descricao                                      as tipodivida,
         tdpr.subdivida                                      as subdivida ,
         0                                                  as valorIntegrado,
         sum(coalesce(tdlc.valor, 0))                       as valorArquivo,
         td.iddebito                                        as iddebito
  from tceLancCreditoEst        tlc
    join tcedebitolanccreditoEst  tdlc on tdlc.idtcelanccreditoEst = tlc.idtcelanccreditoEst
    join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tdlc.iddebitoparcelareceita
    join tribdebito                 td on td.cadastrogeral = tdpr.cadastrogeral and td.tipocadastro = tdpr.tipocadastro
                                          and td.guiarecolhimento = tdpr.guiarecolhimento and td.subdivida = tdpr.subdivida
                                          and td.entidade = tdpr.entidade and td.exercicio = tdpr.exercicio
    join tribtipocadastro           tc on tc.tipocadastro = td.tipocadastro
    join tribguiarecolhimento      tgr on tgr.entidade = td.entidade and tgr.exercicio = td.exercicio
                                          and tgr.guiarecolhimento = td.guiarecolhimento
  where tlc.dtEstorno between :dataInicial and :dataFinal
  group by tdpr.exercicio, tc.descricao, tdpr.cadastrogeral, tgr.descricao, tdpr.subdivida, td.iddebito
) filtro
WHERE :whereParam
GROUP BY exercicio, tipocadastro, cadastrogeral, tipodivida, subdivida, iddebito
HAVING :comDiferencaParam
ORDER BY :sortParam