SELECT iddebito                                 AS iddebito,
       exercicio                                AS exercicio,
       tipocadastro                             AS tipocadastro,
       cadastrogeral                            AS cadastrogeral,
       tipodivida                               AS tipodivida,
       subdivida                                AS subdivida ,
       SUM(valorArquivo)                        AS valorArquivo,
       SUM(valorIntegrado)                      AS valorIntegrado,
       SUM(valorArquivo) - SUM(valorIntegrado)  AS valorDiferenca
FROM (
--Integracao patrimonial
  SELECT td.exercicio                 AS exercicio,
         tc.descricao                 AS tipocadastro,
         td.cadastrogeral             AS cadastrogeral,
         tgr.descricao                AS tipodivida,
         td.subdivida                 AS subdivida,
         SUM(COALESCE(iip.valor, 0))  AS valorIntegrado,
         0                            AS valorArquivo,
         td.iddebito                  AS iddebito
  FROM integracaopatrimonial ip
       JOIN itemintegracaopatrimonial iip ON iip.idintegracaopatrimonial  = ip.id
       JOIN tribreceita                tr ON tr.receita = iip.tributo AND tr.exercicio = ip.exercicio
                                             AND tr.entidade = ip.entidade
       JOIN tribreceitatipo           trt ON trt.tiporeceita = tr.tiporeceita
       JOIN tribdebito                 td ON td.iddebito = iip.iddebito
       JOIN tribtipocadastro           tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento      tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                             AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE ip.datamovimento  BETWEEN :dataInicial AND :dataFinal
          AND ip.situacaointegracaopatrimonial <> 'ESTORNADO_CONTABILIDADE'
          and iip.tipomovimento in ('ESTORNO_INSCRICAO')
          AND iip.situacaolegal in(1,2)
          AND trt.classificacaoreceitatipo IN (1,2,3,4,5,7)
  GROUP BY td.exercicio, tc.descricao, td.cadastrogeral, tgr.descricao, td.subdivida, td.iddebito
  UNION ALL
  --Inscrição de crédito em Dívida Ativa
  SELECT     tdpr.exercicio                 AS exercicio,
             tc.descricao                   AS tipocadastro,
             tdpr.cadastrogeral             AS cadastrogeral,
             tgr.descricao                  AS tipodivida,
             tdpr.subdivida                 AS subdivida,
             0                              AS valorIntegrado,
             SUM(COALESCE(dic.valor, 0))  AS valorArquivo,
             td.iddebito                    AS iddebito
 from tceInscCreditoDAest               icd
       join tceDebitoInscCreditoDAest    dic  on dic.idtceinsccreditodaest = icd.idtceinsccreditodaest
       JOIN tribdebitoparcelareceita tdpr  ON tdpr.iddebitoparcelareceita = dic.iddebitoparcelareceita
       JOIN tribdebito                  td ON td.exercicio = tdpr.exercicio  AND td.cadastrogeral = tdpr.cadastrogeral
                                              AND td.tipocadastro = tdpr.tipocadastro AND td.guiarecolhimento = tdpr.guiarecolhimento
                                              AND td.subdivida = tdpr.subdivida AND td.entidade = tdpr.entidade
       JOIN tribtipocadastro            tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento       tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                              AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE icd.dtestorno BETWEEN :dataInicial AND :dataFinal
  GROUP BY tdpr.exercicio, tc.descricao, tdpr.cadastrogeral, tgr.descricao, tdpr.subdivida, td.iddebito
        ) filtro
WHERE :whereParam
GROUP BY exercicio, tipocadastro, cadastrogeral, tipodivida, subdivida, iddebito
HAVING :comDiferencaParam
ORDER BY :sortParam