SELECT iddebito                                 AS iddebito,
       exercicio                                AS exercicio,
       tipocadastro                             AS tipocadastro,
       cadastrogeral                            AS cadastrogeral,
       tipodivida                               AS tipodivida,
       subdivida                                AS subdivida ,
       SUM(valorArquivo)                        AS valorArquivo,
       SUM(valorIntegrado)                      AS valorIntegrado,
       SUM(valorArquivo) - SUM(valorIntegrado)  AS valorDiferenca
FROM (
--Integracao patrimonial
  SELECT td.exercicio                AS exercicio,
         tc.descricao                AS tipocadastro,
         td.cadastrogeral            AS cadastrogeral,
         tgr.descricao               AS tipodivida,
         td.subdivida                AS subdivida,
         SUM(COALESCE(iip.valor, 0)) AS valorIntegrado,
         0                           AS valorArquivo,
         td.iddebito                 AS iddebito
  FROM integracaopatrimonial ip
       JOIN itemintegracaopatrimonial iip ON iip.idintegracaopatrimonial  = ip.id
       JOIN tribreceita                tr ON tr.receita = iip.tributo AND tr.exercicio = ip.exercicio
                                             AND tr.entidade = ip.entidade
       JOIN tribreceitatipo           trt ON trt.tiporeceita = tr.tiporeceita
       JOIN tribdebito                 td ON td.iddebito = iip.iddebito
       JOIN tribtipocadastro           tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento      tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                             AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE ip.datamovimento  BETWEEN :dataInicial AND :dataFinal
        AND ip.situacaointegracaopatrimonial <> 'ESTORNADO_CONTABILIDADE'
        AND iip.tipomovimento = 'ESTORNO_ACRESCIMOS_PARCELAMENTO'
        AND iip.situacaolegal = 0
        AND iip.valor > 0
        AND trt.classificacaoreceitatipo in (1,2,3,4,5,7)
  GROUP BY td.exercicio, tc.descricao, td.cadastrogeral, tgr.descricao, td.subdivida, td.iddebito
  UNION ALL
  --Integracao contábil (financeira)
  SELECT td.exercicio                         AS exercicio,
         tc.descricao                         AS tipocadastro,
         td.cadastrogeral                     AS cadastrogeral,
         tgr.descricao                        AS tipodivida,
         td.subdivida                         AS subdivida,
         SUM(COALESCE(liic.valortributo , 0)) AS valorIntegrado,
         0                                    AS valorArquivo,
         td.iddebito                          AS iddebito
  FROM loteintegracaocontabil lic
       JOIN loteitemintegracaocontabil liic ON liic.idlote = lic.id
       JOIN tribreceita                  tr ON tr.id = liic.idtributo
       JOIN tribreceitatipo             trt ON trt.tiporeceita = tr.tiporeceita
       JOIN tribdebito                   td ON td.iddebito = liic.iddebito
       JOIN tribtipocadastro             tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento        tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                               AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE lic.datalote BETWEEN :dataInicial AND :dataFinal
        AND lic.tipoLote IN ('ESTORNO_PAGAMENTO', 'ESTORNO_CREDITO')
        AND lic.situacaointegracaocontabil <> 'ESTORNADO_CONTABILIDADE'
        AND liic.situacaolegal = 0
        AND liic.valortributo > 0
        AND liic.classificacaotributo IN ('J','M','C','F')
        AND liic.tributoprincipal = 'N'
        AND trt.classificacaoreceitatipo IN (1,2,3,4,5,7)
  GROUP BY td.exercicio, tc.descricao, td.cadastrogeral, tgr.descricao, td.subdivida, td.iddebito
  UNION ALL
  -- Estorno de atualização de pagamento
  SELECT tdpr.exercicio               AS exercicio,
         tc.descricao                 AS tipocadastro,
         tdpr.cadastrogeral           AS cadastrogeral,
         tgr.descricao                AS tipodivida,
         tdpr.subdivida               AS subdivida,
         0                            AS valorIntegrado,
         SUM(COALESCE(tamp.valor, 0)) AS valorArquivo,
         td.iddebito                  AS iddebito
  FROM tceAtualizaMoneCredEst           tam
       JOIN tceAtualizaMonePagamentoEst tamp ON tamp.idTceAtualizaMoneCredEst = tam.idTceAtualizaMoneCredEst
       JOIN tribpagamentodebito         tpd  ON tpd.idpagamentobloqueto = tamp.idpagamentobloqueto
                                                AND tpd.iddebitoparcelareceita = tamp.iddebitoparcelareceita
       JOIN tribpagamentobloqueto       tpb  ON tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
       JOIN tribdebitoparcelareceita    tdpr ON tdpr.iddebitoparcelareceita = tamp.iddebitoparcelareceita
       JOIN tribdebito                    td ON td.exercicio = tdpr.exercicio  AND td.cadastrogeral = tdpr.cadastrogeral
                                                AND td.tipocadastro = tdpr.tipocadastro AND td.guiarecolhimento = tdpr.guiarecolhimento
                                                AND td.subdivida = tdpr.subdivida AND td.entidade = tdpr.entidade
                                                AND td.exercicio = tdpr.exercicio
       JOIN tribtipocadastro              tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento         tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                                AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE tam.dtestorno BETWEEN :dataInicial AND :dataFinal
  GROUP BY tdpr.exercicio, tc.descricao, tdpr.cadastrogeral, tgr.descricao, tdpr.subdivida, td.iddebito
  UNION ALL
  --Estorno de atualizacao Credito Contribuite
  SELECT tdpr.exercicio               AS exercicio,
         tc.descricao                 AS tipocadastro,
         tdpr.cadastrogeral           AS cadastrogeral,
         tgr.descricao                AS tipodivida,
         tdpr.subdivida               AS subdivida,
         0                            AS valorIntegrado,
         SUM(COALESCE(tamc.valor, 0)) AS valorArquivo,
         td.iddebito                  AS iddebito
  FROM tceAtualizaMoneCredEst               tam
       JOIN tceAtualizaMoneCreditoEst   tamc ON tamc.idTceAtualizaMoneCredEst = tam.idTceAtualizaMoneCredEst
       JOIN tribcreditocontribuinteitem tcci ON tcci.idcreditocontribuinteitem = tamc.idcreditocontribuinteitem
                                                AND tcci.iddebitoparcelareceita = tamc.iddebitoparcelareceita
       JOIN tribdebitoparcelareceita    tdpr ON tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
       JOIN tribdebito                    td ON td.exercicio = tdpr.exercicio  AND td.cadastrogeral = tdpr.cadastrogeral
                                                AND td.tipocadastro = tdpr.tipocadastro AND td.guiarecolhimento = tdpr.guiarecolhimento
                                                AND td.subdivida = tdpr.subdivida AND td.entidade = tdpr.entidade
                                                AND td.exercicio = tdpr.exercicio
       JOIN tribtipocadastro              tc ON tc.tipocadastro = td.tipocadastro
       JOIN tribguiarecolhimento         tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                                AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE tam.dtEstorno BETWEEN :dataInicial AND :dataFinal
  GROUP BY tdpr.exercicio, tc.descricao,tdpr.cadastrogeral, tgr.descricao , tdpr.subdivida, td.iddebito
  UNION ALL
  -- Estorno de parcelamento debito de origem
  SELECT tdpr.exercicio                AS exercicio,
         tc.descricao                  AS tipocadastro,
         tdpr.cadastrogeral            AS cadastrogeral,
         tgr.descricao                 AS tipodivida,
         tdpr.subdivida                AS subdivida,
         0                             AS valorIntegrado,
         SUM(COALESCE(tpar.valor, 0))  AS valorArquivo,
         td.iddebito                   AS iddebito
  FROM tceAtualizaMoneCredEst              tam
      LEFT JOIN tceAtualizaMoneParcEst    tpar ON tpar.idTceAtualizaMoneCredEst = tam.idTceAtualizaMoneCredEst
      JOIN tribdebitoParcelaReceita       tdpr ON tdpr.iddebitoParcelaReceita = tpar.iddebitoParcelaReceita
      JOIN tribdebito 	                  td   ON td.entidade = tdpr.entidade AND td.exercicio  = tdpr.exercicio
                                                  AND td.tipocadastro = tdpr.tipocadastro AND td.cadastrogeral = tdpr.cadastrogeral
                                                  AND td.guiarecolhimento = tdpr.guiarecolhimento AND td.subdivida = tdpr.subdivida
      JOIN tribtipocadastro                 tc ON tc.tipocadastro = td.tipocadastro
      JOIN tribguiarecolhimento            tgr ON tgr.entidade = td.entidade AND tgr.exercicio = td.exercicio
                                                  AND tgr.guiarecolhimento = td.guiarecolhimento
  WHERE tam.dtestorno BETWEEN :dataInicial AND :dataFinal
  GROUP BY tdpr.exercicio, tc.descricao, tdpr.cadastrogeral, tgr.descricao, tdpr.subdivida, td.iddebito
) filtro
WHERE :whereParam
GROUP BY exercicio, tipocadastro, cadastrogeral, tipodivida, subdivida, iddebito
HAVING :comDiferencaParam
ORDER BY :sortParam